/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.model.spi.internal;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ast.ImportReference;
import org.eclipse.scout.sdk.core.model.api.IImport;
import org.eclipse.scout.sdk.core.model.api.ISourceRange;
import org.eclipse.scout.sdk.core.model.api.internal.ImportImplementor;
import org.eclipse.scout.sdk.core.model.spi.CompilationUnitSpi;
import org.eclipse.scout.sdk.core.model.spi.ImportSpi;
import org.eclipse.scout.sdk.core.model.spi.JavaElementSpi;
import org.eclipse.scout.sdk.core.model.spi.internal.AbstractJavaElementWithJdt;
import org.eclipse.scout.sdk.core.model.spi.internal.DeclarationCompilationUnitWithJdt;
import org.eclipse.scout.sdk.core.model.spi.internal.JavaEnvironmentWithJdt;

public class DeclarationImportWithJdt
extends AbstractJavaElementWithJdt<IImport>
implements ImportSpi {
    private final ImportReference m_astNode;
    private final DeclarationCompilationUnitWithJdt m_cu;
    private ISourceRange m_source;

    DeclarationImportWithJdt(JavaEnvironmentWithJdt env, DeclarationCompilationUnitWithJdt owner, ImportReference astNode) {
        super(env);
        this.m_astNode = astNode;
        this.m_cu = owner;
    }

    @Override
    protected JavaElementSpi internalFindNewElement(JavaEnvironmentWithJdt newEnv) {
        CompilationUnitSpi newCu = (CompilationUnitSpi)this.getCompilationUnit().internalFindNewElement(newEnv);
        if (newCu != null) {
            for (ImportSpi importSpi : newCu.getImports()) {
                if (!importSpi.getName().equals(this.getName()) || importSpi.isStatic() != this.isStatic()) continue;
                return importSpi;
            }
        }
        return null;
    }

    @Override
    protected IImport internalCreateApi() {
        return new ImportImplementor(this);
    }

    public ImportReference getInternalImportReference() {
        return this.m_astNode;
    }

    @Override
    public String getName() {
        String name = CharOperation.toString((char[][])this.m_astNode.getImportName());
        if (this.m_astNode.trailingStarPosition > 0) {
            name = String.valueOf(name) + ".*";
        }
        return name;
    }

    @Override
    public String getSimpleName() {
        char[][] importName = this.m_astNode.tokens;
        return new String(importName[importName.length - 1]);
    }

    @Override
    public String getQualifier() {
        char[][] importName = this.m_astNode.tokens;
        char[][] qualifier = CharOperation.subarray((char[][])importName, (int)0, (int)(importName.length - 1));
        return CharOperation.toString((char[][])qualifier);
    }

    @Override
    public String getElementName() {
        return this.getName();
    }

    @Override
    public DeclarationCompilationUnitWithJdt getCompilationUnit() {
        return this.m_cu;
    }

    @Override
    public boolean isStatic() {
        return this.m_astNode.isStatic();
    }

    @Override
    public ISourceRange getSource() {
        if (this.m_source == null) {
            ImportReference decl = this.m_astNode;
            this.m_source = this.m_env.getSource(this.m_cu, decl.declarationSourceStart, decl.declarationSourceEnd);
        }
        return this.m_source;
    }
}

