/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.model.spi.internal;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.lang3.Validate;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.ast.AnnotationMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ArrayInitializer;
import org.eclipse.jdt.internal.compiler.ast.CharLiteral;
import org.eclipse.jdt.internal.compiler.ast.ClassLiteralAccess;
import org.eclipse.jdt.internal.compiler.ast.DoubleLiteral;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.FieldReference;
import org.eclipse.jdt.internal.compiler.ast.FloatLiteral;
import org.eclipse.jdt.internal.compiler.ast.IntLiteral;
import org.eclipse.jdt.internal.compiler.ast.Literal;
import org.eclipse.jdt.internal.compiler.ast.LongLiteral;
import org.eclipse.jdt.internal.compiler.ast.MarkerAnnotation;
import org.eclipse.jdt.internal.compiler.ast.MemberValuePair;
import org.eclipse.jdt.internal.compiler.ast.NameReference;
import org.eclipse.jdt.internal.compiler.ast.NormalAnnotation;
import org.eclipse.jdt.internal.compiler.ast.NullLiteral;
import org.eclipse.jdt.internal.compiler.ast.QualifiedAllocationExpression;
import org.eclipse.jdt.internal.compiler.ast.QualifiedNameReference;
import org.eclipse.jdt.internal.compiler.ast.Reference;
import org.eclipse.jdt.internal.compiler.ast.SingleMemberAnnotation;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.ast.UnaryExpression;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.impl.StringConstant;
import org.eclipse.jdt.internal.compiler.lookup.AnnotationBinding;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.BaseTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.ElementValuePair;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.eclipse.jdt.internal.compiler.lookup.MissingTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.VoidTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.WildcardBinding;
import org.eclipse.scout.sdk.core.model.api.IMetaValue;
import org.eclipse.scout.sdk.core.model.spi.AnnotatableSpi;
import org.eclipse.scout.sdk.core.model.spi.AnnotationElementSpi;
import org.eclipse.scout.sdk.core.model.spi.AnnotationSpi;
import org.eclipse.scout.sdk.core.model.spi.FieldSpi;
import org.eclipse.scout.sdk.core.model.spi.JavaElementSpi;
import org.eclipse.scout.sdk.core.model.spi.MemberSpi;
import org.eclipse.scout.sdk.core.model.spi.MethodParameterSpi;
import org.eclipse.scout.sdk.core.model.spi.MethodSpi;
import org.eclipse.scout.sdk.core.model.spi.TypeParameterSpi;
import org.eclipse.scout.sdk.core.model.spi.TypeSpi;
import org.eclipse.scout.sdk.core.model.spi.internal.AstCompiler;
import org.eclipse.scout.sdk.core.model.spi.internal.BindingAnnotationElementWithJdt;
import org.eclipse.scout.sdk.core.model.spi.internal.BindingAnnotationWithJdt;
import org.eclipse.scout.sdk.core.model.spi.internal.BindingFieldWithJdt;
import org.eclipse.scout.sdk.core.model.spi.internal.BindingMethodWithJdt;
import org.eclipse.scout.sdk.core.model.spi.internal.BindingTypeParameterWithJdt;
import org.eclipse.scout.sdk.core.model.spi.internal.BindingTypeWithJdt;
import org.eclipse.scout.sdk.core.model.spi.internal.DeclarationAnnotationWithJdt;
import org.eclipse.scout.sdk.core.model.spi.internal.DeclarationMethodWithJdt;
import org.eclipse.scout.sdk.core.model.spi.internal.DeclarationTypeWithJdt;
import org.eclipse.scout.sdk.core.model.spi.internal.JavaEnvironmentWithJdt;
import org.eclipse.scout.sdk.core.model.spi.internal.SameCompositeObject;
import org.eclipse.scout.sdk.core.model.spi.internal.SourcePositionComparator;
import org.eclipse.scout.sdk.core.model.spi.internal.metavalue.MetaValueFactory;
import org.eclipse.scout.sdk.core.signature.Signature;

public final class SpiWithJdtUtils {
    private SpiWithJdtUtils() {
    }

    static TypeBinding findTypeBinding(String fqn, AstCompiler compiler) {
        char[][] lookupName;
        ReferenceBinding binding;
        block32: {
            Validate.notNull((Object)fqn);
            if (fqn.length() > 7) break block32;
            switch (fqn) {
                case "boolean": {
                    return TypeBinding.BOOLEAN;
                }
                case "char": {
                    return TypeBinding.CHAR;
                }
                case "byte": {
                    return TypeBinding.BYTE;
                }
                case "short": {
                    return TypeBinding.SHORT;
                }
                case "int": {
                    return TypeBinding.INT;
                }
                case "long": {
                    return TypeBinding.LONG;
                }
                case "float": {
                    return TypeBinding.FLOAT;
                }
                case "double": {
                    return TypeBinding.DOUBLE;
                }
                case "void": {
                    return TypeBinding.VOID;
                }
            }
        }
        if ((binding = compiler.lookupEnvironment.getType(lookupName = CharOperation.splitOn((char)'.', (char[])fqn.toCharArray()))) instanceof MissingTypeBinding) {
            return null;
        }
        return binding;
    }

    static TypeSpi bindingToInnerType(JavaEnvironmentWithJdt env, TypeBinding primaryTypeBinding, String innerTypes) {
        if (primaryTypeBinding == null) {
            return null;
        }
        TypeSpi result = SpiWithJdtUtils.bindingToType(env, primaryTypeBinding);
        StringTokenizer st = new StringTokenizer(innerTypes, String.valueOf('$'), false);
        while (st.hasMoreTokens()) {
            String name = st.nextToken();
            TypeSpi innerType = null;
            for (TypeSpi t : result.getTypes()) {
                if (!t.getElementName().equals(name)) continue;
                innerType = t;
                break;
            }
            if (innerType == null) {
                return null;
            }
            result = innerType;
        }
        return result;
    }

    public static TypeSpi bindingToType(JavaEnvironmentWithJdt env, TypeBinding b) {
        return SpiWithJdtUtils.bindingToType(env, b, null);
    }

    static TypeSpi bindingToType(JavaEnvironmentWithJdt env, TypeBinding b, BindingTypeWithJdt declaringType) {
        return SpiWithJdtUtils.bindingToType(env, b, declaringType, false);
    }

    static TypeSpi bindingToType(JavaEnvironmentWithJdt env, TypeBinding b, BindingTypeWithJdt declaringType, boolean isWildCard) {
        if (b instanceof VoidTypeBinding) {
            return env.createVoidType();
        }
        if (b instanceof WildcardBinding) {
            WildcardBinding wb = (WildcardBinding)b;
            TypeBinding allBounds = wb.allBounds();
            if (allBounds == null) {
                return env.createWildcardOnlyType();
            }
            return SpiWithJdtUtils.bindingToType(env, allBounds, declaringType, true);
        }
        if (b instanceof ReferenceBinding) {
            return env.createBindingType((ReferenceBinding)b, declaringType, isWildCard);
        }
        if (b instanceof BaseTypeBinding) {
            return env.createBindingBaseType((BaseTypeBinding)b);
        }
        if (b instanceof ArrayBinding) {
            return env.createBindingArrayType((ArrayBinding)b, isWildCard);
        }
        if (b == null) {
            throw new IllegalArgumentException("TypeBinding cannot be null");
        }
        throw new IllegalStateException("Unsupported binding type: " + b.getClass().getName());
    }

    static int getTypeFlags(int modifiers, QualifiedAllocationExpression allocation, boolean hasDeprecatedAnnotation) {
        boolean isEnumInit;
        int currentModifiers = modifiers;
        boolean bl = isEnumInit = allocation != null && allocation.enumConstant != null;
        if (isEnumInit) {
            currentModifiers |= 0x4000;
        }
        boolean deprecated = hasDeprecatedAnnotation || (currentModifiers & 0x100000) != 0;
        currentModifiers &= 0xFFFF;
        if (deprecated) {
            currentModifiers |= 0x100000;
        }
        return currentModifiers &= 0xFFFFFFDF;
    }

    static int getMethodFlags(int modifiers, boolean isVarargs, boolean isDeprecated) {
        int currentModifiers = modifiers;
        currentModifiers &= 0x10FFFF;
        if (isVarargs) {
            currentModifiers |= 0x80;
        }
        if (isDeprecated) {
            currentModifiers |= 0x100000;
        }
        return currentModifiers;
    }

    static TypeSpi declaringTypeOf(JavaElementSpi owner) {
        if (owner instanceof TypeSpi) {
            return (TypeSpi)owner;
        }
        if (owner instanceof MemberSpi) {
            return ((MemberSpi)owner).getDeclaringType();
        }
        if (owner instanceof TypeParameterSpi) {
            return SpiWithJdtUtils.declaringTypeOf(((TypeParameterSpi)owner).getDeclaringMember());
        }
        if (owner instanceof MethodParameterSpi) {
            return ((MethodParameterSpi)owner).getDeclaringMethod().getDeclaringType();
        }
        if (owner instanceof AnnotationSpi) {
            return SpiWithJdtUtils.declaringTypeOf(((AnnotationSpi)owner).getOwner());
        }
        if (owner instanceof AnnotationElementSpi) {
            return SpiWithJdtUtils.declaringTypeOf(((AnnotationElementSpi)owner).getDeclaringAnnotation());
        }
        return null;
    }

    static Scope memberScopeOf(JavaElementSpi owner) {
        if (owner instanceof TypeSpi) {
            return SpiWithJdtUtils.classScopeOf(owner);
        }
        if (owner instanceof MethodSpi) {
            return SpiWithJdtUtils.methodScopeOf(owner);
        }
        if (owner instanceof TypeParameterSpi) {
            return SpiWithJdtUtils.memberScopeOf(((TypeParameterSpi)owner).getDeclaringMember());
        }
        if (owner instanceof MethodParameterSpi) {
            return SpiWithJdtUtils.methodScopeOf(((MethodParameterSpi)owner).getDeclaringMethod());
        }
        if (owner instanceof AnnotationSpi) {
            return SpiWithJdtUtils.memberScopeOf(((AnnotationSpi)owner).getOwner());
        }
        return null;
    }

    static ClassScope classScopeOf(JavaElementSpi owner) {
        TypeSpi t = SpiWithJdtUtils.declaringTypeOf(owner);
        if (t instanceof BindingTypeWithJdt) {
            ReferenceBinding b = ((BindingTypeWithJdt)t).getInternalBinding();
            if (b instanceof SourceTypeBinding) {
                return ((SourceTypeBinding)b).scope;
            }
        } else if (t instanceof DeclarationTypeWithJdt) {
            return ((DeclarationTypeWithJdt)t).getInternalTypeDeclaration().scope;
        }
        return null;
    }

    static MethodScope methodScopeOf(JavaElementSpi owner) {
        if (owner instanceof BindingMethodWithJdt) {
            AbstractMethodDeclaration d = ((BindingMethodWithJdt)owner).getInternalBinding().sourceMethod();
            if (d != null) {
                return d.scope;
            }
        } else {
            if (owner instanceof DeclarationMethodWithJdt) {
                return ((DeclarationMethodWithJdt)owner).getInternalMethodDeclaration().scope;
            }
            if (owner instanceof TypeParameterSpi) {
                return SpiWithJdtUtils.methodScopeOf(((TypeParameterSpi)owner).getDeclaringMember());
            }
            if (owner instanceof MethodParameterSpi) {
                return SpiWithJdtUtils.methodScopeOf(((MethodParameterSpi)owner).getDeclaringMethod());
            }
            if (owner instanceof AnnotationSpi) {
                return SpiWithJdtUtils.methodScopeOf(((AnnotationSpi)owner).getOwner());
            }
        }
        return null;
    }

    static <T> T nvl(T a, T b) {
        if (a == null) {
            return b;
        }
        return a;
    }

    static Annotation findAnnotationDeclaration(BindingAnnotationWithJdt a) {
        ReferenceBinding b;
        Annotation[] declaredAnnotations = null;
        AnnotatableSpi owner = a.getOwner();
        if (owner instanceof BindingTypeWithJdt) {
            b = ((BindingTypeWithJdt)owner).getInternalBinding();
            if ((b = SpiWithJdtUtils.nvl(b.actualType(), b)) instanceof SourceTypeBinding) {
                declaredAnnotations = ((SourceTypeBinding)b).scope.referenceContext.annotations;
            }
        } else if (owner instanceof BindingMethodWithJdt) {
            b = ((BindingMethodWithJdt)owner).getInternalBinding();
            if ((b = (MethodBinding)SpiWithJdtUtils.nvl(b.original(), b)).sourceMethod() != null) {
                declaredAnnotations = b.sourceMethod().annotations;
            }
        } else if (owner instanceof BindingFieldWithJdt) {
            b = ((BindingFieldWithJdt)owner).getInternalBinding();
            if ((b = (FieldBinding)SpiWithJdtUtils.nvl(b.original(), b)).sourceField() != null) {
                declaredAnnotations = b.sourceField().annotations;
            }
        } else if (owner instanceof BindingTypeParameterWithJdt) {
            b = ((BindingTypeParameterWithJdt)((Object)owner)).getInternalBinding();
            b = (TypeVariableBinding)SpiWithJdtUtils.nvl(b.original(), b);
            if (b.declaringElement instanceof SourceTypeBinding) {
                declaredAnnotations = ((SourceTypeBinding)b.declaringElement).scope.referenceContext.annotations;
            }
        }
        if (declaredAnnotations != null) {
            AnnotationBinding binding = a.getInternalBinding();
            Annotation[] annotationArray = declaredAnnotations;
            int n = declaredAnnotations.length;
            int n2 = 0;
            while (n2 < n) {
                Annotation decl = annotationArray[n2];
                if (decl.getCompilerAnnotation() == binding) {
                    return decl;
                }
                ++n2;
            }
            FindAnnotationVisitor v = new FindAnnotationVisitor(binding);
            Annotation[] annotationArray2 = declaredAnnotations;
            int n3 = declaredAnnotations.length;
            n = 0;
            while (n < n3) {
                Annotation decl = annotationArray2[n];
                decl.traverse((ASTVisitor)v, null);
                if (v.getResult() != null) break;
                ++n;
            }
            return v.getResult();
        }
        return null;
    }

    static MemberValuePair findAnnotationValueDeclaration(BindingAnnotationElementWithJdt a) {
        Annotation annotationDeclaration = SpiWithJdtUtils.findAnnotationDeclaration(a.getDeclaringAnnotation());
        if (annotationDeclaration == null) {
            return null;
        }
        FindMemberValuePairVisitor v = new FindMemberValuePairVisitor(a.getInternalBinding());
        annotationDeclaration.traverse((ASTVisitor)v, null);
        return v.getResult();
    }

    static List<BindingAnnotationWithJdt> createBindingAnnotations(JavaEnvironmentWithJdt env, AnnotatableSpi owner, AnnotationBinding[] annots) {
        if (annots == null || annots.length < 1) {
            return Collections.emptyList();
        }
        ArrayList<BindingAnnotationWithJdt> result = new ArrayList<BindingAnnotationWithJdt>(annots.length);
        int i = 0;
        while (i < annots.length) {
            result.add(env.createBindingAnnotation(owner, annots[i]));
            ++i;
        }
        return Collections.unmodifiableList(result);
    }

    static List<DeclarationAnnotationWithJdt> createDeclarationAnnotations(JavaEnvironmentWithJdt env, AnnotatableSpi owner, Annotation[] annotations) {
        if (annotations == null || annotations.length < 1) {
            return Collections.emptyList();
        }
        ArrayList<DeclarationAnnotationWithJdt> result = new ArrayList<DeclarationAnnotationWithJdt>(annotations.length);
        int i = 0;
        while (i < annotations.length) {
            result.add(env.createDeclarationAnnotation(owner, annotations[i]));
            ++i;
        }
        return Collections.unmodifiableList(result);
    }

    static Object compileExpression(Expression expression, ClassScope scopeForTypeLookup) {
        if (expression == null) {
            return null;
        }
        if (expression instanceof NullLiteral) {
            return expression;
        }
        if (expression instanceof Literal) {
            if (expression.constant == null) {
                ((Literal)expression).computeConstant();
            }
            return expression.constant;
        }
        if (expression instanceof ArrayInitializer) {
            Expression[] array = ((ArrayInitializer)expression).expressions;
            int n = array.length;
            Object[] values = new Object[n];
            if (n > 0) {
                int i = 0;
                while (i < n) {
                    values[i] = SpiWithJdtUtils.compileExpression(array[i], scopeForTypeLookup);
                    ++i;
                }
            }
            return values;
        }
        if (expression instanceof UnaryExpression) {
            Object candidate;
            int id;
            UnaryExpression ue = (UnaryExpression)expression;
            Expression inner = ue.expression;
            if (inner instanceof Literal && (id = SpiWithJdtUtils.getTypeIdForLiteral((Literal)inner)) > 0 && (candidate = SpiWithJdtUtils.compileExpression(inner, scopeForTypeLookup)) instanceof Constant) {
                Constant opConstant = Constant.computeConstantOperation((Constant)((Constant)candidate), (int)id, (int)((expression.bits & 0xFC0) >> 6));
                return opConstant;
            }
        } else if (expression instanceof ClassLiteralAccess) {
            TypeReference type;
            TypeBinding val = ((ClassLiteralAccess)expression).targetType;
            if (val == null && (type = ((ClassLiteralAccess)expression).type) != null) {
                if (type.resolvedType == null && scopeForTypeLookup != null) {
                    type.resolveType(scopeForTypeLookup);
                }
                val = type.resolvedType;
            }
            return val;
        }
        if (expression instanceof Annotation) {
            Annotation annotation = (Annotation)expression;
            AnnotationBinding compilerAnnotation = annotation.getCompilerAnnotation();
            if (compilerAnnotation == null) {
                annotation.resolveType((BlockScope)scopeForTypeLookup.referenceContext.staticInitializerScope);
            }
            return annotation.getCompilerAnnotation();
        }
        if (expression instanceof Reference) {
            FieldBinding fieldBinding = null;
            if (expression instanceof FieldReference) {
                fieldBinding = ((FieldReference)expression).fieldBinding();
            } else if (expression instanceof NameReference) {
                Binding binding = ((NameReference)expression).binding;
                if (binding != null && binding.kind() == 1) {
                    fieldBinding = (FieldBinding)binding;
                } else if (expression instanceof QualifiedNameReference) {
                    ReferenceBinding ref;
                    FieldBinding field;
                    char[][] tokens = ((QualifiedNameReference)expression).tokens;
                    TypeBinding baseType = scopeForTypeLookup.getType(tokens, tokens.length - 1);
                    if (baseType instanceof ReferenceBinding && (field = (ref = (ReferenceBinding)baseType).getField(tokens[tokens.length - 1], true)) != null) {
                        return field;
                    }
                    String str = CharOperation.toString((char[][])tokens);
                    return StringConstant.fromValue((String)str);
                }
            }
            if (fieldBinding != null) {
                return fieldBinding;
            }
        }
        return ElementValuePair.getValue((Expression)expression);
    }

    static IMetaValue resolveCompiledValue(JavaEnvironmentWithJdt env, AnnotatableSpi owner, Object compiledValue) {
        if (compiledValue == null || Constant.NotAConstant.equals(compiledValue)) {
            return null;
        }
        if (compiledValue instanceof NullLiteral) {
            return MetaValueFactory.createNull();
        }
        if (compiledValue instanceof Constant) {
            return MetaValueFactory.createFromConstant((Constant)compiledValue);
        }
        if (compiledValue instanceof TypeBinding) {
            return MetaValueFactory.createFromType(SpiWithJdtUtils.bindingToType(env, (TypeBinding)compiledValue));
        }
        if (compiledValue instanceof FieldBinding) {
            FieldBinding fb = (FieldBinding)compiledValue;
            TypeSpi type = SpiWithJdtUtils.bindingToType(env, (TypeBinding)fb.declaringClass);
            String name = new String(fb.name);
            for (FieldSpi f : type.getFields()) {
                if (!f.getElementName().equals(name)) continue;
                return MetaValueFactory.createFromEnum(f);
            }
            return MetaValueFactory.createUnknown("ENUM " + fb.declaringClass.debugName() + '#' + name);
        }
        if (compiledValue instanceof AnnotationBinding) {
            AnnotationBinding a = (AnnotationBinding)compiledValue;
            return MetaValueFactory.createFromAnnotation(env.createBindingAnnotation(owner, a));
        }
        if (compiledValue.getClass().isArray()) {
            int n = Array.getLength(compiledValue);
            IMetaValue[] metaArray = new IMetaValue[n];
            if (n > 0) {
                int i = 0;
                while (i < n) {
                    metaArray[i] = SpiWithJdtUtils.resolveCompiledValue(env, owner, Array.get(compiledValue, i));
                    ++i;
                }
            }
            return MetaValueFactory.createArray(metaArray);
        }
        return MetaValueFactory.createUnknown(compiledValue);
    }

    static int getTypeIdForLiteral(Literal l) {
        if (l instanceof LongLiteral) {
            return 7;
        }
        if (l instanceof IntLiteral) {
            return 10;
        }
        if (l instanceof FloatLiteral) {
            return 9;
        }
        if (l instanceof DoubleLiteral) {
            return 8;
        }
        if (l instanceof CharLiteral) {
            return 2;
        }
        return -1;
    }

    static TypeDescriptor getTypeDescriptor(String fqn) {
        int firstDollarPos = fqn.indexOf(36);
        int arrayDim = SpiWithJdtUtils.getArrayDimension(fqn);
        if (arrayDim > 0) {
            fqn = fqn.substring(0, fqn.length() - arrayDim * 2);
        }
        if (firstDollarPos > 0) {
            String primaryType = fqn.substring(0, firstDollarPos);
            String innerTypePart = fqn.substring(firstDollarPos + 1);
            return new TypeDescriptor(primaryType, innerTypePart, arrayDim);
        }
        return new TypeDescriptor(fqn, null, arrayDim);
    }

    private static int getArrayDimension(String fqn) {
        int pos = fqn.indexOf("[]");
        if (pos < 0) {
            return 0;
        }
        return (fqn.length() - pos) / 2;
    }

    static boolean hasDeprecatedAnnotation(AnnotationBinding[] annotations) {
        if (annotations == null) {
            return false;
        }
        int i = 0;
        int length = annotations.length;
        while (i < length) {
            AnnotationBinding annotation = annotations[i];
            if (CharOperation.equals((char[])annotation.getAnnotationType().sourceName, (char[])TypeConstants.JAVA_LANG_DEPRECATED[2])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    static boolean hasDeprecatedAnnotation(Annotation[] annotations) {
        if (annotations == null) {
            return false;
        }
        int i = 0;
        int length = annotations.length;
        while (i < length) {
            Annotation annotation = annotations[i];
            if (CharOperation.equals((char[])annotation.type.getLastToken(), (char[])TypeConstants.JAVA_LANG_DEPRECATED[2])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    static Map<String, ElementValuePair> getBindingAnnotationSyntheticDefaultValues(JavaEnvironmentWithJdt env, ReferenceBinding annotationType) {
        SameCompositeObject key;
        Map<Object, Object> cache = env.getPerformanceCache();
        Map<String, ElementValuePair> defaultValues = (Map<String, ElementValuePair>)cache.get(key = new SameCompositeObject(annotationType, "defaultEvp"));
        if (defaultValues == null) {
            MethodBinding[] valueMethods = annotationType.methods();
            if (valueMethods == null || valueMethods.length < 1) {
                defaultValues = Collections.emptyMap();
            } else {
                valueMethods = Arrays.copyOf(valueMethods, valueMethods.length);
                Arrays.sort(valueMethods, new SourcePositionComparator());
                defaultValues = new LinkedHashMap(valueMethods.length);
                MethodBinding[] methodBindingArray = valueMethods;
                int n = valueMethods.length;
                int n2 = 0;
                while (n2 < n) {
                    MethodBinding mb = methodBindingArray[n2];
                    String name = new String(mb.selector);
                    Object value = mb.getDefaultValue();
                    if (value != null) {
                        defaultValues.put(name, new ElementValuePair(mb.selector, value, mb));
                    } else {
                        defaultValues.put(name, null);
                    }
                    ++n2;
                }
            }
            cache.put(key, defaultValues);
        }
        return new LinkedHashMap<String, ElementValuePair>(defaultValues);
    }

    static Map<String, MemberValuePair> getDeclarationAnnotationSyntheticDefaultValues(JavaEnvironmentWithJdt env, TypeBinding typeBinding) {
        SameCompositeObject key;
        Map<Object, Object> cache = env.getPerformanceCache();
        Map<String, MemberValuePair> defaultValues = (Map<String, MemberValuePair>)cache.get(key = new SameCompositeObject(typeBinding, "defaultMvp"));
        if (defaultValues == null) {
            MethodBinding[] valueMethods = ((ReferenceBinding)typeBinding).methods();
            if (valueMethods == null || valueMethods.length < 1) {
                defaultValues = Collections.emptyMap();
            } else {
                defaultValues = new LinkedHashMap(valueMethods.length);
                valueMethods = Arrays.copyOf(valueMethods, valueMethods.length);
                Arrays.sort(valueMethods, new SourcePositionComparator());
                MethodBinding[] methodBindingArray = valueMethods;
                int n = valueMethods.length;
                int n2 = 0;
                while (n2 < n) {
                    MethodBinding mb = methodBindingArray[n2];
                    String name = new String(mb.selector);
                    AbstractMethodDeclaration md0 = mb.sourceMethod();
                    if (md0 instanceof AnnotationMethodDeclaration) {
                        AnnotationMethodDeclaration md = (AnnotationMethodDeclaration)md0;
                        if (md.defaultValue != null) {
                            defaultValues.put(name, new MemberValuePair(mb.selector, md.defaultValue.sourceStart, md.defaultValue.sourceEnd, md.defaultValue));
                        } else {
                            defaultValues.put(name, null);
                        }
                    }
                    ++n2;
                }
            }
            cache.put(key, defaultValues);
        }
        return new LinkedHashMap<String, MemberValuePair>(defaultValues);
    }

    public static String createMethodId(MethodSpi m) {
        StringBuilder buf = new StringBuilder();
        buf.append(m.getElementName());
        buf.append('(');
        for (MethodParameterSpi p : m.getParameters()) {
            buf.append(Signature.createTypeSignature(p.getDataType().getName()));
            buf.append(',');
        }
        buf.append(')');
        return buf.toString();
    }

    private static final class FindAnnotationVisitor
    extends ASTVisitor {
        private final AnnotationBinding m_binding;
        private Annotation m_result;

        private FindAnnotationVisitor(AnnotationBinding binding) {
            this.m_binding = binding;
        }

        public Annotation getResult() {
            return this.m_result;
        }

        public boolean visit(MarkerAnnotation annotation, BlockScope scope) {
            return this.internalVisit((Annotation)annotation);
        }

        public boolean visit(NormalAnnotation annotation, BlockScope scope) {
            return this.internalVisit((Annotation)annotation);
        }

        public boolean visit(SingleMemberAnnotation annotation, BlockScope scope) {
            return this.internalVisit((Annotation)annotation);
        }

        private boolean internalVisit(Annotation annotation) {
            if (annotation.getCompilerAnnotation() == this.m_binding) {
                this.m_result = annotation;
            }
            return this.m_result == null;
        }
    }

    private static final class FindMemberValuePairVisitor
    extends ASTVisitor {
        private final ElementValuePair m_binding;
        private MemberValuePair m_result;

        private FindMemberValuePairVisitor(ElementValuePair binding) {
            this.m_binding = binding;
        }

        public MemberValuePair getResult() {
            return this.m_result;
        }

        public boolean visit(MemberValuePair pair, BlockScope scope0) {
            if (pair.compilerElementPair == this.m_binding) {
                this.m_result = pair;
            }
            return this.m_result == null;
        }
    }

    static final class TypeDescriptor {
        final String m_primaryTypeName;
        final String m_innerTypeNames;
        final int m_arrayDimension;

        boolean hasInnerType() {
            return this.m_innerTypeNames != null;
        }

        private TypeDescriptor(String primaryTypeName, String innerTypeNames, int arrayDimension) {
            this.m_primaryTypeName = primaryTypeName;
            this.m_innerTypeNames = innerTypeNames;
            this.m_arrayDimension = arrayDimension;
        }
    }
}

