/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.model.sugar;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import org.eclipse.scout.sdk.core.model.api.IMethod;
import org.eclipse.scout.sdk.core.model.api.IType;
import org.eclipse.scout.sdk.core.model.api.internal.WrappedList;
import org.eclipse.scout.sdk.core.signature.SignatureUtils;

public class SuperMethodQuery {
    private final IMethod m_method;
    private final String m_methodId;
    private boolean m_includeSelf = true;
    private boolean m_includeSuperClasses = true;
    private boolean m_includeSuperInterfaces = true;
    private Predicate<IMethod> m_filter;
    private int m_maxResultCount = Integer.MAX_VALUE;

    public SuperMethodQuery(IMethod method) {
        this.m_method = method;
        this.m_methodId = SignatureUtils.createMethodIdentifier(method);
    }

    public SuperMethodQuery withSelf(boolean b) {
        this.m_includeSelf = b;
        return this;
    }

    public SuperMethodQuery withSuperTypes(boolean b) {
        this.m_includeSuperClasses = b;
        this.m_includeSuperInterfaces = b;
        return this;
    }

    public SuperMethodQuery withSuperClasses(boolean b) {
        this.m_includeSuperClasses = b;
        return this;
    }

    public SuperMethodQuery withSuperInterfaces(boolean b) {
        this.m_includeSuperInterfaces = b;
        return this;
    }

    public SuperMethodQuery withFilter(Predicate<IMethod> filter) {
        this.m_filter = filter;
        return this;
    }

    public SuperMethodQuery withMaxResultCount(int maxResultCount) {
        this.m_maxResultCount = maxResultCount;
        return this;
    }

    protected boolean accept(IMethod m) {
        if (!this.m_includeSelf && this.m_method == m) {
            return false;
        }
        if (!this.m_methodId.equals(SignatureUtils.createMethodIdentifier(m))) {
            return false;
        }
        return this.m_filter == null || this.m_filter.test(m);
    }

    protected void visitRec(IType t, List<IMethod> result, int maxCount, boolean onlyTraverse) {
        if (t == null) {
            return;
        }
        if (!onlyTraverse) {
            for (IMethod m : new WrappedList(t.unwrap().getMethods())) {
                if (!this.accept(m)) continue;
                result.add(m);
                if (result.size() < maxCount) continue;
                return;
            }
        }
        if (this.m_includeSuperClasses || this.m_includeSuperInterfaces) {
            this.visitRec(t.superClass(), result, maxCount, !this.m_includeSuperClasses);
            if (result.size() >= maxCount) {
                return;
            }
        }
        if (this.m_includeSuperInterfaces) {
            for (IType superInterface : t.superInterfaces()) {
                this.visitRec(superInterface, result, maxCount, false);
                if (result.size() < maxCount) continue;
                return;
            }
        }
    }

    public boolean existsAny() {
        return this.first() != null;
    }

    public IMethod first() {
        ArrayList<IMethod> result = new ArrayList<IMethod>(1);
        this.visitRec(this.m_method.declaringType(), result, 1, false);
        return result.isEmpty() ? null : (IMethod)result.get(0);
    }

    public List<IMethod> list() {
        ArrayList<IMethod> result = new ArrayList<IMethod>();
        this.visitRec(this.m_method.declaringType(), result, this.m_maxResultCount, false);
        return result;
    }
}

