/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.util;

import java.util.function.Predicate;
import org.eclipse.scout.sdk.core.model.api.Flags;
import org.eclipse.scout.sdk.core.model.api.IType;

public final class TypeFilters {
    private static final Predicate<IType> TOP_LEVEL_FILTER = new Predicate<IType>(){

        @Override
        public boolean test(IType type) {
            return type != null && type.declaringType() == null;
        }
    };
    private static final Predicate<IType> NO_GENERIC_FILTER = new Predicate<IType>(){

        @Override
        public boolean test(IType type) {
            return !type.hasTypeParameters();
        }
    };
    private static final Predicate<IType> NO_SURROUNDING_CONTEXT_TYPE_FILTER = new Predicate<IType>(){

        @Override
        public boolean test(IType type) {
            return type != null && !type.isParameterType() && (type.declaringType() == null || Flags.isStatic(type.flags()));
        }
    };

    private TypeFilters() {
    }

    public static Predicate<IType> instanceOf(final String type) {
        return new Predicate<IType>(){

            @Override
            public boolean test(IType candidate) {
                return candidate.isInstanceOf(type);
            }
        };
    }

    public static Predicate<IType> primaryType() {
        return TOP_LEVEL_FILTER;
    }

    public static Predicate<IType> noSurroundingContext() {
        return NO_SURROUNDING_CONTEXT_TYPE_FILTER;
    }

    public static Predicate<IType> noGenerics() {
        return NO_GENERIC_FILTER;
    }
}

