/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.javaeditor;

import java.util.List;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.util.JdtFlags;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.actions.SelectionConverter;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.javaeditor.JavaElementHyperlinkDetector;
import org.eclipse.jdt.internal.ui.javaeditor.JavaElementSuperImplementationHyperlink;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.hyperlink.IHyperlink;

public class JavaElementHyperlinkSuperImplementationDetector
extends JavaElementHyperlinkDetector {
    @Override
    protected void addHyperlinks(List<IHyperlink> hyperlinksCollector, IRegion wordRegion, SelectionDispatchAction openAction, IJavaElement element, boolean qualify, JavaEditor editor) {
        if (element.getElementType() == 9 && SelectionConverter.canOperateOn(editor) && this.isOverriddenMethod((IMethod)element)) {
            hyperlinksCollector.add(new JavaElementSuperImplementationHyperlink(wordRegion, openAction, (IMethod)element, qualify));
        }
    }

    private boolean isOverriddenMethod(IMethod method) {
        block4: {
            if (!JdtFlags.isPrivate((IMember)method) && !JdtFlags.isStatic((IMember)method) && !method.isConstructor()) break block4;
            return false;
        }
        try {
            if (JavaElementSuperImplementationHyperlink.findSuperImplementation(method) != null) {
                return true;
            }
        }
        catch (JavaModelException e) {
            JavaPlugin.log(e);
        }
        return false;
    }
}

