/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.s.project;

import java.io.File;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Result;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.eclipse.scout.sdk.core.s.util.maven.MavenBuild;
import org.eclipse.scout.sdk.core.s.util.maven.MavenRunner;
import org.eclipse.scout.sdk.core.util.CoreUtils;
import org.eclipse.scout.sdk.core.util.SdkLog;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public final class ScoutProjectNewHelper {
    public static final String SCOUT_ARCHETYPES_VERSION = "7.0.100.017_Oxygen_1";
    public static final String SCOUT_ARCHETYPES_HELLOWORLD_ARTIFACT_ID = "scout-helloworld-app";
    public static final String SCOUT_ARCHETYPES_GROUP_ID = "org.eclipse.scout.archetypes";
    public static final Pattern DISPLAY_NAME_PATTERN = Pattern.compile("[^\"\\/<>=:]+");
    public static final Pattern SYMBOLIC_NAME_PATTERN = Pattern.compile("^[a-z]{1}[a-z0-9_]{0,32}(\\.[a-z]{1}[a-z0-9_]{0,32}){0,16}$");
    public static final String DEFAULT_JAVA_ENV = "1.8";

    private ScoutProjectNewHelper() {
    }

    public static void createProject(File workingDir, String groupId, String artifactId, String displayName) throws IOException {
        ScoutProjectNewHelper.createProject(workingDir, groupId, artifactId, displayName, null);
    }

    public static void createProject(File workingDir, String groupId, String artifactId, String displayName, String javaVersion) throws IOException {
        ScoutProjectNewHelper.createProject(workingDir, groupId, artifactId, displayName, javaVersion, null, null, null);
    }

    public static void createProject(File workingDir, String groupId, String artifactId, String displayName, String javaVersion, String archetypeGroupId, String archeTypeArtifactId, String archetypeVersion) throws IOException {
        Validate.notNull((Object)workingDir);
        String groupIdMsg = ScoutProjectNewHelper.getMavenNameErrorMessage(groupId, "groupId");
        if (groupIdMsg != null) {
            throw new IllegalArgumentException(groupIdMsg);
        }
        String artifactIdMsg = ScoutProjectNewHelper.getMavenNameErrorMessage(artifactId, "artifactId");
        if (artifactIdMsg != null) {
            throw new IllegalArgumentException(artifactIdMsg);
        }
        String displayNameMsg = ScoutProjectNewHelper.getDisplayNameErrorMEssage(displayName);
        if (displayNameMsg != null) {
            throw new IllegalArgumentException(displayNameMsg);
        }
        if (StringUtils.isEmpty((CharSequence)javaVersion)) {
            javaVersion = DEFAULT_JAVA_ENV;
        }
        if (StringUtils.isBlank((CharSequence)archetypeGroupId) || StringUtils.isBlank((CharSequence)archeTypeArtifactId) || StringUtils.isBlank((CharSequence)archetypeVersion)) {
            archetypeGroupId = SCOUT_ARCHETYPES_GROUP_ID;
            archeTypeArtifactId = SCOUT_ARCHETYPES_HELLOWORLD_ARTIFACT_ID;
            archetypeVersion = SCOUT_ARCHETYPES_VERSION;
        }
        String pck = null;
        pck = groupId.equals(artifactId) ? artifactId : groupId + '.' + artifactId;
        String[] authKeysForWar = ScoutProjectNewHelper.generateKeyPair();
        String[] authKeysForDev = ScoutProjectNewHelper.generateKeyPair();
        MavenBuild archetypeBuild = new MavenBuild().withWorkingDirectory(workingDir).withGoal("archetype:generate").withOption('B').withProperty("archetypeGroupId", archetypeGroupId).withProperty("archetypeArtifactId", archeTypeArtifactId).withProperty("archetypeVersion", archetypeVersion).withProperty("groupId", groupId).withProperty("artifactId", artifactId).withProperty("version", "1.0.0-SNAPSHOT").withProperty("package", pck).withProperty("displayName", displayName).withProperty("scoutAuthPublicKey", authKeysForWar[1]).withProperty("scoutAuthPrivateKey", authKeysForWar[0]).withProperty("scoutAuthPublicKeyDev", authKeysForDev[1]).withProperty("scoutAuthPrivateKeyDev", authKeysForDev[0]).withProperty("javaVersion", javaVersion).withProperty("userName", CoreUtils.getUsername());
        MavenRunner.execute(archetypeBuild);
        ScoutProjectNewHelper.postProcessRootPom(new File(workingDir, artifactId));
    }

    static String[] generateKeyPair() {
        try {
            return CoreUtils.generateKeyPair();
        }
        catch (GeneralSecurityException e) {
            SdkLog.warning((String)"Could not generate a new key pair.", (Object[])new Object[]{e});
            String keyPlaceholder = "TODO_use_org.eclipse.scout.rt.platform.security.SecurityUtility.main(String[]))";
            return new String[]{keyPlaceholder, keyPlaceholder};
        }
    }

    static void postProcessRootPom(File targetDirectory) throws IOException {
        try {
            File pom = new File(targetDirectory, "pom.xml");
            if (!pom.isFile()) {
                return;
            }
            DocumentBuilder docBuilder = CoreUtils.createDocumentBuilder();
            Document doc = docBuilder.parse(pom);
            Element modules = CoreUtils.getFirstChildElement((Element)doc.getDocumentElement(), (String)"modules");
            NodeList childNodes = modules.getChildNodes();
            ArrayList<Node> nodesToRemove = new ArrayList<Node>();
            int i = 0;
            while (i < childNodes.getLength()) {
                Node n = childNodes.item(i);
                if (n.getNodeType() == 3 || n.getNodeType() == 1 && "module".equals(((Element)n).getTagName()) && !targetDirectory.getName().equals(n.getTextContent().trim())) {
                    nodesToRemove.add(n);
                }
                ++i;
            }
            for (Node n : nodesToRemove) {
                modules.removeChild(n);
            }
            Validate.isTrue((modules.getChildNodes().getLength() == 1 ? 1 : 0) != 0, (String)"Parent module is missing in root pom.", (Object[])new Object[0]);
            ScoutProjectNewHelper.writeDocument(doc, new StreamResult(pom));
        }
        catch (ParserConfigurationException | TransformerException | SAXException e) {
            throw new IOException(e);
        }
    }

    static void writeDocument(Document document, Result result) throws TransformerException {
        Transformer transformer = CoreUtils.createTransformer((boolean)false);
        transformer.transform(new DOMSource(document), result);
    }

    public static String getDisplayNameErrorMEssage(String displayNameCandidate) {
        if (StringUtils.isEmpty((CharSequence)displayNameCandidate)) {
            return "Display Name is not set.";
        }
        if (!DISPLAY_NAME_PATTERN.matcher(displayNameCandidate).matches()) {
            return "The Display Name must not contain these characters: \\\"/<>:=";
        }
        return null;
    }

    public static String getMavenNameErrorMessage(String symbolicNameCandidate, String attribName) {
        if (StringUtils.isEmpty((CharSequence)symbolicNameCandidate)) {
            return String.valueOf(attribName) + " is not set.";
        }
        if (!SYMBOLIC_NAME_PATTERN.matcher(symbolicNameCandidate).matches()) {
            return "The " + attribName + " value is not valid.";
        }
        String jkw = ScoutProjectNewHelper.getContainingJavaKeyWord(symbolicNameCandidate);
        if (jkw != null) {
            return "The " + attribName + " must not contain the Java keyword '" + jkw + "'.";
        }
        return null;
    }

    private static String getContainingJavaKeyWord(String s) {
        for (String keyWord : CoreUtils.getJavaKeyWords()) {
            if (!s.startsWith(String.valueOf(keyWord) + ".") && !s.endsWith("." + keyWord) && !s.contains("." + keyWord + ".")) continue;
            return keyWord;
        }
        return null;
    }
}

