/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.s.sourcebuilder.form;

import java.util.Arrays;
import org.apache.commons.lang3.Validate;
import org.eclipse.jdt.internal.compiler.util.SuffixConstants;
import org.eclipse.scout.sdk.core.importvalidator.IImportValidator;
import org.eclipse.scout.sdk.core.model.api.IJavaEnvironment;
import org.eclipse.scout.sdk.core.s.annotation.FormDataAnnotation;
import org.eclipse.scout.sdk.core.s.model.ScoutAnnotationSourceBuilderFactory;
import org.eclipse.scout.sdk.core.s.model.ScoutMethodSourceBuilderFactory;
import org.eclipse.scout.sdk.core.signature.Signature;
import org.eclipse.scout.sdk.core.sourcebuilder.IAnnotatableSourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.ISourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.SortedMemberKeyFactory;
import org.eclipse.scout.sdk.core.sourcebuilder.comment.CommentSourceBuilderFactory;
import org.eclipse.scout.sdk.core.sourcebuilder.compilationunit.AbstractEntitySourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.compilationunit.ICompilationUnitSourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.method.IMethodSourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.method.MethodSourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.method.MethodSourceBuilderFactory;
import org.eclipse.scout.sdk.core.sourcebuilder.type.ITypeSourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.type.TypeSourceBuilder;
import org.eclipse.scout.sdk.core.util.CoreUtils;
import org.eclipse.scout.sdk.core.util.PropertyMap;

public class FormSourceBuilder
extends AbstractEntitySourceBuilder {
    public static final String STORE_METHOD_NAME = "execStore";
    public static final String LOAD_METHOD_NAME = "execLoad";
    public static final String SERVICE_LOAD_METHOD_NAME = "load";
    public static final String SERVICE_STORE_METHOD_NAME = "store";
    public static final String MODIFY_HANDLER_NAME = "ModifyHandler";
    public static final String SERVICE_PREPARECREATE_METHOD_NAME = "prepareCreate";
    public static final String SERVICE_CREATE_METHOD_NAME = "create";
    public static final String NEW_HANDLER_NAME = "NewHandler";
    public static final int NUM_CLASS_IDS = 4;
    private String m_formDataSignature;
    private String m_superTypeSignature;
    private String m_serviceIfcSignature;
    private String m_updatePermissionSignature;
    private String m_createPermissionSignature;
    private String[] m_classIdValues;
    private ITypeSourceBuilder m_formBuilder;

    public FormSourceBuilder(String formName, String packageName, IJavaEnvironment env) {
        super(formName, packageName, env);
    }

    public void setup() {
        this.setComment(CommentSourceBuilderFactory.createDefaultCompilationUnitComment((ICompilationUnitSourceBuilder)this));
        this.m_formBuilder = new TypeSourceBuilder(this.getEntityName());
        this.m_formBuilder.setFlags(1);
        this.m_formBuilder.setSuperTypeSignature(this.getSuperTypeSignature());
        this.addType(this.m_formBuilder);
        if (this.getFormDataSignature() != null) {
            this.m_formBuilder.addAnnotation(ScoutAnnotationSourceBuilderFactory.createFormData(this.getFormDataSignature(), FormDataAnnotation.SdkCommand.CREATE, null));
        }
        this.addClassId((IAnnotatableSourceBuilder)this.m_formBuilder, 0);
        this.addGetConfiguredTitle();
        this.createMainBox();
        this.createStartMethod("startModify", MODIFY_HANDLER_NAME);
        this.createStartMethod("startNew", NEW_HANDLER_NAME);
        this.createHandler(NEW_HANDLER_NAME);
        this.createHandler(MODIFY_HANDLER_NAME);
    }

    protected void addGetConfiguredTitle() {
        String nlsKeyName = this.getEntityName();
        if (nlsKeyName.endsWith("Form")) {
            nlsKeyName = CoreUtils.ensureStartWithUpperCase((String)nlsKeyName.substring(0, nlsKeyName.length() - "Form".length()));
        }
        IMethodSourceBuilder getConfiguredTitle = ScoutMethodSourceBuilderFactory.createNlsMethod("getConfiguredTitle", nlsKeyName);
        this.m_formBuilder.addSortedMethod(SortedMemberKeyFactory.createMethodGetConfiguredKey((IMethodSourceBuilder)getConfiguredTitle), getConfiguredTitle);
    }

    protected void createStartMethod(String methodName, final String handlerSimpleName) {
        MethodSourceBuilder startModifyBuilder = new MethodSourceBuilder(methodName);
        startModifyBuilder.setFlags(1);
        startModifyBuilder.setReturnTypeSignature("V");
        startModifyBuilder.setBody(new ISourceBuilder(){

            public void createSource(StringBuilder source, String lineDelimiter, PropertyMap context, IImportValidator validator) {
                String modifyHandlerFqn = String.valueOf(FormSourceBuilder.this.m_formBuilder.getFullyQualifiedName()) + '$' + handlerSimpleName;
                if (FormSourceBuilder.MODIFY_HANDLER_NAME.equals(handlerSimpleName)) {
                    source.append("startInternalExclusive");
                } else {
                    source.append("startInternal");
                }
                source.append("(new ").append(validator.useName(modifyHandlerFqn)).append("());");
            }
        });
        this.m_formBuilder.addSortedMethod(SortedMemberKeyFactory.createMethodStartFormKey((IMethodSourceBuilder)startModifyBuilder), (IMethodSourceBuilder)startModifyBuilder);
    }

    protected void createMainBox() {
        String formFqn = this.m_formBuilder.getFullyQualifiedName();
        TypeSourceBuilder mainBoxBuilder = new TypeSourceBuilder("MainBox");
        mainBoxBuilder.addAnnotation(ScoutAnnotationSourceBuilderFactory.createOrder(1000.0));
        mainBoxBuilder.setFlags(1);
        mainBoxBuilder.setSuperTypeSignature(Signature.createTypeSignature((String)"org.eclipse.scout.rt.client.ui.form.fields.groupbox.AbstractGroupBox"));
        this.addClassId((IAnnotatableSourceBuilder)mainBoxBuilder, 1);
        this.m_formBuilder.addSortedType(SortedMemberKeyFactory.createTypeFormFieldKey((ITypeSourceBuilder)mainBoxBuilder, (double)1000.0), (ITypeSourceBuilder)mainBoxBuilder);
        String mainBoxFqn = String.valueOf(formFqn) + '$' + mainBoxBuilder.getElementName();
        IMethodSourceBuilder getMainBox = ScoutMethodSourceBuilderFactory.createFieldGetter(Signature.createTypeSignature((String)mainBoxFqn));
        this.m_formBuilder.addSortedMethod(SortedMemberKeyFactory.createMethodFormFieldGetterKey((IMethodSourceBuilder)getMainBox), getMainBox);
        int order = 100000;
        TypeSourceBuilder okButtonBuilder = new TypeSourceBuilder("OkButton");
        okButtonBuilder.addAnnotation(ScoutAnnotationSourceBuilderFactory.createOrder(order));
        okButtonBuilder.setFlags(1);
        okButtonBuilder.setSuperTypeSignature(Signature.createTypeSignature((String)"org.eclipse.scout.rt.client.ui.form.fields.button.AbstractOkButton"));
        this.addClassId((IAnnotatableSourceBuilder)okButtonBuilder, 2);
        mainBoxBuilder.addSortedType(SortedMemberKeyFactory.createTypeFormFieldKey((ITypeSourceBuilder)okButtonBuilder, (double)order), (ITypeSourceBuilder)okButtonBuilder);
        String okButtonSignature = Signature.createTypeSignature((String)(String.valueOf(mainBoxFqn) + '$' + okButtonBuilder.getElementName()));
        IMethodSourceBuilder okButtonGetterBuilder = ScoutMethodSourceBuilderFactory.createFieldGetter(okButtonSignature);
        this.m_formBuilder.addSortedMethod(SortedMemberKeyFactory.createMethodFormFieldGetterKey((IMethodSourceBuilder)okButtonGetterBuilder), okButtonGetterBuilder);
        TypeSourceBuilder cancelButtonBuilder = new TypeSourceBuilder("CancelButton");
        cancelButtonBuilder.addAnnotation(ScoutAnnotationSourceBuilderFactory.createOrder(order += 1000));
        cancelButtonBuilder.setFlags(1);
        cancelButtonBuilder.setSuperTypeSignature(Signature.createTypeSignature((String)"org.eclipse.scout.rt.client.ui.form.fields.button.AbstractCancelButton"));
        this.addClassId((IAnnotatableSourceBuilder)cancelButtonBuilder, 3);
        mainBoxBuilder.addSortedType(SortedMemberKeyFactory.createTypeFormFieldKey((ITypeSourceBuilder)cancelButtonBuilder, (double)order), (ITypeSourceBuilder)cancelButtonBuilder);
        String cancelButtonSignature = Signature.createTypeSignature((String)(String.valueOf(mainBoxFqn) + '$' + cancelButtonBuilder.getElementName()));
        IMethodSourceBuilder cancelButtonGetterBuilder = ScoutMethodSourceBuilderFactory.createFieldGetter(cancelButtonSignature);
        this.m_formBuilder.addSortedMethod(SortedMemberKeyFactory.createMethodFormFieldGetterKey((IMethodSourceBuilder)cancelButtonGetterBuilder), cancelButtonGetterBuilder);
    }

    protected void createHandler(String name) {
        TypeSourceBuilder handlerBuilder = new TypeSourceBuilder(name);
        handlerBuilder.setFlags(1);
        handlerBuilder.setSuperTypeSignature(Signature.createTypeSignature((String)"org.eclipse.scout.rt.client.ui.form.AbstractFormHandler"));
        this.m_formBuilder.addSortedType(SortedMemberKeyFactory.createTypeFormHandlerKey((ITypeSourceBuilder)handlerBuilder), (ITypeSourceBuilder)handlerBuilder);
        IMethodSourceBuilder execLoad = MethodSourceBuilderFactory.createOverride((ITypeSourceBuilder)handlerBuilder, (String)this.getPackageName(), (IJavaEnvironment)this.getJavaEnvironment(), (String)LOAD_METHOD_NAME);
        execLoad.setBody((ISourceBuilder)this.createExecLoadStoreBody(execLoad, (ITypeSourceBuilder)handlerBuilder));
        execLoad.removeAnnotation("org.eclipse.scout.rt.platform.Order");
        execLoad.removeAnnotation("org.eclipse.scout.rt.platform.annotations.ConfigOperation");
        handlerBuilder.addSortedMethod(SortedMemberKeyFactory.createMethodExecKey((IMethodSourceBuilder)execLoad), execLoad);
        IMethodSourceBuilder execStore = MethodSourceBuilderFactory.createOverride((ITypeSourceBuilder)handlerBuilder, (String)this.getPackageName(), (IJavaEnvironment)this.getJavaEnvironment(), (String)STORE_METHOD_NAME);
        execStore.setBody((ISourceBuilder)this.createExecLoadStoreBody(execStore, (ITypeSourceBuilder)handlerBuilder));
        execStore.removeAnnotation("org.eclipse.scout.rt.platform.Order");
        execStore.removeAnnotation("org.eclipse.scout.rt.platform.annotations.ConfigOperation");
        handlerBuilder.addSortedMethod(SortedMemberKeyFactory.createMethodExecKey((IMethodSourceBuilder)execStore), execStore);
    }

    protected HandlerMethodBodySourceBuilder createExecLoadStoreBody(IMethodSourceBuilder methodBuilder, ITypeSourceBuilder handlerBuilder) {
        HandlerMethodBodySourceBuilder handlerMehodBodySourceBuilder = new HandlerMethodBodySourceBuilder(methodBuilder, handlerBuilder);
        handlerMehodBodySourceBuilder.setFormDataStaticSignature(this.getFormDataSignature());
        handlerMehodBodySourceBuilder.setServiceIfcSignature(this.getServiceIfcSignature());
        if (MODIFY_HANDLER_NAME.equals(handlerBuilder.getElementName())) {
            handlerMehodBodySourceBuilder.setPermissionSignature(this.getUpdatePermissionSignature());
        } else {
            handlerMehodBodySourceBuilder.setPermissionSignature(this.getCreatePermissionSignature());
        }
        return handlerMehodBodySourceBuilder;
    }

    protected void addClassId(IAnnotatableSourceBuilder target, int index) {
        String[] classIdValues = this.getClassIdValues();
        if (classIdValues == null) {
            return;
        }
        target.addAnnotation(ScoutAnnotationSourceBuilderFactory.createClassId(classIdValues[index]));
    }

    public String getFormDataSignature() {
        return this.m_formDataSignature;
    }

    public void setFormDataSignature(String formDataSignature) {
        this.m_formDataSignature = formDataSignature;
    }

    public String getSuperTypeSignature() {
        return this.m_superTypeSignature;
    }

    public void setSuperTypeSignature(String superTypeSignature) {
        this.m_superTypeSignature = superTypeSignature;
    }

    public String getServiceIfcSignature() {
        return this.m_serviceIfcSignature;
    }

    public void setServiceIfcSignature(String serviceIfcSignature) {
        this.m_serviceIfcSignature = serviceIfcSignature;
    }

    public String getUpdatePermissionSignature() {
        return this.m_updatePermissionSignature;
    }

    public void setUpdatePermissionSignature(String updatePermissionSignature) {
        this.m_updatePermissionSignature = updatePermissionSignature;
    }

    public String getCreatePermissionSignature() {
        return this.m_createPermissionSignature;
    }

    public void setCreatePermissionSignature(String createPermissionSignature) {
        this.m_createPermissionSignature = createPermissionSignature;
    }

    public String[] getClassIdValues() {
        return this.m_classIdValues;
    }

    public void setClassIdValues(String[] classIdValues) {
        Validate.isTrue((((String[])Validate.notNull((Object)classIdValues)).length == 4 ? 1 : 0) != 0);
        this.m_classIdValues = Arrays.copyOf(classIdValues, classIdValues.length);
    }

    public static final class HandlerMethodBodySourceBuilder
    implements ISourceBuilder {
        public static final String SERVICE_VAR_NAME = "service";
        public static final String FORM_DATA_VAR_NAME = "formData";
        private String m_serviceIfcSignature;
        private String m_formDataStaticSignature;
        private String m_formDataDynamicSignature;
        private String m_permissionSignature;
        private ISourceBuilder m_methodArgSourceBuilder;
        private ISourceBuilder m_permissionArgSourceBuilder;
        private ISourceBuilder m_formDataInstanceCreationBuilder;
        private final IMethodSourceBuilder m_handlerMethodBuilder;
        private final ITypeSourceBuilder m_handlerBuilder;
        private boolean m_createFormDataInLoad;

        public HandlerMethodBodySourceBuilder(IMethodSourceBuilder handlerMethodBuilder, ITypeSourceBuilder handlerBuilder) {
            this.m_handlerBuilder = handlerBuilder;
            this.m_handlerMethodBuilder = handlerMethodBuilder;
            this.m_createFormDataInLoad = true;
        }

        public void createSource(StringBuilder source, String lineDelimiter, PropertyMap context, IImportValidator validator) {
            boolean isModify = FormSourceBuilder.MODIFY_HANDLER_NAME.equals(this.getHandlerBuilder().getElementName());
            boolean isLoad = FormSourceBuilder.LOAD_METHOD_NAME.equals(this.getHandlerMethodBuilder().getElementName());
            if (this.getServiceIfcSignature() != null) {
                boolean isDtoAvailable = this.getFormDataStaticSignature() != null;
                String serviceInterfaceName = validator.useSignature(this.getServiceIfcSignature());
                String formDataStaticTypeName = null;
                String formDataDynamicTypeName = null;
                if (isDtoAvailable) {
                    formDataStaticTypeName = validator.useSignature(this.getFormDataStaticSignature());
                    formDataDynamicTypeName = validator.useSignature(this.getFormDataDynamicSignature());
                }
                source.append(serviceInterfaceName).append(' ').append(SERVICE_VAR_NAME).append(" = ");
                source.append(validator.useSignature(Signature.createTypeSignature((String)"org.eclipse.scout.rt.platform.BEANS"))).append(".get(");
                source.append(serviceInterfaceName).append(SuffixConstants.SUFFIX_class).append(");").append(lineDelimiter);
                if (isDtoAvailable) {
                    source.append(formDataStaticTypeName).append(' ').append(FORM_DATA_VAR_NAME).append(" = ");
                    if (!isLoad || this.isCreateFormDataInLoad()) {
                        ISourceBuilder formDataInstanceCreationBuilder = this.getFormDataInstanceCreationBuilder();
                        if (formDataInstanceCreationBuilder == null) {
                            source.append("new ").append(formDataDynamicTypeName).append("();").append(lineDelimiter);
                        } else {
                            formDataInstanceCreationBuilder.createSource(source, lineDelimiter, context, validator);
                        }
                        source.append("exportFormData(").append(FORM_DATA_VAR_NAME).append(");").append(lineDelimiter);
                        if (isLoad) {
                            source.append(FORM_DATA_VAR_NAME).append(" = ");
                        }
                    }
                }
                source.append(SERVICE_VAR_NAME).append('.');
                if (isLoad) {
                    if (isModify) {
                        source.append(FormSourceBuilder.SERVICE_LOAD_METHOD_NAME);
                    } else {
                        source.append(FormSourceBuilder.SERVICE_PREPARECREATE_METHOD_NAME);
                    }
                } else if (isModify) {
                    source.append(FormSourceBuilder.SERVICE_STORE_METHOD_NAME);
                } else {
                    source.append(FormSourceBuilder.SERVICE_CREATE_METHOD_NAME);
                }
                source.append('(');
                if (this.getMethodArgSourceBuilder() != null) {
                    this.getMethodArgSourceBuilder().createSource(source, lineDelimiter, context, validator);
                } else if (isDtoAvailable) {
                    source.append(FORM_DATA_VAR_NAME);
                }
                source.append(");");
                if (isLoad && isDtoAvailable) {
                    source.append(lineDelimiter).append("importFormData(").append(FORM_DATA_VAR_NAME).append(");");
                }
            }
            if (isLoad && this.getPermissionSignature() != null) {
                source.append(lineDelimiter).append(lineDelimiter).append("setEnabledPermission(new ").append(validator.useSignature(this.getPermissionSignature())).append('(');
                if (this.getPermissionArgSourceBuilder() != null) {
                    this.getPermissionArgSourceBuilder().createSource(source, lineDelimiter, context, validator);
                }
                source.append("));");
            }
        }

        public String getServiceIfcSignature() {
            return this.m_serviceIfcSignature;
        }

        public void setServiceIfcSignature(String serviceIfcSignature) {
            this.m_serviceIfcSignature = serviceIfcSignature;
        }

        public String getFormDataStaticSignature() {
            return this.m_formDataStaticSignature;
        }

        public void setFormDataStaticSignature(String formDataStaticSignature) {
            this.m_formDataStaticSignature = formDataStaticSignature;
        }

        public String getFormDataDynamicSignature() {
            if (this.m_formDataDynamicSignature == null) {
                return this.m_formDataStaticSignature;
            }
            return this.m_formDataDynamicSignature;
        }

        public void setFormDataDynamicSignature(String formDataDynamicSignature) {
            this.m_formDataDynamicSignature = formDataDynamicSignature;
        }

        public String getPermissionSignature() {
            return this.m_permissionSignature;
        }

        public void setPermissionSignature(String permissionSignature) {
            this.m_permissionSignature = permissionSignature;
        }

        public ISourceBuilder getMethodArgSourceBuilder() {
            return this.m_methodArgSourceBuilder;
        }

        public void setMethodArgSourceBuilder(ISourceBuilder methodArgSourceBuilder) {
            this.m_methodArgSourceBuilder = methodArgSourceBuilder;
        }

        public ISourceBuilder getPermissionArgSourceBuilder() {
            return this.m_permissionArgSourceBuilder;
        }

        public void setPermissionArgSourceBuilder(ISourceBuilder permissionArgSourceBuilder) {
            this.m_permissionArgSourceBuilder = permissionArgSourceBuilder;
        }

        public IMethodSourceBuilder getHandlerMethodBuilder() {
            return this.m_handlerMethodBuilder;
        }

        public ITypeSourceBuilder getHandlerBuilder() {
            return this.m_handlerBuilder;
        }

        public ISourceBuilder getFormDataInstanceCreationBuilder() {
            return this.m_formDataInstanceCreationBuilder;
        }

        public void setFormDataInstanceCreationBuilder(ISourceBuilder formDataInstanceCreationBuilder) {
            this.m_formDataInstanceCreationBuilder = formDataInstanceCreationBuilder;
        }

        public boolean isCreateFormDataInLoad() {
            return this.m_createFormDataInLoad;
        }

        public void setCreateFormDataInLoad(boolean createFormDataInLoad) {
            this.m_createFormDataInLoad = createFormDataInLoad;
        }
    }
}

