/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.s.structured;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.scout.sdk.core.model.api.Flags;
import org.eclipse.scout.sdk.core.model.api.IField;
import org.eclipse.scout.sdk.core.model.api.IJavaElement;
import org.eclipse.scout.sdk.core.model.api.IMethod;
import org.eclipse.scout.sdk.core.model.api.IMethodParameter;
import org.eclipse.scout.sdk.core.model.api.IType;
import org.eclipse.scout.sdk.core.s.model.ScoutTypeComparators;
import org.eclipse.scout.sdk.core.s.structured.IStructuredType;
import org.eclipse.scout.sdk.core.signature.Signature;
import org.eclipse.scout.sdk.core.signature.SignatureUtils;
import org.eclipse.scout.sdk.core.util.CompositeObject;
import org.eclipse.scout.sdk.core.util.SdkLog;
import org.eclipse.scout.sdk.core.util.TypeFilters;

public class StructuredType
implements IStructuredType {
    private static final Pattern PROPERTY_BEAN_REGEX = Pattern.compile("^(get|set|is|add|remove|clear|delete)(.*)$");
    private static final Pattern START_HANDLER_REGEX = Pattern.compile("^start(.*)$");
    private static final Pattern METHOD_INNER_TYPE_GETTER_REGEX = Pattern.compile("^get(.*)$");
    private static final Predicate<IType> CLASS_FILTER = new Predicate<IType>(){

        @Override
        public boolean test(IType type) {
            if (StringUtils.isBlank((CharSequence)type.elementName())) {
                return false;
            }
            int flags = type.flags();
            return !Flags.isAbstract((int)flags) && !Flags.isInterface((int)flags) && !Flags.isDeprecated((int)flags);
        }
    };
    private final IType m_type;
    private final EnumSet<IStructuredType.Categories> m_enabledCategories;
    private final EnumSet<IStructuredType.Categories> m_visitedCategories;
    private final Map<IStructuredType.Categories, List<? extends IJavaElement>> m_elements;

    public StructuredType(IType type, EnumSet<IStructuredType.Categories> enabledCategories) {
        this.m_type = type;
        this.m_enabledCategories = enabledCategories;
        this.m_visitedCategories = EnumSet.noneOf(IStructuredType.Categories.class);
        this.m_elements = new HashMap<IStructuredType.Categories, List<? extends IJavaElement>>();
        List fields = type.fields().list();
        List enums = type.innerTypes().withFlags(16384).list();
        List methods = type.methods().list();
        List types = type.innerTypes().withFilter((Predicate)new Predicate<IType>(){

            @Override
            public boolean test(IType element) {
                return !Flags.isEnum((int)element.flags());
            }
        }).list();
        this.m_elements.put(IStructuredType.Categories.FIELD_UNKNOWN, fields);
        this.m_elements.put(IStructuredType.Categories.ENUM, enums);
        this.m_elements.put(IStructuredType.Categories.METHOD_UNCATEGORIZED, methods);
        this.m_elements.put(IStructuredType.Categories.TYPE_UNCATEGORIZED, types);
    }

    public IType getType() {
        return this.m_type;
    }

    protected List<? extends IJavaElement> getElementsInternal(IStructuredType.Categories category) {
        this.cache(category);
        return this.m_elements.get((Object)category);
    }

    @Override
    public List<IJavaElement> getElements(IStructuredType.Categories category) {
        return new ArrayList<IJavaElement>(this.getElementsInternal(category));
    }

    @Override
    public <T extends IJavaElement> List<T> getElements(IStructuredType.Categories category, Class<T> clazz) {
        List<? extends IJavaElement> elements = this.getElementsInternal(category);
        if (elements == null) {
            return Collections.emptyList();
        }
        ArrayList<IJavaElement> result = new ArrayList<IJavaElement>(elements.size());
        for (IJavaElement iJavaElement : elements) {
            result.add(iJavaElement);
        }
        return result;
    }

    @Override
    public IJavaElement getSiblingMethodConfigGetConfigured(String methodName) {
        return this.getSibling(methodName, IStructuredType.Categories.METHOD_CONFIG_PROPERTY);
    }

    @Override
    public IJavaElement getSiblingMethodConfigExec(String methodName) {
        return this.getSibling(methodName, IStructuredType.Categories.METHOD_CONFIG_EXEC);
    }

    @Override
    public IJavaElement getSiblingMethodFieldGetter(String methodName) {
        return this.getSibling(methodName, IStructuredType.Categories.METHOD_INNER_TYPE_GETTER);
    }

    @Override
    public IJavaElement getSiblingMethodStartHandler(String methodName) {
        return this.getSibling(methodName, IStructuredType.Categories.METHOD_START_HANDLER);
    }

    @Override
    public IJavaElement getSiblingTypeKeyStroke(String keyStrokeName) {
        return this.getSibling(keyStrokeName, IStructuredType.Categories.TYPE_KEYSTROKE);
    }

    @Override
    public IJavaElement getSiblingComposerAttribute(String attributeName) {
        return this.getSibling(attributeName, IStructuredType.Categories.TYPE_COMPOSER_ATTRIBUTE);
    }

    @Override
    public IJavaElement getSiblingComposerEntity(String entityName) {
        return this.getSibling(entityName, IStructuredType.Categories.TYPE_COMPOSER_ENTRY);
    }

    @Override
    public IJavaElement getSiblingTypeFormHandler(String formHandlerName) {
        return this.getSibling(formHandlerName, IStructuredType.Categories.TYPE_FORM_HANDLER, IStructuredType.Categories.TYPE_UNCATEGORIZED);
    }

    protected IJavaElement getSibling(String siblingName, IStructuredType.Categories ... categories) {
        IStructuredType.Categories[] categoriesArray = categories;
        int n = categories.length;
        int n2 = 0;
        while (n2 < n) {
            IStructuredType.Categories cat = categoriesArray[n2];
            List<? extends IJavaElement> references = this.getElementsInternal(cat);
            if (references != null && !references.isEmpty()) {
                for (IJavaElement iJavaElement : references) {
                    if (iJavaElement.elementName().compareTo(siblingName) <= 0) continue;
                    return iJavaElement;
                }
                return references.get(references.size() - 1);
            }
            IJavaElement iJavaElement = this.getSibling(cat);
            if (iJavaElement != null) {
                return iJavaElement;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public IJavaElement getSibling(IStructuredType.Categories category) {
        boolean search = false;
        IStructuredType.Categories[] methodCategories = IStructuredType.Categories.values();
        int i = 0;
        while (i < methodCategories.length) {
            this.cache(methodCategories[i]);
            if (search) {
                List<? extends IJavaElement> elements = this.getElementsInternal(methodCategories[i]);
                if (elements != null && !elements.isEmpty()) {
                    return elements.get(0);
                }
            } else if (methodCategories[i].equals((Object)category)) {
                search = true;
            }
            ++i;
        }
        return null;
    }

    protected final void cache(IStructuredType.Categories category) {
        if (this.m_enabledCategories.contains((Object)category) && !this.m_visitedCategories.contains((Object)category)) {
            ArrayList<IJavaElement> unknownMethods = new ArrayList<IJavaElement>((Collection)this.m_elements.get((Object)IStructuredType.Categories.METHOD_UNCATEGORIZED));
            ArrayList<IJavaElement> unknownTypes = new ArrayList<IJavaElement>((Collection)this.m_elements.get((Object)IStructuredType.Categories.TYPE_UNCATEGORIZED));
            switch (category) {
                case FIELD_LOGGER: 
                case FIELD_STATIC: 
                case FIELD_MEMBER: {
                    this.visitFields(new ArrayList<IJavaElement>((Collection)this.m_elements.get((Object)IStructuredType.Categories.FIELD_UNKNOWN)));
                    this.m_visitedCategories.add(IStructuredType.Categories.FIELD_LOGGER);
                    this.m_visitedCategories.add(IStructuredType.Categories.FIELD_STATIC);
                    this.m_visitedCategories.add(IStructuredType.Categories.FIELD_MEMBER);
                    break;
                }
                case METHOD_CONSTRUCTOR: {
                    this.visitMethodConstructors(unknownMethods);
                    this.m_visitedCategories.add(IStructuredType.Categories.METHOD_CONSTRUCTOR);
                    this.m_elements.put(IStructuredType.Categories.METHOD_UNCATEGORIZED, unknownMethods);
                    break;
                }
                case METHOD_CONFIG_PROPERTY: {
                    this.visitMethodConfigProperty(unknownMethods);
                    this.m_visitedCategories.add(IStructuredType.Categories.METHOD_CONFIG_PROPERTY);
                    this.m_elements.put(IStructuredType.Categories.METHOD_UNCATEGORIZED, unknownMethods);
                    break;
                }
                case METHOD_CONFIG_EXEC: {
                    this.visitMethodConfigExec(unknownMethods);
                    this.m_visitedCategories.add(IStructuredType.Categories.METHOD_CONFIG_EXEC);
                    this.m_elements.put(IStructuredType.Categories.METHOD_UNCATEGORIZED, unknownMethods);
                    break;
                }
                case METHOD_FORM_DATA_BEAN: {
                    this.m_visitedCategories.add(IStructuredType.Categories.METHOD_FORM_DATA_BEAN);
                    this.visitMethodFormDataBean(unknownMethods);
                    this.m_elements.put(IStructuredType.Categories.METHOD_UNCATEGORIZED, unknownMethods);
                    break;
                }
                case METHOD_OVERRIDDEN: {
                    this.visitMethodOverridden(unknownMethods);
                    this.m_visitedCategories.add(IStructuredType.Categories.METHOD_OVERRIDDEN);
                    this.m_elements.put(IStructuredType.Categories.METHOD_UNCATEGORIZED, unknownMethods);
                    break;
                }
                case METHOD_START_HANDLER: {
                    this.visitMethodStartHandler(unknownMethods);
                    this.m_visitedCategories.add(IStructuredType.Categories.METHOD_START_HANDLER);
                    this.m_elements.put(IStructuredType.Categories.METHOD_UNCATEGORIZED, unknownMethods);
                    break;
                }
                case METHOD_INNER_TYPE_GETTER: {
                    this.visitMethodInnerTypeGetter(unknownMethods);
                    this.m_visitedCategories.add(IStructuredType.Categories.METHOD_INNER_TYPE_GETTER);
                    this.m_elements.put(IStructuredType.Categories.METHOD_UNCATEGORIZED, unknownMethods);
                    break;
                }
                case METHOD_LOCAL_BEAN: {
                    this.visitMethodLocalBean(unknownMethods);
                    this.m_visitedCategories.add(IStructuredType.Categories.METHOD_LOCAL_BEAN);
                    this.m_elements.put(IStructuredType.Categories.METHOD_UNCATEGORIZED, unknownMethods);
                    break;
                }
                case TYPE_FORM_FIELD: {
                    this.visitTypeFormFields(unknownTypes);
                    this.m_visitedCategories.add(IStructuredType.Categories.TYPE_FORM_FIELD);
                    this.m_elements.put(IStructuredType.Categories.TYPE_UNCATEGORIZED, unknownTypes);
                    break;
                }
                case TYPE_COLUMN: {
                    this.visitTypeColumns(unknownTypes);
                    this.m_visitedCategories.add(IStructuredType.Categories.TYPE_COLUMN);
                    this.m_elements.put(IStructuredType.Categories.TYPE_UNCATEGORIZED, unknownTypes);
                    break;
                }
                case TYPE_CODE: {
                    this.visitTypeCodes(unknownTypes);
                    this.m_visitedCategories.add(IStructuredType.Categories.TYPE_CODE);
                    this.m_elements.put(IStructuredType.Categories.TYPE_UNCATEGORIZED, unknownTypes);
                    break;
                }
                case TYPE_FORM: {
                    this.visitTypeForms(unknownTypes);
                    this.m_visitedCategories.add(IStructuredType.Categories.TYPE_FORM);
                    this.m_elements.put(IStructuredType.Categories.TYPE_UNCATEGORIZED, unknownTypes);
                    break;
                }
                case TYPE_TABLE: {
                    this.visitTypeTables(unknownTypes);
                    this.m_visitedCategories.add(IStructuredType.Categories.TYPE_TABLE);
                    this.m_elements.put(IStructuredType.Categories.TYPE_UNCATEGORIZED, unknownTypes);
                    break;
                }
                case TYPE_TREE: {
                    this.visitTypeTrees(unknownTypes);
                    this.m_visitedCategories.add(IStructuredType.Categories.TYPE_TREE);
                    this.m_elements.put(IStructuredType.Categories.TYPE_UNCATEGORIZED, unknownTypes);
                    break;
                }
                case TYPE_CALENDAR: {
                    this.visitTypeCalendar(unknownTypes);
                    this.m_visitedCategories.add(IStructuredType.Categories.TYPE_CALENDAR);
                    this.m_elements.put(IStructuredType.Categories.TYPE_UNCATEGORIZED, unknownTypes);
                    break;
                }
                case TYPE_CALENDAR_ITEM_PROVIDER: {
                    this.visitTypeCalendarItemProvider(unknownTypes);
                    this.m_visitedCategories.add(IStructuredType.Categories.TYPE_CALENDAR_ITEM_PROVIDER);
                    this.m_elements.put(IStructuredType.Categories.TYPE_UNCATEGORIZED, unknownTypes);
                    break;
                }
                case TYPE_WIZARD: {
                    this.visitTypeWizards(unknownTypes);
                    this.m_visitedCategories.add(IStructuredType.Categories.TYPE_WIZARD);
                    this.m_elements.put(IStructuredType.Categories.TYPE_UNCATEGORIZED, unknownTypes);
                    break;
                }
                case TYPE_WIZARD_STEP: {
                    this.visitTypeWizardSteps(unknownTypes);
                    this.m_visitedCategories.add(IStructuredType.Categories.TYPE_WIZARD_STEP);
                    this.m_elements.put(IStructuredType.Categories.TYPE_UNCATEGORIZED, unknownTypes);
                    break;
                }
                case TYPE_MENU: {
                    this.visitTypeMenus(unknownTypes);
                    this.m_visitedCategories.add(IStructuredType.Categories.TYPE_MENU);
                    this.m_elements.put(IStructuredType.Categories.TYPE_UNCATEGORIZED, unknownTypes);
                    break;
                }
                case TYPE_VIEW_BUTTON: {
                    this.visitTypeViewbuttons(unknownTypes);
                    this.m_visitedCategories.add(IStructuredType.Categories.TYPE_VIEW_BUTTON);
                    this.m_elements.put(IStructuredType.Categories.TYPE_UNCATEGORIZED, unknownTypes);
                    break;
                }
                case TYPE_KEYSTROKE: {
                    this.visitTypeKeystrokes(unknownTypes);
                    this.m_visitedCategories.add(IStructuredType.Categories.TYPE_KEYSTROKE);
                    this.m_elements.put(IStructuredType.Categories.TYPE_UNCATEGORIZED, unknownTypes);
                    break;
                }
                case TYPE_COMPOSER_ATTRIBUTE: {
                    this.visitTypeComposerAttribute(unknownTypes);
                    this.m_visitedCategories.add(IStructuredType.Categories.TYPE_COMPOSER_ATTRIBUTE);
                    this.m_elements.put(IStructuredType.Categories.TYPE_UNCATEGORIZED, unknownTypes);
                    break;
                }
                case TYPE_COMPOSER_ENTRY: {
                    this.visitTypeDataModelEntry(unknownTypes);
                    this.m_visitedCategories.add(IStructuredType.Categories.TYPE_COMPOSER_ENTRY);
                    this.m_elements.put(IStructuredType.Categories.TYPE_UNCATEGORIZED, unknownTypes);
                    break;
                }
                case TYPE_FORM_HANDLER: {
                    this.visitTypeFormHandlers(unknownTypes);
                    this.m_visitedCategories.add(IStructuredType.Categories.TYPE_FORM_HANDLER);
                    this.m_elements.put(IStructuredType.Categories.TYPE_UNCATEGORIZED, unknownTypes);
                    break;
                }
            }
        }
    }

    protected void visitFields(List<IJavaElement> workingSet) {
        ArrayList<IField> loggers = new ArrayList<IField>(2);
        ArrayList<IField> statics = new ArrayList<IField>();
        ArrayList<IField> members = new ArrayList<IField>();
        Iterator<IJavaElement> it = workingSet.iterator();
        while (it.hasNext()) {
            IField f = (IField)it.next();
            if ((f.flags() & 8) != 0) {
                String fieldDataType = Signature.toString((String)f.dataType().signature());
                if (Signature.getSimpleName((String)"org.slf4j.Logger").equals(fieldDataType) || "org.slf4j.Logger".equals(fieldDataType)) {
                    loggers.add(f);
                    it.remove();
                    continue;
                }
                statics.add(f);
                it.remove();
                continue;
            }
            members.add(f);
            it.remove();
        }
        this.m_elements.put(IStructuredType.Categories.FIELD_LOGGER, loggers);
        this.m_elements.put(IStructuredType.Categories.FIELD_STATIC, statics);
        this.m_elements.put(IStructuredType.Categories.FIELD_MEMBER, members);
        this.m_elements.put(IStructuredType.Categories.FIELD_UNKNOWN, workingSet);
    }

    protected void visitMethodConstructors(Iterable<IJavaElement> workingSet) {
        TreeMap<CompositeObject, IMethod> constructors = new TreeMap<CompositeObject, IMethod>();
        Iterator<IJavaElement> it = workingSet.iterator();
        while (it.hasNext()) {
            IMethod method = (IMethod)it.next();
            if (!method.isConstructor()) continue;
            CompositeObject key = this.createConstructorKey(method.parameters().list());
            constructors.put(key, method);
            it.remove();
        }
        this.m_elements.put(IStructuredType.Categories.METHOD_CONSTRUCTOR, new ArrayList(constructors.values()));
    }

    protected void visitMethodConfigExec(Iterable<IJavaElement> workingSet) {
        TreeMap<CompositeObject, IMethod> execMethods = new TreeMap<CompositeObject, IMethod>();
        Iterator<IJavaElement> it = workingSet.iterator();
        block0: while (it.hasNext()) {
            IMethod method;
            IMethod visitedMethod = method = (IMethod)it.next();
            while (visitedMethod != null) {
                if (visitedMethod.annotations().withName("org.eclipse.scout.rt.platform.annotations.ConfigOperation").existsAny()) {
                    CompositeObject key = new CompositeObject(new Object[]{method.elementName(), method.parameters().list().size(), method});
                    execMethods.put(key, method);
                    it.remove();
                    continue block0;
                }
                visitedMethod = StructuredType.getOverwrittenMethod(visitedMethod);
            }
        }
        this.m_elements.put(IStructuredType.Categories.METHOD_CONFIG_EXEC, new ArrayList(execMethods.values()));
    }

    protected void visitMethodConfigProperty(Iterable<IJavaElement> workingSet) {
        TreeMap<CompositeObject, IMethod> methods = new TreeMap<CompositeObject, IMethod>();
        Iterator<IJavaElement> it = workingSet.iterator();
        block0: while (it.hasNext()) {
            IMethod method;
            IMethod visitedMethod = method = (IMethod)it.next();
            while (visitedMethod != null) {
                if (visitedMethod.annotations().withName("org.eclipse.scout.rt.platform.annotations.ConfigProperty").existsAny()) {
                    CompositeObject key = new CompositeObject(new Object[]{method.elementName(), method.parameters().list().size(), method});
                    methods.put(key, method);
                    it.remove();
                    continue block0;
                }
                visitedMethod = StructuredType.getOverwrittenMethod(visitedMethod);
            }
        }
        this.m_elements.put(IStructuredType.Categories.METHOD_CONFIG_PROPERTY, new ArrayList(methods.values()));
    }

    protected void visitMethodFormDataBean(Iterable<IJavaElement> workingSet) {
        TreeMap<CompositeObject, IMethod> methods = new TreeMap<CompositeObject, IMethod>();
        Iterator<IJavaElement> it = workingSet.iterator();
        while (it.hasNext()) {
            IMethod method = (IMethod)it.next();
            if (!method.annotations().withName("org.eclipse.scout.rt.client.dto.FormData").existsAny()) continue;
            CompositeObject methodKey = StructuredType.createPropertyMethodKey(method);
            if (methodKey != null) {
                methods.put(methodKey, method);
                it.remove();
                continue;
            }
            SdkLog.warning((String)"could not parse property method '{}'.", (Object[])new Object[]{method.elementName()});
        }
        this.m_elements.put(IStructuredType.Categories.METHOD_FORM_DATA_BEAN, new ArrayList(methods.values()));
    }

    protected void visitMethodOverridden(Iterable<IJavaElement> workingSet) {
        TreeMap<CompositeObject, IMethod> overriddenMethods = new TreeMap<CompositeObject, IMethod>();
        Iterator<IJavaElement> it = workingSet.iterator();
        while (it.hasNext()) {
            IMethod method = (IMethod)it.next();
            if (StructuredType.getOverwrittenMethod(method) == null) continue;
            CompositeObject key = new CompositeObject(new Object[]{method.elementName(), method.parameters().list().size(), method});
            overriddenMethods.put(key, method);
            it.remove();
        }
        this.m_elements.put(IStructuredType.Categories.METHOD_OVERRIDDEN, new ArrayList(overriddenMethods.values()));
    }

    protected void visitMethodStartHandler(Iterable<IJavaElement> workingSet) {
        TreeMap<CompositeObject, IMethod> startHandlerMethods = new TreeMap<CompositeObject, IMethod>();
        Iterator<IJavaElement> it = workingSet.iterator();
        while (it.hasNext()) {
            IMethod method = (IMethod)it.next();
            Matcher matcher = START_HANDLER_REGEX.matcher(method.elementName());
            if (!matcher.find()) continue;
            String fieldName = matcher.group(1);
            if (!this.getType().innerTypes().withRecursiveInnerTypes(true).withSimpleName(String.valueOf(fieldName) + "Handler").existsAny()) continue;
            CompositeObject key = new CompositeObject(new Object[]{method.elementName(), method.parameters().list().size(), method});
            startHandlerMethods.put(key, method);
            it.remove();
        }
        this.m_elements.put(IStructuredType.Categories.METHOD_START_HANDLER, new ArrayList(startHandlerMethods.values()));
    }

    protected void visitMethodInnerTypeGetter(Iterable<IJavaElement> workingSet) {
        TreeMap<CompositeObject, IMethod> fieldGetterMethods = new TreeMap<CompositeObject, IMethod>();
        Iterator<IJavaElement> it = workingSet.iterator();
        while (it.hasNext()) {
            IMethod method = (IMethod)it.next();
            Matcher matcher = METHOD_INNER_TYPE_GETTER_REGEX.matcher(method.elementName());
            if (!matcher.find()) continue;
            String fieldName = matcher.group(1);
            if (!this.getType().innerTypes().withRecursiveInnerTypes(true).withSimpleName(fieldName).existsAny()) continue;
            CompositeObject key = new CompositeObject(new Object[]{method.elementName(), method.parameters().list().size(), method});
            fieldGetterMethods.put(key, method);
            it.remove();
        }
        this.m_elements.put(IStructuredType.Categories.METHOD_INNER_TYPE_GETTER, new ArrayList(fieldGetterMethods.values()));
    }

    protected void visitMethodLocalBean(Iterable<IJavaElement> workingSet) {
        TreeMap<CompositeObject, IMethod> localPropertyMethods = new TreeMap<CompositeObject, IMethod>();
        Iterator<IJavaElement> it = workingSet.iterator();
        while (it.hasNext()) {
            IMethod method = (IMethod)it.next();
            CompositeObject key = StructuredType.createPropertyMethodKey(method);
            if (key == null) continue;
            localPropertyMethods.put(key, method);
            it.remove();
        }
        this.m_elements.put(IStructuredType.Categories.METHOD_LOCAL_BEAN, new ArrayList(localPropertyMethods.values()));
    }

    protected void visitMethodUncategorized(Iterable<IMethod> workingSet) {
        TreeMap<CompositeObject, IMethod> methods = new TreeMap<CompositeObject, IMethod>();
        Iterator<IMethod> it = workingSet.iterator();
        while (it.hasNext()) {
            IMethod method = it.next();
            CompositeObject key = new CompositeObject(new Object[]{method.elementName(), method.parameters().list().size(), method});
            methods.put(key, method);
            it.remove();
        }
        this.m_elements.put(IStructuredType.Categories.METHOD_UNCATEGORIZED, new ArrayList(methods.values()));
    }

    protected void visitTypeFormFields(Iterable<IJavaElement> workingSet) {
        TreeSet<IType> formFields = new TreeSet<IType>(ScoutTypeComparators.getOrderAnnotationComparator(false));
        Predicate<IType> filter = CLASS_FILTER.and(TypeFilters.instanceOf((String)"org.eclipse.scout.rt.client.ui.form.fields.IFormField"));
        Iterator<IJavaElement> it = workingSet.iterator();
        while (it.hasNext()) {
            IType candidate = (IType)it.next();
            if (!filter.test(candidate)) continue;
            formFields.add(candidate);
            it.remove();
        }
        this.m_elements.put(IStructuredType.Categories.TYPE_FORM_FIELD, new ArrayList<IType>(formFields));
    }

    protected void visitTypeColumns(Iterable<IJavaElement> workingSet) {
        TreeSet<IType> types = new TreeSet<IType>(ScoutTypeComparators.getOrderAnnotationComparator(false));
        Predicate<IType> filter = CLASS_FILTER.and(TypeFilters.instanceOf((String)"org.eclipse.scout.rt.client.ui.basic.table.columns.IColumn"));
        Iterator<IJavaElement> it = workingSet.iterator();
        while (it.hasNext()) {
            IType candidate = (IType)it.next();
            if (!filter.test(candidate)) continue;
            types.add(candidate);
            it.remove();
        }
        this.m_elements.put(IStructuredType.Categories.TYPE_COLUMN, new ArrayList<IType>(types));
    }

    protected void visitTypeCodes(Iterable<IJavaElement> workingSet) {
        TreeSet<IType> types = new TreeSet<IType>(ScoutTypeComparators.getOrderAnnotationComparator(false));
        Predicate<IType> filter = CLASS_FILTER.and(TypeFilters.instanceOf((String)"org.eclipse.scout.rt.shared.services.common.code.ICode"));
        Iterator<IJavaElement> it = workingSet.iterator();
        while (it.hasNext()) {
            IType candidate = (IType)it.next();
            if (!filter.test(candidate)) continue;
            types.add(candidate);
            it.remove();
        }
        this.m_elements.put(IStructuredType.Categories.TYPE_CODE, new ArrayList<IType>(types));
    }

    protected void visitTypeForms(Iterable<IJavaElement> workingSet) {
        TreeSet<IType> types = new TreeSet<IType>(ScoutTypeComparators.getOrderAnnotationComparator(false));
        Predicate<IType> filter = CLASS_FILTER.and(TypeFilters.instanceOf((String)"org.eclipse.scout.rt.client.ui.form.IForm"));
        Iterator<IJavaElement> it = workingSet.iterator();
        while (it.hasNext()) {
            IType candidate = (IType)it.next();
            if (!filter.test(candidate)) continue;
            types.add(candidate);
            it.remove();
        }
        this.m_elements.put(IStructuredType.Categories.TYPE_FORM, new ArrayList<IType>(types));
    }

    protected void visitTypeTables(Iterable<IJavaElement> workingSet) {
        TreeSet<IType> types = new TreeSet<IType>(ScoutTypeComparators.getOrderAnnotationComparator(false));
        Predicate<IType> filter = CLASS_FILTER.and(TypeFilters.instanceOf((String)"org.eclipse.scout.rt.client.ui.basic.table.ITable"));
        Iterator<IJavaElement> it = workingSet.iterator();
        while (it.hasNext()) {
            IType candidate = (IType)it.next();
            if (!filter.test(candidate)) continue;
            types.add(candidate);
            it.remove();
        }
        this.m_elements.put(IStructuredType.Categories.TYPE_TABLE, new ArrayList<IType>(types));
    }

    protected void visitTypeTrees(Iterable<IJavaElement> workingSet) {
        TreeSet<IType> types = new TreeSet<IType>(ScoutTypeComparators.getOrderAnnotationComparator(false));
        Predicate<IType> filter = CLASS_FILTER.and(TypeFilters.instanceOf((String)"org.eclipse.scout.rt.client.ui.basic.tree.ITree"));
        Iterator<IJavaElement> it = workingSet.iterator();
        while (it.hasNext()) {
            IType candidate = (IType)it.next();
            if (!filter.test(candidate)) continue;
            types.add(candidate);
            it.remove();
        }
        this.m_elements.put(IStructuredType.Categories.TYPE_TREE, new ArrayList<IType>(types));
    }

    protected void visitTypeCalendar(Iterable<IJavaElement> workingSet) {
        TreeSet<IType> types = new TreeSet<IType>(ScoutTypeComparators.getOrderAnnotationComparator(false));
        Predicate<IType> filter = CLASS_FILTER.and(TypeFilters.instanceOf((String)"org.eclipse.scout.rt.client.ui.basic.calendar.ICalendar"));
        Iterator<IJavaElement> it = workingSet.iterator();
        while (it.hasNext()) {
            IType candidate = (IType)it.next();
            if (!filter.test(candidate)) continue;
            types.add(candidate);
            it.remove();
        }
        this.m_elements.put(IStructuredType.Categories.TYPE_CALENDAR, new ArrayList<IType>(types));
    }

    protected void visitTypeCalendarItemProvider(Iterable<IJavaElement> workingSet) {
        TreeSet<IType> types = new TreeSet<IType>(ScoutTypeComparators.getOrderAnnotationComparator(false));
        Predicate<IType> filter = CLASS_FILTER.and(TypeFilters.instanceOf((String)"org.eclipse.scout.rt.client.ui.basic.calendar.provider.ICalendarItemProvider"));
        Iterator<IJavaElement> it = workingSet.iterator();
        while (it.hasNext()) {
            IType candidate = (IType)it.next();
            if (!filter.test(candidate)) continue;
            types.add(candidate);
            it.remove();
        }
        this.m_elements.put(IStructuredType.Categories.TYPE_CALENDAR_ITEM_PROVIDER, new ArrayList<IType>(types));
    }

    protected void visitTypeWizards(Iterable<IJavaElement> workingSet) {
        TreeSet<IType> types = new TreeSet<IType>(ScoutTypeComparators.getOrderAnnotationComparator(false));
        Predicate<IType> filter = CLASS_FILTER.and(TypeFilters.instanceOf((String)"org.eclipse.scout.rt.client.ui.wizard.IWizard"));
        Iterator<IJavaElement> it = workingSet.iterator();
        while (it.hasNext()) {
            IType candidate = (IType)it.next();
            if (!filter.test(candidate)) continue;
            types.add(candidate);
            it.remove();
        }
        this.m_elements.put(IStructuredType.Categories.TYPE_WIZARD, new ArrayList<IType>(types));
    }

    protected void visitTypeWizardSteps(Iterable<IJavaElement> workingSet) {
        TreeSet<IType> types = new TreeSet<IType>(ScoutTypeComparators.getOrderAnnotationComparator(false));
        Predicate<IType> filter = CLASS_FILTER.and(TypeFilters.instanceOf((String)"org.eclipse.scout.rt.client.ui.wizard.IWizardStep"));
        Iterator<IJavaElement> it = workingSet.iterator();
        while (it.hasNext()) {
            IType candidate = (IType)it.next();
            if (!filter.test(candidate)) continue;
            types.add(candidate);
            it.remove();
        }
        this.m_elements.put(IStructuredType.Categories.TYPE_WIZARD_STEP, new ArrayList<IType>(types));
    }

    protected void visitTypeMenus(Iterable<IJavaElement> workingSet) {
        TreeSet<IType> types = new TreeSet<IType>(ScoutTypeComparators.getOrderAnnotationComparator(false));
        Predicate<IType> filter = CLASS_FILTER.and(TypeFilters.instanceOf((String)"org.eclipse.scout.rt.client.ui.action.menu.IMenu"));
        Iterator<IJavaElement> it = workingSet.iterator();
        while (it.hasNext()) {
            IType candidate = (IType)it.next();
            if (!filter.test(candidate)) continue;
            types.add(candidate);
            it.remove();
        }
        this.m_elements.put(IStructuredType.Categories.TYPE_MENU, new ArrayList<IType>(types));
    }

    protected void visitTypeViewbuttons(Iterable<IJavaElement> workingSet) {
        TreeSet<IType> types = new TreeSet<IType>(ScoutTypeComparators.getOrderAnnotationComparator(false));
        Predicate<IType> filter = CLASS_FILTER.and(TypeFilters.instanceOf((String)"org.eclipse.scout.rt.client.ui.action.view.IViewButton"));
        Iterator<IJavaElement> it = workingSet.iterator();
        while (it.hasNext()) {
            IType candidate = (IType)it.next();
            if (!filter.test(candidate)) continue;
            types.add(candidate);
            it.remove();
        }
        this.m_elements.put(IStructuredType.Categories.TYPE_VIEW_BUTTON, new ArrayList<IType>(types));
    }

    protected void visitTypeKeystrokes(Iterable<IJavaElement> workingSet) {
        TreeSet<IType> types = new TreeSet<IType>(ScoutTypeComparators.getTypeNameComparator());
        Predicate<IType> filter = CLASS_FILTER.and(TypeFilters.instanceOf((String)"org.eclipse.scout.rt.client.ui.action.keystroke.IKeyStroke"));
        Iterator<IJavaElement> it = workingSet.iterator();
        while (it.hasNext()) {
            IType candidate = (IType)it.next();
            if (!filter.test(candidate)) continue;
            types.add(candidate);
            it.remove();
        }
        this.m_elements.put(IStructuredType.Categories.TYPE_KEYSTROKE, new ArrayList<IType>(types));
    }

    protected void visitTypeComposerAttribute(Iterable<IJavaElement> workingSet) {
        TreeSet<IType> types = new TreeSet<IType>(ScoutTypeComparators.getTypeNameComparator());
        Predicate<IType> filter = CLASS_FILTER.and(TypeFilters.instanceOf((String)"org.eclipse.scout.rt.shared.data.model.IDataModelAttribute"));
        Iterator<IJavaElement> it = workingSet.iterator();
        while (it.hasNext()) {
            IType candidate = (IType)it.next();
            if (!filter.test(candidate)) continue;
            types.add(candidate);
            it.remove();
        }
        this.m_elements.put(IStructuredType.Categories.TYPE_COMPOSER_ATTRIBUTE, new ArrayList<IType>(types));
    }

    protected void visitTypeDataModelEntry(Iterable<IJavaElement> workingSet) {
        TreeSet<IType> types = new TreeSet<IType>(ScoutTypeComparators.getTypeNameComparator());
        Predicate<IType> filter = CLASS_FILTER.and(TypeFilters.instanceOf((String)"org.eclipse.scout.rt.shared.data.model.IDataModelEntity"));
        Iterator<IJavaElement> it = workingSet.iterator();
        while (it.hasNext()) {
            IType candidate = (IType)it.next();
            if (!filter.test(candidate)) continue;
            types.add(candidate);
            it.remove();
        }
        this.m_elements.put(IStructuredType.Categories.TYPE_COMPOSER_ENTRY, new ArrayList<IType>(types));
    }

    protected void visitTypeFormHandlers(Iterable<IJavaElement> workingSet) {
        TreeSet<IType> types = new TreeSet<IType>(ScoutTypeComparators.getTypeNameComparator());
        Predicate<IType> filter = CLASS_FILTER.and(TypeFilters.instanceOf((String)"org.eclipse.scout.rt.client.ui.form.IFormHandler"));
        Iterator<IJavaElement> it = workingSet.iterator();
        while (it.hasNext()) {
            IType candidate = (IType)it.next();
            if (!filter.test(candidate)) continue;
            types.add(candidate);
            it.remove();
        }
        this.m_elements.put(IStructuredType.Categories.TYPE_FORM_HANDLER, new ArrayList<IType>(types));
    }

    private static CompositeObject createPropertyMethodKey(IMethod method) {
        Matcher matcher;
        if (method != null && (matcher = PROPERTY_BEAN_REGEX.matcher(method.elementName())).find()) {
            int getSetOrder = 20;
            if ("get".equalsIgnoreCase(matcher.group(1))) {
                getSetOrder = 1;
            } else if ("is".equalsIgnoreCase(matcher.group(1))) {
                getSetOrder = 2;
            } else if ("set".equalsIgnoreCase(matcher.group(1))) {
                getSetOrder = 3;
            } else if ("add".equalsIgnoreCase(matcher.group(1))) {
                getSetOrder = 4;
            } else if ("remove".equalsIgnoreCase(matcher.group(1))) {
                getSetOrder = 5;
            } else if ("clear".equalsIgnoreCase(matcher.group(1))) {
                getSetOrder = 6;
            } else if ("delete".equalsIgnoreCase(matcher.group(1))) {
                getSetOrder = 7;
            }
            String propName = matcher.group(2);
            CompositeObject key = new CompositeObject(new Object[]{propName, getSetOrder, method.elementName(), method.parameters().list().size(), method});
            return key;
        }
        return null;
    }

    private static IMethod getOverwrittenMethod(final IMethod method) {
        final String refSig = SignatureUtils.createMethodIdentifier((IMethod)method);
        return method.declaringType().methods().withSuperClasses(true).withFilter((Predicate)new Predicate<IMethod>(){

            @Override
            public boolean test(IMethod element) {
                if (method.equals(element)) {
                    return false;
                }
                return refSig.equals(SignatureUtils.createMethodIdentifier((IMethod)element));
            }
        }).first();
    }

    protected CompositeObject createConstructorKey(Collection<IMethodParameter> list) {
        if (list == null) {
            return new CompositeObject(new Object[]{0, ""});
        }
        StringBuilder b = new StringBuilder();
        for (IMethodParameter p : list) {
            b.append(p.dataType().name());
        }
        return new CompositeObject(new Object[]{list.size(), b.toString()});
    }

    public void print(PrintStream printer) {
        printer.println("------ Structured type of '" + this.getType().name() + "' ------------");
        IStructuredType.Categories[] categoriesArray = IStructuredType.Categories.values();
        int n = categoriesArray.length;
        int n2 = 0;
        while (n2 < n) {
            IStructuredType.Categories c = categoriesArray[n2];
            this.printCategory(printer, c);
            ++n2;
        }
        printer.println("---------------------------------------------------------------------------");
    }

    private void printCategory(PrintStream printer, IStructuredType.Categories category) {
        printer.println("category '" + category.name() + "'");
        for (IJavaElement e : this.getElements(category)) {
            printer.println("  - " + e.elementName());
        }
    }
}

