/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.impl;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;
import org.slf4j.impl.SimpleLogger;

public class SimpleLoggerFactory
implements ILoggerFactory {
    private final ConcurrentMap<String, Logger> m_loggerMap = new ConcurrentHashMap<String, Logger>();

    public Logger getLogger(String name) {
        Logger simpleLogger = (Logger)this.m_loggerMap.get(name);
        if (simpleLogger != null) {
            return simpleLogger;
        }
        SimpleLogger newInstance = new SimpleLogger(name);
        Logger oldInstance = this.m_loggerMap.putIfAbsent(name, (Logger)newInstance);
        if (oldInstance == null) {
            return newInstance;
        }
        return oldInstance;
    }

    void reset() {
        this.m_loggerMap.clear();
    }
}

