/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.importcollector;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.scout.sdk.core.importcollector.IImportCollector;
import org.eclipse.scout.sdk.core.model.api.ICompilationUnit;
import org.eclipse.scout.sdk.core.model.api.IImport;
import org.eclipse.scout.sdk.core.model.api.IJavaEnvironment;
import org.eclipse.scout.sdk.core.signature.Signature;
import org.eclipse.scout.sdk.core.signature.SignatureDescriptor;

public class ImportCollector
implements IImportCollector {
    private final IJavaEnvironment m_env;
    private final Map<String, ImportElement> m_imports = new HashMap<String, ImportElement>();
    private final Map<String, ImportElement> m_staticImports = new HashMap<String, ImportElement>();

    public ImportCollector() {
        this((IJavaEnvironment)null);
    }

    public ImportCollector(ICompilationUnit icu) {
        this(icu.javaEnvironment());
        for (IImport imp : icu.imports()) {
            if (imp.isStatic()) {
                this.addStaticImport(imp.elementName(), true);
                continue;
            }
            this.addImport(imp.elementName(), true);
        }
    }

    public ImportCollector(IJavaEnvironment env) {
        this.m_env = env;
    }

    @Override
    public IJavaEnvironment getJavaEnvironment() {
        return this.m_env;
    }

    @Override
    public String getQualifier() {
        return null;
    }

    @Override
    public void reserveElement(SignatureDescriptor cand) {
        this.registerElementInternal(cand, false);
    }

    @Override
    public String registerElement(SignatureDescriptor cand) {
        return this.registerElementInternal(cand, true);
    }

    protected String registerElementInternal(SignatureDescriptor cand, boolean markAsUsed) {
        ImportElement elem = this.m_imports.get(cand.getSimpleName());
        if (elem == null) {
            this.m_imports.put(cand.getSimpleName(), new ImportElement(false, cand.getQualifier(), cand.getSimpleName(), markAsUsed, false));
        } else {
            elem.m_used = markAsUsed || elem.m_used;
        }
        return cand.getSimpleName();
    }

    @Override
    public String checkExistingImports(SignatureDescriptor cand) {
        if (cand.isBaseType() || cand.isUnresolved() || StringUtils.isBlank((CharSequence)cand.getQualifier())) {
            return cand.getSimpleName();
        }
        ImportElement existingElem = this.m_imports.get(cand.getSimpleName());
        if (existingElem != null && Objects.equals(existingElem.m_packageName, cand.getQualifier())) {
            if (existingElem.m_used) {
                return cand.getSimpleName();
            }
            return null;
        }
        if (existingElem != null) {
            return cand.getQualifiedName();
        }
        return null;
    }

    @Override
    public String checkCurrentScope(SignatureDescriptor cand) {
        return null;
    }

    @Override
    public void addImport(String fqn) {
        this.addImport(fqn, false);
    }

    public void addImport(String fqn, boolean fromExisting) {
        String packageName = Signature.getQualifier(fqn);
        String simpleName = Signature.getSimpleName(fqn);
        this.m_imports.put(simpleName, new ImportElement(false, packageName, simpleName, true, fromExisting));
    }

    @Override
    public void addStaticImport(String fqn) {
        this.addStaticImport(fqn, false);
    }

    protected void addStaticImport(String fqn, boolean fromExisting) {
        String packageName = Signature.getQualifier(fqn);
        String simpleName = Signature.getSimpleName(fqn);
        this.m_staticImports.put(simpleName, new ImportElement(true, packageName, simpleName, true, fromExisting));
    }

    @Override
    public Collection<String> getImports() {
        return ImportCollector.getImports(this.m_imports.values());
    }

    @Override
    public Collection<String> getStaticImports() {
        return ImportCollector.getImports(this.m_staticImports.values());
    }

    protected static Collection<String> getImports(Collection<ImportElement> imports) {
        ArrayList<String> result = new ArrayList<String>(imports.size());
        for (ImportElement e : imports) {
            result.add(e.getImport());
        }
        return result;
    }

    @Override
    public List<String> createImportDeclarations() {
        return this.createImportDeclarations(true);
    }

    @Override
    public List<String> createImportDeclarations(boolean includeExisting) {
        return this.organizeImports(this.m_staticImports.values(), this.m_imports.values(), includeExisting);
    }

    protected void addFiltered(Collection<ImportElement> elements, boolean includeExisting, Collection<ImportElement> collector) {
        for (ImportElement e : elements) {
            if (!includeExisting && e.m_fromExisting || !e.m_static && (!e.m_used || "java.lang".equals(e.m_packageName))) continue;
            collector.add(e);
        }
    }

    protected List<String> organizeImports(Collection<ImportElement> unsortedList1, Collection<ImportElement> unsortedList2, boolean includeExisting) {
        TreeSet<ImportElement> workList = new TreeSet<ImportElement>(new ImportComparator());
        this.addFiltered(unsortedList1, includeExisting, workList);
        this.addFiltered(unsortedList2, includeExisting, workList);
        String lastGroup = null;
        ArrayList<String> result = new ArrayList<String>(workList.size() + 7);
        for (ImportElement e : workList) {
            if (lastGroup != null && !lastGroup.equals(e.m_group)) {
                result.add("");
            }
            result.add(e.createImportDeclaration());
            lastGroup = e.m_group;
        }
        return result;
    }

    private static final class ImportComparator
    implements Comparator<ImportElement>,
    Serializable {
        private static final long serialVersionUID = 1L;

        private ImportComparator() {
        }

        @Override
        public int compare(ImportElement e1, ImportElement e2) {
            int result = e1.m_group.compareTo(e2.m_group);
            if (result != 0) {
                return result;
            }
            result = e1.m_packageName.compareTo(e2.m_packageName);
            if (result != 0) {
                return result;
            }
            return e1.m_simpleName.compareTo(e2.m_simpleName);
        }
    }

    private static final class ImportElement {
        private final boolean m_static;
        private final String m_packageName;
        private final String m_simpleName;
        private final boolean m_fromExisting;
        private String m_group;
        private boolean m_used;

        private ImportElement(boolean isStatic, String packageName, String simpleName, boolean used, boolean fromExisting) {
            this.m_static = isStatic;
            this.m_packageName = packageName;
            this.m_simpleName = simpleName;
            this.m_used = used;
            this.m_fromExisting = fromExisting;
            this.calculateGroup();
        }

        private void calculateGroup() {
            String pfx;
            String string = pfx = this.m_static ? "a." : "b.";
            this.m_group = this.m_packageName.startsWith("java.") ? String.valueOf(pfx) + "a" : (this.m_packageName.startsWith("javax.") ? String.valueOf(pfx) + "b" : (this.m_packageName.startsWith("org.") ? String.valueOf(pfx) + "c" : String.valueOf(pfx) + "d"));
        }

        public String getImport() {
            return this.m_packageName + '.' + this.m_simpleName;
        }

        public String createImportDeclaration() {
            return "import " + (this.m_static ? "static " : "") + this.getImport() + ';';
        }
    }
}

