/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.model.api.internal;

import org.eclipse.scout.sdk.core.model.api.IFileLocator;
import org.eclipse.scout.sdk.core.model.api.IJavaEnvironment;
import org.eclipse.scout.sdk.core.model.api.IType;
import org.eclipse.scout.sdk.core.model.api.IUnresolvedType;
import org.eclipse.scout.sdk.core.model.api.MissingTypeException;
import org.eclipse.scout.sdk.core.model.api.internal.UnresolvedTypeImplementor;
import org.eclipse.scout.sdk.core.model.spi.JavaEnvironmentSpi;
import org.eclipse.scout.sdk.core.model.spi.TypeSpi;

public class JavaEnvironmentImplementor
implements IJavaEnvironment {
    private JavaEnvironmentSpi m_spi;

    public JavaEnvironmentImplementor(JavaEnvironmentSpi spi) {
        this.m_spi = spi;
    }

    @Override
    public IType findType(String fqn) {
        return JavaEnvironmentImplementor.wrapType(this.m_spi.findType(fqn));
    }

    static IType wrapType(TypeSpi spi) {
        return spi != null ? spi.wrap() : null;
    }

    @Override
    public IUnresolvedType findUnresolvedType(String fqn) {
        try {
            IType t = this.findType(fqn);
            if (t != null) {
                return new UnresolvedTypeImplementor(t);
            }
        }
        catch (MissingTypeException missingTypeException) {
            // empty catch block
        }
        return new UnresolvedTypeImplementor(this, fqn);
    }

    @Override
    public IFileLocator getFileLocator() {
        return this.m_spi.getFileLocator();
    }

    @Override
    public void reload() {
        this.m_spi.reload();
    }

    @Override
    public boolean registerCompilationUnitOverride(String packageName, String fileName, StringBuilder buf) {
        char[] src = new char[buf.length()];
        buf.getChars(0, buf.length(), src, 0);
        return this.m_spi.registerCompilationUnitOverride(packageName, fileName, src);
    }

    @Override
    public String compileErrors(String fqn) {
        return this.m_spi.getCompileErrors(fqn);
    }

    @Override
    public JavaEnvironmentSpi unwrap() {
        return this.m_spi;
    }

    public void internalSetSpi(JavaEnvironmentSpi newSpi) {
        this.m_spi = newSpi;
    }
}

