/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.model.api.internal;

import java.util.AbstractList;
import java.util.Iterator;
import java.util.List;
import java.util.RandomAccess;
import org.apache.commons.lang3.Validate;
import org.eclipse.scout.sdk.core.model.spi.JavaElementSpi;

public class WrappedList<T>
extends AbstractList<T>
implements RandomAccess {
    private final List<? extends JavaElementSpi> m_spiList;

    public WrappedList(List<? extends JavaElementSpi> spiList) {
        Validate.isInstanceOf(RandomAccess.class, spiList);
        this.m_spiList = spiList;
    }

    @Override
    public Iterator<T> iterator() {
        final Iterator<? extends JavaElementSpi> it = this.m_spiList.iterator();
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return it.hasNext();
            }

            @Override
            public T next() {
                JavaElementSpi s = (JavaElementSpi)it.next();
                return s != null ? s.wrap() : null;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public int size() {
        return this.m_spiList.size();
    }

    @Override
    public T get(int index) {
        JavaElementSpi s = this.m_spiList.get(index);
        if (s == null) {
            return null;
        }
        return (T)s.wrap();
    }

    @Override
    public int hashCode() {
        return this.m_spiList.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        WrappedList other = (WrappedList)obj;
        return this.m_spiList.equals(other.m_spiList);
    }
}

