/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.model.spi.internal;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.batch.ClasspathJar;
import org.eclipse.jdt.internal.compiler.batch.FileSystem;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.eclipse.jdt.internal.compiler.env.NameEnvironmentAnswer;
import org.eclipse.jdt.internal.compiler.util.SuffixConstants;
import org.eclipse.scout.sdk.core.model.spi.internal.AstCompiler;
import org.eclipse.scout.sdk.core.util.SdkException;

public class WorkspaceFileSystem
implements INameEnvironment {
    private static final char SEPARATOR = '/';
    private final Set<FileSystem.Classpath> m_classpaths;
    private final Map<String, ICompilationUnit> m_overrideCompilationUnits = new HashMap<String, ICompilationUnit>();
    private final Set<String> m_additionalPackages = new HashSet<String>();

    public WorkspaceFileSystem(Set<FileSystem.Classpath> paths) {
        this.m_classpaths = paths;
        try {
            for (FileSystem.Classpath cp : this.m_classpaths) {
                cp.initialize();
            }
        }
        catch (IOException e) {
            throw new SdkException(e);
        }
    }

    public boolean addOverrideCompilationUnit(ICompilationUnit cu) {
        char[][] packageName0 = cu.getPackageName();
        StringBuilder keyBuilder = new StringBuilder();
        if (packageName0 != null && packageName0.length > 0) {
            char[][] cArray = packageName0;
            int n = packageName0.length;
            int n2 = 0;
            while (n2 < n) {
                char[] segment = cArray[n2];
                keyBuilder.append(segment);
                keyBuilder.append('/');
                ++n2;
            }
        }
        keyBuilder.append(cu.getMainTypeName());
        boolean updatedExistingEntry = false;
        ICompilationUnit existingIcu = this.m_overrideCompilationUnits.put(keyBuilder.toString(), cu);
        if (existingIcu != null) {
            boolean bl = updatedExistingEntry = !Arrays.equals(existingIcu.getContents(), cu.getContents());
        }
        if (packageName0 != null && packageName0.length > 0) {
            int i = 1;
            while (i < packageName0.length) {
                this.m_additionalPackages.add(new String(CharOperation.concatWith((char[][])CharOperation.subarray((char[][])packageName0, (int)0, (int)i), (char)'/')));
                ++i;
            }
        }
        return updatedExistingEntry;
    }

    public Collection<ICompilationUnit> getOverrideCompilationUnits() {
        return Collections.unmodifiableCollection(this.m_overrideCompilationUnits.values());
    }

    public void cleanup() {
        for (FileSystem.Classpath cp : this.m_classpaths) {
            cp.reset();
        }
        this.m_additionalPackages.clear();
        this.m_overrideCompilationUnits.clear();
    }

    public boolean isPackage(char[][] compoundName, char[] packageName) {
        String packageFqnSlash = new String(CharOperation.concatWith((char[][])compoundName, (char[])packageName, (char)'/'));
        if (this.m_additionalPackages.contains(packageFqnSlash)) {
            return true;
        }
        if (File.separatorChar == '/') {
            for (FileSystem.Classpath cp : this.m_classpaths) {
                if (!cp.isPackage(packageFqnSlash)) continue;
                return true;
            }
        } else {
            String packageFqnPlatform = packageFqnSlash.replace('/', File.separatorChar);
            for (FileSystem.Classpath cp : this.m_classpaths) {
                String pathToUse = null;
                pathToUse = cp instanceof ClasspathJar ? packageFqnSlash : packageFqnPlatform;
                if (!cp.isPackage(pathToUse)) continue;
                return true;
            }
        }
        return false;
    }

    public NameEnvironmentAnswer findType(char[][] compoundName) {
        if (compoundName == null) {
            return null;
        }
        return this.findTypeInternal(compoundName, null, null);
    }

    public NameEnvironmentAnswer findType(char[] typeName, char[][] packageName) {
        if (typeName == null) {
            return null;
        }
        return this.findTypeInternal(null, typeName, packageName);
    }

    protected NameEnvironmentAnswer findTypeInternal(char[][] compoundName, char[] typeName, char[][] packageName) {
        String pckUnix;
        if (compoundName == null) {
            compoundName = CharOperation.arrayConcat((char[][])packageName, (char[])typeName);
        } else {
            packageName = CharOperation.subarray((char[][])compoundName, (int)0, (int)(compoundName.length - 1));
            typeName = compoundName[compoundName.length - 1];
        }
        String fqnUnix = new String(CharOperation.concatWith((char[][])compoundName, (char)'/'));
        ICompilationUnit overrideCu = this.m_overrideCompilationUnits.get(fqnUnix);
        if (overrideCu != null) {
            return new NameEnvironmentAnswer(overrideCu, null);
        }
        String fileNameUnix = String.valueOf(fqnUnix) + ".class";
        String pckPlatform = pckUnix = new String(CharOperation.concatWith((char[][])packageName, (char)'/'));
        String fileNamePlatform = fileNameUnix;
        if ('/' != File.separatorChar) {
            pckPlatform = new String(CharOperation.concatWith((char[][])packageName, (char)File.separatorChar));
            fileNamePlatform = new String(CharOperation.concat((char[])CharOperation.concatWith((char[][])compoundName, (char)File.separatorChar), (char[])SuffixConstants.SUFFIX_class));
        }
        return this.findTypeInternal(compoundName, typeName, pckUnix, fileNameUnix, pckPlatform, fileNamePlatform);
    }

    protected NameEnvironmentAnswer findTypeInternal(char[][] compoundName, char[] typeName, String pckUnix, String fileNameUnix, String pckPlatform, String fileNamePlatform) {
        for (FileSystem.Classpath cp : this.m_classpaths) {
            NameEnvironmentAnswer answer = null;
            try {
                answer = cp instanceof ClasspathJar ? cp.findClass(typeName, pckUnix, fileNameUnix, false) : cp.findClass(typeName, pckPlatform, fileNamePlatform, false);
            }
            catch (RuntimeException e) {
                throw new SdkException("Error searching for '" + CharOperation.toString((char[][])compoundName) + "' in " + cp, e);
            }
            if (answer == null) continue;
            if (answer.isSourceType()) {
                return answer;
            }
            if (answer.isCompilationUnit()) {
                return answer;
            }
            if (!answer.isBinaryType()) continue;
            return answer;
        }
        return null;
    }

    protected void finalize() throws Throwable {
        try {
            this.cleanup();
        }
        finally {
            super.finalize();
        }
    }

    public static FileSystem.Classpath createClasspath(File f, boolean source, String encoding) {
        if (f == null || !f.canRead()) {
            return null;
        }
        if (encoding == null) {
            encoding = StandardCharsets.UTF_8.name();
        }
        return FileSystem.getClasspath((String)f.getAbsolutePath(), (String)encoding, (boolean)source, null, null, AstCompiler.optsMap);
    }
}

