/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.model.spi.internal.metavalue;

import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.scout.sdk.core.model.api.IAnnotation;
import org.eclipse.scout.sdk.core.model.api.IField;
import org.eclipse.scout.sdk.core.model.api.IMetaValue;
import org.eclipse.scout.sdk.core.model.api.IType;
import org.eclipse.scout.sdk.core.model.api.MetaValueType;
import org.eclipse.scout.sdk.core.model.spi.AnnotationSpi;
import org.eclipse.scout.sdk.core.model.spi.FieldSpi;
import org.eclipse.scout.sdk.core.model.spi.TypeSpi;
import org.eclipse.scout.sdk.core.model.spi.internal.metavalue.AbstractValue;
import org.eclipse.scout.sdk.core.model.spi.internal.metavalue.ArrayMetaValue;
import org.eclipse.scout.sdk.core.model.spi.internal.metavalue.ConstantMetaValue;

public final class MetaValueFactory {
    private static final IMetaValue NULL_META_VALUE = new IMetaValue(){

        @Override
        public MetaValueType type() {
            return MetaValueType.Null;
        }

        @Override
        public <T> T get(Class<T> expectedType) {
            return null;
        }

        public String toString() {
            return "null";
        }
    };

    private MetaValueFactory() {
    }

    public static IMetaValue createNull() {
        return NULL_META_VALUE;
    }

    public static IMetaValue createUnknown(final Object o) {
        if (o == null) {
            return MetaValueFactory.createNull();
        }
        return new AbstractValue(){

            @Override
            public MetaValueType type() {
                return MetaValueType.Unknown;
            }

            @Override
            protected Object getInternalObject(Class<?> expectedType) {
                return o;
            }

            public String toString() {
                StringBuilder b = new StringBuilder(this.type().toString());
                b.append('(');
                b.append(o.toString());
                b.append(')');
                return b.toString();
            }
        };
    }

    public static IMetaValue createFromType(final TypeSpi type) {
        if (type == null) {
            return MetaValueFactory.createNull();
        }
        return new AbstractValue(){

            @Override
            public MetaValueType type() {
                return MetaValueType.Type;
            }

            @Override
            protected Object getInternalObject(Class<?> expectedType) {
                if (IType.class == expectedType || Object.class == expectedType) {
                    return type.wrap();
                }
                if (String.class == expectedType) {
                    return type.getName();
                }
                return type;
            }

            public String toString() {
                return String.valueOf(type.getElementName()) + ".class";
            }
        };
    }

    public static IMetaValue createFromEnum(final FieldSpi enumConstant) {
        if (enumConstant == null) {
            return MetaValueFactory.createNull();
        }
        return new AbstractValue(){

            @Override
            public MetaValueType type() {
                return MetaValueType.Enum;
            }

            @Override
            protected Object getInternalObject(Class<?> expectedType) {
                if (IField.class == expectedType || Object.class == expectedType) {
                    return enumConstant.wrap();
                }
                if (String.class == expectedType) {
                    return enumConstant.getElementName();
                }
                return enumConstant;
            }

            public String toString() {
                return String.valueOf(enumConstant.getDeclaringType().getElementName()) + '.' + enumConstant.getElementName();
            }
        };
    }

    public static IMetaValue createFromAnnotation(final AnnotationSpi a) {
        if (a == null) {
            return MetaValueFactory.createNull();
        }
        return new AbstractValue(){

            @Override
            public MetaValueType type() {
                return MetaValueType.Annotation;
            }

            @Override
            protected Object getInternalObject(Class<?> expectedType) {
                if (IAnnotation.class == expectedType || Object.class == expectedType) {
                    return a.wrap();
                }
                return a;
            }

            public String toString() {
                return this.getInternalObject(IAnnotation.class).toString();
            }
        };
    }

    public static IMetaValue createArray(IMetaValue[] metaArray) {
        if (metaArray == null) {
            return MetaValueFactory.createNull();
        }
        return new ArrayMetaValue(metaArray);
    }

    public static IMetaValue createFromConstant(Constant c) {
        if (c == null) {
            return MetaValueFactory.createUnknown(null);
        }
        switch (c.typeID()) {
            case 10: {
                return new ConstantMetaValue(c, MetaValueType.Int);
            }
            case 12: {
                return MetaValueFactory.createNull();
            }
            case 3: {
                return new ConstantMetaValue(c, MetaValueType.Byte);
            }
            case 4: {
                return new ConstantMetaValue(c, MetaValueType.Short);
            }
            case 2: {
                return new ConstantMetaValue(c, MetaValueType.Char);
            }
            case 9: {
                return new ConstantMetaValue(c, MetaValueType.Float);
            }
            case 8: {
                return new ConstantMetaValue(c, MetaValueType.Double);
            }
            case 5: {
                return new ConstantMetaValue(c, MetaValueType.Bool);
            }
            case 7: {
                return new ConstantMetaValue(c, MetaValueType.Long);
            }
            case 11: {
                return new ConstantMetaValue(c, MetaValueType.String);
            }
        }
        return MetaValueFactory.createUnknown(c);
    }
}

