/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.model.sugar;

import java.lang.reflect.Array;
import org.eclipse.scout.sdk.core.model.api.IAnnotation;
import org.eclipse.scout.sdk.core.model.api.IAnnotationElement;
import org.eclipse.scout.sdk.core.util.SdkException;

public abstract class AbstractManagedAnnotation {
    private IAnnotation m_ann;

    protected AbstractManagedAnnotation() {
    }

    protected void postConstruct(IAnnotation ann) {
        this.m_ann = ann;
    }

    protected <T> T getValue(String name, Class<T> expectedType, Object optionalCustomDefaultValue) {
        IAnnotationElement av = this.m_ann.element(name);
        if ((av == null || av.isDefault()) && optionalCustomDefaultValue != null && Array.getLength(optionalCustomDefaultValue) > 0) {
            return (T)Array.get(optionalCustomDefaultValue, 0);
        }
        if (av == null) {
            throw new SdkException("Annotation '" + this.m_ann.elementName() + "' has no attribute named '" + name + "'.");
        }
        if (expectedType.isArray() && AbstractManagedAnnotation.class.isAssignableFrom(expectedType.getComponentType())) {
            IAnnotation[] a = av.value().get(IAnnotation[].class);
            Class<?> componentType = expectedType.getComponentType();
            Object array = Array.newInstance(componentType, a.length);
            int i = 0;
            while (i < a.length) {
                Array.set(array, i, a[i].wrap(componentType));
                ++i;
            }
            return (T)array;
        }
        if (AbstractManagedAnnotation.class.isAssignableFrom(expectedType)) {
            Class<T> xType = expectedType;
            return av.value().get(IAnnotation.class).wrap(xType);
        }
        return av.value().get(expectedType);
    }

    protected boolean isDefault(String name) {
        IAnnotationElement av = this.m_ann.element(name);
        if (av == null) {
            return false;
        }
        return av.isDefault();
    }

    public IAnnotation unwrap() {
        return this.m_ann;
    }

    public static <A extends AbstractManagedAnnotation> A wrap(IAnnotation a, Class<A> managedAnnotationType) {
        try {
            String typeName = AbstractManagedAnnotation.typeName(managedAnnotationType);
            if (!a.type().name().equals(typeName)) {
                throw new IllegalArgumentException("Managed annotation '" + managedAnnotationType.getName() + "' supports '" + typeName + "' but annotation '" + a.type().name() + "' was passed.");
            }
            AbstractManagedAnnotation annotation = (AbstractManagedAnnotation)managedAnnotationType.newInstance();
            annotation.postConstruct(a);
            return (A)annotation;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("create " + managedAnnotationType.getName() + " with " + a, e);
        }
    }

    public static String typeName(Class<? extends AbstractManagedAnnotation> a) {
        try {
            return (String)a.getField("TYPE_NAME").get(null);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            throw new SdkException("failed to read field " + a.getName() + ".TYPE_NAME. Each managed annotation must define its fully qualified name using a field called 'TYPE_NAME'.", e);
        }
    }
}

