/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.model.sugar;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import org.eclipse.scout.sdk.core.model.api.IField;
import org.eclipse.scout.sdk.core.model.api.IType;
import org.eclipse.scout.sdk.core.model.api.internal.WrappedList;

public class FieldQuery {
    private final IType m_type;
    private boolean m_includeSuperClasses = false;
    private boolean m_includeSuperInterfaces = false;
    private String m_name;
    private int m_flags = -1;
    private Predicate<IField> m_filter;
    private int m_maxResultCount = Integer.MAX_VALUE;

    public FieldQuery(IType type) {
        this.m_type = type;
    }

    public FieldQuery withSuperTypes(boolean b) {
        this.m_includeSuperClasses = b;
        this.m_includeSuperInterfaces = b;
        return this;
    }

    public FieldQuery withSuperClasses(boolean b) {
        this.m_includeSuperClasses = b;
        return this;
    }

    public FieldQuery withSuperInterfaces(boolean b) {
        this.m_includeSuperInterfaces = b;
        return this;
    }

    public FieldQuery withFlags(int flags) {
        this.m_flags = flags;
        return this;
    }

    public FieldQuery withName(String name) {
        this.m_name = name;
        return this;
    }

    public FieldQuery withFilter(Predicate<IField> filter) {
        this.m_filter = filter;
        return this;
    }

    public FieldQuery withMaxResultCount(int maxResultCount) {
        this.m_maxResultCount = maxResultCount;
        return this;
    }

    protected boolean accept(IField f) {
        if (this.m_name != null && !this.m_name.equals(f.elementName())) {
            return false;
        }
        if (this.m_flags >= 0 && (f.flags() & this.m_flags) != this.m_flags) {
            return false;
        }
        return this.m_filter == null || this.m_filter.test(f);
    }

    protected void visitRec(IType t, List<IField> result, int maxCount, boolean onlyTraverse) {
        if (t == null) {
            return;
        }
        if (!onlyTraverse) {
            for (IField f : new WrappedList(t.unwrap().getFields())) {
                if (!this.accept(f)) continue;
                result.add(f);
                if (result.size() < maxCount) continue;
                return;
            }
        }
        if (this.m_includeSuperClasses || this.m_includeSuperInterfaces) {
            this.visitRec(t.superClass(), result, maxCount, !this.m_includeSuperClasses);
            if (result.size() >= maxCount) {
                return;
            }
        }
        if (this.m_includeSuperInterfaces) {
            for (IType superInterface : t.superInterfaces()) {
                this.visitRec(superInterface, result, maxCount, false);
                if (result.size() < maxCount) continue;
                return;
            }
        }
    }

    public boolean existsAny() {
        return this.first() != null;
    }

    public IField first() {
        ArrayList<IField> result = new ArrayList<IField>(1);
        this.visitRec(this.m_type, result, 1, false);
        return result.isEmpty() ? null : (IField)result.get(0);
    }

    public List<IField> list() {
        ArrayList<IField> result = new ArrayList<IField>(this.m_type.unwrap().getFields().size());
        this.visitRec(this.m_type, result, this.m_maxResultCount, false);
        return result;
    }
}

