/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.sourcebuilder;

import org.eclipse.scout.sdk.core.sourcebuilder.field.IFieldSourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.method.IMethodSourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.type.ITypeSourceBuilder;
import org.eclipse.scout.sdk.core.util.CompositeObject;

public final class SortedMemberKeyFactory {
    public static final int FIELD_SERIAL_VERSION_UID = 10;
    public static final int FIELD_CONSTANT = 20;
    public static final int FIELD_CONSTANT_TABLE_COLUMN_ID = 22;
    public static final int FIELD_MEMBER = 30;
    public static final int METHOD_CONSTRUCTOR = 10;
    public static final int METHOD_PROPERTY_ACCESS = 20;
    public static final int METHOD_GET_CONFIGURED = 30;
    public static final int METHOD_EXEC = 40;
    public static final int METHOD_START_FORM = 50;
    public static final int METHOD_FIELD_GETTER = 60;
    public static final int METHOD_FORM_DATA_COLUMN_ACCESS = 70;
    public static final int METHOD_ANY = Integer.MAX_VALUE;
    public static final int TYPE_FORM_FIELD = 10;
    public static final int TYPE_FORM_FIELD_BUTTONS = 20;
    public static final int TYPE_FORM_HANDLER = 30;
    public static final int TYPE_TABLE = 40;
    public static final int TYPE_TABLE_COLUMN = 50;
    public static final int TYPE_TREE = 60;
    public static final int TYPE_ACTIVITYMAP = 70;
    public static final int TYPE_FORM_DATA_PROPERTY = 200;
    public static final int ORDER_INFINITE = Integer.MAX_VALUE;

    private SortedMemberKeyFactory() {
    }

    public static CompositeObject createFieldSerialVersionUidKey(IFieldSourceBuilder sourceBuilder) {
        return new CompositeObject(10, sourceBuilder.getElementName(), sourceBuilder);
    }

    public static CompositeObject createFieldConstantKey(IFieldSourceBuilder sourceBuilder) {
        return new CompositeObject(20, sourceBuilder.getElementName(), sourceBuilder);
    }

    public static CompositeObject createFieldConstantTableColumnIdKey(IFieldSourceBuilder sourceBuilder, int value) {
        return new CompositeObject(22, value, sourceBuilder.getElementName(), sourceBuilder);
    }

    public static CompositeObject createFieldMemberKey(IFieldSourceBuilder sourceBuilder) {
        return new CompositeObject(30, sourceBuilder.getElementName(), sourceBuilder);
    }

    public static CompositeObject createMethodConstructorKey(IMethodSourceBuilder sourceBuilder) {
        return new CompositeObject(10, sourceBuilder.getElementName(), sourceBuilder);
    }

    public static CompositeObject createMethodPropertyKey(IMethodSourceBuilder sourceBuilder) {
        String key2 = sourceBuilder.getElementName().replaceFirst("(get|set|is)", "");
        return new CompositeObject(20, key2, sourceBuilder.getElementName(), sourceBuilder);
    }

    public static CompositeObject createMethodGetConfiguredKey(IMethodSourceBuilder sourceBuilder) {
        return new CompositeObject(30, sourceBuilder.getElementName(), sourceBuilder);
    }

    public static CompositeObject createMethodExecKey(IMethodSourceBuilder sourceBuilder) {
        return new CompositeObject(40, sourceBuilder.getElementName(), sourceBuilder);
    }

    public static CompositeObject createMethodStartFormKey(IMethodSourceBuilder sourceBuilder) {
        return new CompositeObject(50, sourceBuilder.getElementName(), sourceBuilder);
    }

    public static CompositeObject createMethodFormFieldGetterKey(IMethodSourceBuilder sourceBuilder) {
        return new CompositeObject(60, sourceBuilder.getElementName(), sourceBuilder);
    }

    public static CompositeObject createMethodFormDataColumnAccessKey(IMethodSourceBuilder sourceBuilder) {
        String key2 = sourceBuilder.getElementName().replaceFirst("(get|set|is)", "");
        return new CompositeObject(70, key2, sourceBuilder.getElementName(), sourceBuilder);
    }

    public static CompositeObject createMethodAnyKey(IMethodSourceBuilder sourceBuilder) {
        return new CompositeObject(Integer.MAX_VALUE, sourceBuilder.getElementName(), sourceBuilder.getParameters().size(), sourceBuilder);
    }

    public static CompositeObject createTypeFormFieldKey(ITypeSourceBuilder sourceBuilder, double orderNr) {
        return new CompositeObject(10, orderNr, sourceBuilder.getElementName(), sourceBuilder);
    }

    public static CompositeObject createTypeFormHandlerKey(ITypeSourceBuilder sourceBuilder) {
        return new CompositeObject(30, Integer.MAX_VALUE, sourceBuilder.getElementName(), sourceBuilder);
    }

    public static CompositeObject createTypeTableKey(ITypeSourceBuilder sourceBuilder) {
        return new CompositeObject(40, Integer.MAX_VALUE, sourceBuilder.getElementName(), sourceBuilder);
    }

    public static CompositeObject createTypeTableColumnKey(ITypeSourceBuilder sourceBuilder, double order) {
        return new CompositeObject(50, order, sourceBuilder.getElementName(), sourceBuilder);
    }

    public static CompositeObject createTypeTeeKey(ITypeSourceBuilder sourceBuilder) {
        return new CompositeObject(60, Integer.MAX_VALUE, sourceBuilder.getElementName(), sourceBuilder);
    }

    public static CompositeObject createTypeActivityMapKey(ITypeSourceBuilder sourceBuilder) {
        return new CompositeObject(70, Integer.MAX_VALUE, sourceBuilder.getElementName(), sourceBuilder);
    }

    public static CompositeObject createTypeFormDataPropertyKey(ITypeSourceBuilder sourceBuilder) {
        return new CompositeObject(200, Integer.MAX_VALUE, sourceBuilder.getElementName(), sourceBuilder);
    }
}

