/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.sourcebuilder.method;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.scout.sdk.core.importvalidator.IImportValidator;
import org.eclipse.scout.sdk.core.model.api.Flags;
import org.eclipse.scout.sdk.core.model.api.IMethod;
import org.eclipse.scout.sdk.core.model.api.IMethodParameter;
import org.eclipse.scout.sdk.core.model.api.ISourceRange;
import org.eclipse.scout.sdk.core.model.api.IType;
import org.eclipse.scout.sdk.core.model.api.ITypeParameter;
import org.eclipse.scout.sdk.core.signature.SignatureUtils;
import org.eclipse.scout.sdk.core.sourcebuilder.AbstractMemberSourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.ISourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.RawSourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.method.IMethodSourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.methodparameter.IMethodParameterSourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.methodparameter.MethodParameterSourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.typeparameter.ITypeParameterSourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.typeparameter.TypeParameterSourceBuilder;
import org.eclipse.scout.sdk.core.util.PropertyMap;

public class MethodSourceBuilder
extends AbstractMemberSourceBuilder
implements IMethodSourceBuilder {
    private String m_returnTypeSignature;
    private final List<IMethodParameterSourceBuilder> m_parameters = new ArrayList<IMethodParameterSourceBuilder>();
    private final List<ITypeParameterSourceBuilder> m_typeParameters = new ArrayList<ITypeParameterSourceBuilder>();
    private final List<String> m_exceptionSignatures = new ArrayList<String>();
    private ISourceBuilder m_body;

    public MethodSourceBuilder(IMethod element) {
        super(element);
        ISourceRange iSourceRange;
        for (ITypeParameter iTypeParameter : element.typeParameters()) {
            this.addTypeParameter(new TypeParameterSourceBuilder(iTypeParameter));
        }
        this.setReturnTypeSignature(SignatureUtils.getTypeSignature(element.returnType()));
        for (IMethodParameter iMethodParameter : element.parameters().list()) {
            this.addParameter(new MethodParameterSourceBuilder(iMethodParameter));
        }
        for (IType iType : element.exceptionTypes()) {
            this.addExceptionSignature(SignatureUtils.getTypeSignature(iType));
        }
        if (!element.declaringType().isInterface() && !Flags.isAbstract(element.flags()) && (iSourceRange = element.sourceOfBody()).isAvailable()) {
            this.setBody(new RawSourceBuilder(iSourceRange.toString()));
        }
        if (element.declaringType().isInterface()) {
            this.setFlags(this.getFlags() | 0x200);
        }
    }

    public MethodSourceBuilder(String elementName) {
        super(elementName);
    }

    @Override
    public void createSource(StringBuilder source, String lineDelimiter, PropertyMap context, IImportValidator validator) {
        super.createSource(source, lineDelimiter, context, validator);
        source.append(Flags.toString(this.getFlags())).append(' ');
        if (!this.m_typeParameters.isEmpty()) {
            source.append('<');
            for (ITypeParameterSourceBuilder p : this.m_typeParameters) {
                p.createSource(source, lineDelimiter, context, validator);
                source.append(", ");
            }
            source.setLength(source.length() - 2);
            source.append('>');
        }
        if (!StringUtils.isEmpty((CharSequence)this.getReturnTypeSignature())) {
            source.append(String.valueOf(validator.useSignature(this.getReturnTypeSignature())) + " ");
        }
        source.append(this.getElementName());
        source.append('(');
        if (!this.m_parameters.isEmpty()) {
            for (IMethodParameterSourceBuilder param : this.m_parameters) {
                param.createSource(source, lineDelimiter, context, validator);
                source.append(", ");
            }
            source.setLength(source.length() - 2);
        }
        source.append(')');
        Iterator<String> exceptionSigIterator = this.getExceptionSignatures().iterator();
        if (exceptionSigIterator.hasNext()) {
            source.append(" throws ").append(validator.useSignature(exceptionSigIterator.next()));
        }
        while (exceptionSigIterator.hasNext()) {
            source.append(", ").append(validator.useSignature(exceptionSigIterator.next()));
        }
        if (Flags.isInterface(this.getFlags()) || Flags.isAbstract(this.getFlags())) {
            source.append(';');
        } else {
            source.append('{').append(lineDelimiter);
            int beforeContent = source.length();
            if (this.getBody() != null) {
                this.getBody().createSource(source, lineDelimiter, context, validator);
            }
            if (beforeContent < source.length()) {
                source.append(lineDelimiter);
            }
            source.append('}');
        }
    }

    @Override
    public void setReturnTypeSignature(String returnTypeSignature) {
        this.m_returnTypeSignature = returnTypeSignature;
    }

    @Override
    public String getReturnTypeSignature() {
        return this.m_returnTypeSignature;
    }

    @Override
    public boolean addParameter(IMethodParameterSourceBuilder parameter) {
        return this.m_parameters.add(parameter);
    }

    @Override
    public boolean removeParameter(String elementName) {
        Iterator<IMethodParameterSourceBuilder> it = this.m_parameters.iterator();
        while (it.hasNext()) {
            if (!elementName.equals(it.next().getElementName())) continue;
            it.remove();
            return true;
        }
        return false;
    }

    @Override
    public List<IMethodParameterSourceBuilder> getParameters() {
        return Collections.unmodifiableList(this.m_parameters);
    }

    @Override
    public void addTypeParameter(ITypeParameterSourceBuilder typeParameter) {
        this.m_typeParameters.add(typeParameter);
    }

    @Override
    public boolean removeTypeParameter(String elementName) {
        Iterator<ITypeParameterSourceBuilder> it = this.m_typeParameters.iterator();
        while (it.hasNext()) {
            if (!elementName.equals(it.next().getElementName())) continue;
            it.remove();
            return true;
        }
        return false;
    }

    @Override
    public List<ITypeParameterSourceBuilder> getTypeParameters() {
        return Collections.unmodifiableList(this.m_typeParameters);
    }

    @Override
    public String getMethodIdentifier() {
        ArrayList<String> methodParamSignatures = new ArrayList<String>(this.m_parameters.size());
        for (IMethodParameterSourceBuilder param : this.m_parameters) {
            methodParamSignatures.add(param.getDataTypeSignature());
        }
        return SignatureUtils.createMethodIdentifier(this.getElementName(), methodParamSignatures);
    }

    public String toString() {
        return this.getMethodIdentifier();
    }

    @Override
    public void addExceptionSignature(String exceptionSignature) {
        this.m_exceptionSignatures.add(exceptionSignature);
    }

    @Override
    public boolean removeExceptionSignature(String exceptionSignature) {
        return this.m_exceptionSignatures.remove(exceptionSignature);
    }

    @Override
    public void setExceptionSignatures(List<String> exceptionSignatures) {
        this.m_exceptionSignatures.clear();
        if (exceptionSignatures != null) {
            this.m_exceptionSignatures.addAll(exceptionSignatures);
        }
    }

    @Override
    public List<String> getExceptionSignatures() {
        return Collections.unmodifiableList(this.m_exceptionSignatures);
    }

    @Override
    public ISourceBuilder getBody() {
        return this.m_body;
    }

    @Override
    public void setBody(ISourceBuilder body) {
        this.m_body = body;
    }
}

