/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.handlers.delete;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jubula.client.core.businessprocess.TestExecution;
import org.eclipse.jubula.client.core.model.IComponentNamePO;
import org.eclipse.jubula.client.core.model.IObjectMappingAssoziationPO;
import org.eclipse.jubula.client.core.model.IObjectMappingCategoryPO;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.ui.rcp.Plugin;
import org.eclipse.jubula.client.ui.rcp.controllers.IEditorOperation;
import org.eclipse.jubula.client.ui.rcp.editors.ObjectMappingMultiPageEditor;
import org.eclipse.jubula.client.ui.rcp.handlers.delete.AbstractDeleteTreeItemHandler;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.client.ui.rcp.sourceprovider.AbstractJBSourceProvider;
import org.eclipse.jubula.client.ui.rcp.sourceprovider.ObjectMappingModeSourceProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;

public class DeleteTreeItemHandlerOMEditor
extends AbstractDeleteTreeItemHandler {
    public Object executeImpl(ExecutionEvent event) {
        IWorkbenchPart activePart = HandlerUtil.getActivePart((ExecutionEvent)event);
        if (!(activePart instanceof ObjectMappingMultiPageEditor)) {
            return null;
        }
        final ObjectMappingMultiPageEditor editor = (ObjectMappingMultiPageEditor)activePart;
        editor.getEditorHelper().doEditorOperation(new IEditorOperation(){

            @Override
            public void run(IPersistentObject workingPo) {
                IStructuredSelection selection = DeleteTreeItemHandlerOMEditor.this.getSelection();
                Class<?> classType = null;
                Object[] objectArray = selection.toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object obj = objectArray[n2];
                    if (classType == null) {
                        classType = obj.getClass();
                    }
                    if (obj.getClass() != classType) {
                        return;
                    }
                    ++n2;
                }
                Object lastParent = null;
                if (selection.size() == 1) {
                    lastParent = DeleteTreeItemHandlerOMEditor.this.deleteSingleElement(selection.getFirstElement(), editor);
                } else if (selection.size() > 1) {
                    boolean delete = false;
                    delete = MessageDialog.openConfirm((Shell)DeleteTreeItemHandlerOMEditor.this.getActiveShell(), (String)Messages.DeleteTreeItemActionOMEditorOMTitle, (String)Messages.DeleteTreeItemActionOMEditorOMText3);
                    if (delete) {
                        lastParent = DeleteTreeItemHandlerOMEditor.deleteMultipleElements(selection.toArray(), editor);
                    }
                }
                if (lastParent != null) {
                    DeleteTreeItemHandlerOMEditor.this.refreshViewer(editor, lastParent);
                }
            }
        });
        return null;
    }

    public static Object deleteMultipleElements(Object[] toDelete, ObjectMappingMultiPageEditor editor) {
        IObjectMappingCategoryPO lastParent = null;
        Object[] objectArray = toDelete;
        int n = toDelete.length;
        int n2 = 0;
        while (n2 < n) {
            Object node = objectArray[n2];
            if (node instanceof IComponentNamePO) {
                lastParent = editor.getOmEditorBP().deleteCompName((IComponentNamePO)node, true);
            } else if (node instanceof IObjectMappingAssoziationPO) {
                lastParent = editor.getOmEditorBP().deleteAssociation((IObjectMappingAssoziationPO)node);
            } else if (node instanceof IObjectMappingCategoryPO) {
                lastParent = editor.getOmEditorBP().deleteCategory((IObjectMappingCategoryPO)node);
            }
            ++n2;
        }
        if (toDelete.length > 0) {
            editor.getEditorHelper().setDirty(true);
            editor.cleanupNames();
            editor.synchronizeViewers();
        }
        return lastParent;
    }

    private Object deleteSingleElement(Object toDelete, ObjectMappingMultiPageEditor editor) {
        boolean delete = false;
        IObjectMappingCategoryPO lastParent = null;
        if (toDelete instanceof IObjectMappingAssoziationPO) {
            delete = MessageDialog.openConfirm((Shell)this.getActiveShell(), (String)Messages.DeleteTreeItemActionOMEditorOMTitle, (String)Messages.DeleteTreeItemActionOMEditorOMText1);
            if (delete) {
                lastParent = editor.getOmEditorBP().deleteAssociation((IObjectMappingAssoziationPO)toDelete);
                editor.getEditorHelper().setDirty(true);
                editor.cleanupNames();
                editor.synchronizeViewers();
            }
        } else if (toDelete instanceof IComponentNamePO) {
            delete = MessageDialog.openConfirm((Shell)this.getActiveShell(), (String)Messages.DeleteTreeItemActionOMEditorOMTitle, (String)Messages.DeleteTreeItemActionOMEditorOMText2);
            if (delete) {
                lastParent = editor.getOmEditorBP().deleteCompName((IComponentNamePO)toDelete, true);
                editor.getEditorHelper().setDirty(true);
                editor.cleanupNames();
                editor.synchronizeViewers();
            }
        } else if (toDelete instanceof IObjectMappingCategoryPO && (delete = MessageDialog.openConfirm((Shell)this.getActiveShell(), (String)Messages.DeleteTreeItemActionOMEditorOMTitle, (String)Messages.DeleteTreeItemActionOMEditorOMText4))) {
            lastParent = editor.getOmEditorBP().deleteCategory((IObjectMappingCategoryPO)toDelete);
            editor.getEditorHelper().setDirty(true);
            editor.cleanupNames();
            editor.synchronizeViewers();
        }
        return lastParent;
    }

    private void refreshViewer(ObjectMappingMultiPageEditor editor, Object newSelection) {
        editor.getTreeViewer().refresh();
        if (newSelection != null) {
            this.checkCategoryToMapInto(editor);
            editor.getTreeViewer().setSelection((ISelection)new StructuredSelection(newSelection));
        }
    }

    private void checkCategoryToMapInto(ObjectMappingMultiPageEditor editor) {
        ISelection sel = null;
        IObjectMappingCategoryPO categoryToMapInto = editor.getOmEditorBP().getCategoryToCreateIn();
        if (categoryToMapInto != null) {
            editor.getTreeViewer().setSelection((ISelection)new StructuredSelection((Object)categoryToMapInto));
            sel = editor.getTreeViewer().getSelection();
        }
        if (sel == null || sel.isEmpty()) {
            editor.getOmEditorBP().setCategoryToCreateIn(null);
            ObjectMappingModeSourceProvider omsp = (ObjectMappingModeSourceProvider)AbstractJBSourceProvider.getSourceProviderInstance(null, "org.eclipse.jubula.client.ui.rcp.sourceprovider.ObjectMappingModeSourceProvider");
            if (editor.getAut().equals(TestExecution.getInstance().getConnectedAut()) && omsp != null && omsp.isRunning()) {
                String message = NLS.bind((String)Messages.TestExecutionContributorAUTStartedMapping, (Object)Messages.TestExecutionContributorCatUnassigned);
                int icon = 5;
                Plugin.showStatusLine(icon, message);
            }
        }
    }
}

