/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.handlers.project;

import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jubula.client.archive.JsonStorage;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.persistence.PMException;
import org.eclipse.jubula.client.core.progress.IProgressConsole;
import org.eclipse.jubula.client.ui.rcp.Plugin;
import org.eclipse.jubula.client.ui.rcp.controllers.PMExceptionHandler;
import org.eclipse.jubula.client.ui.rcp.handlers.project.RefreshProjectHandler;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.client.ui.utils.ErrorHandlingUtil;
import org.eclipse.jubula.tools.internal.exception.JBException;
import org.eclipse.jubula.tools.internal.exception.ProjectDeletedException;

public final class ExportFileOperation
implements IRunnableWithProgress {
    private final String m_fileName;
    private IProgressConsole m_console;

    public ExportFileOperation(String fileName, IProgressConsole console) {
        this.m_fileName = fileName;
        this.m_console = console;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void run(IProgressMonitor monitor) {
        if (this.m_fileName != null) {
            try {
                try {
                    this.m_console.writeStatus((IStatus)new Status(1, "org.eclipse.jubula.client.core", Messages.RefreshProjectOperationRefreshing));
                    GeneralStorage gstorage = GeneralStorage.getInstance();
                    gstorage.validateProjectExists(gstorage.getProject());
                    final AtomicReference statusOfRefresh = new AtomicReference();
                    Plugin.getDisplay().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            RefreshProjectHandler rph = new RefreshProjectHandler();
                            statusOfRefresh.set((IStatus)rph.executeImpl(null));
                        }
                    });
                    if (statusOfRefresh.get() == null || !((IStatus)statusOfRefresh.get()).isOK()) return;
                    this.m_console.writeStatus((IStatus)new Status(1, "org.eclipse.jubula.client.core", Messages.ExportFileActionExporting));
                    SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.ExportFileActionExporting, (int)1);
                    JsonStorage.save((IProjectPO)gstorage.getProject(), (String)this.m_fileName, (boolean)true, (IProgressMonitor)subMonitor.newChild(1), (IProgressConsole)this.m_console);
                    return;
                }
                catch (PMException e) {
                    ErrorHandlingUtil.createMessageDialog((JBException)((Object)e), null, null);
                    monitor.done();
                    Plugin.stopLongRunning();
                    return;
                }
                catch (ProjectDeletedException projectDeletedException) {
                    PMExceptionHandler.handleProjectDeletedException();
                    monitor.done();
                    Plugin.stopLongRunning();
                    return;
                }
            }
            finally {
                monitor.done();
                Plugin.stopLongRunning();
            }
        } else {
            monitor.done();
        }
    }
}

