/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.javafx.tester.adapter;

import com.sun.javafx.scene.control.skin.SliderSkin;
import java.lang.reflect.Field;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.control.Slider;
import javafx.util.StringConverter;
import org.eclipse.jubula.rc.common.driver.ClickOptions;
import org.eclipse.jubula.rc.common.driver.DragAndDropHelper;
import org.eclipse.jubula.rc.common.exception.StepExecutionException;
import org.eclipse.jubula.rc.common.tester.adapter.interfaces.ISliderComponent;
import org.eclipse.jubula.rc.common.util.MatchUtil;
import org.eclipse.jubula.rc.javafx.driver.EventThreadQueuerJavaFXImpl;
import org.eclipse.jubula.rc.javafx.driver.RobotJavaFXImpl;
import org.eclipse.jubula.rc.javafx.tester.adapter.JavaFXComponentAdapter;
import org.eclipse.jubula.toolkit.enums.ValueSets;
import org.eclipse.jubula.tools.internal.objects.event.EventFactory;
import org.eclipse.jubula.tools.internal.utils.TimeUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SliderAdapter
extends JavaFXComponentAdapter<Slider>
implements ISliderComponent {
    private static final Logger LOG = LoggerFactory.getLogger(SliderAdapter.class);

    public SliderAdapter(Slider objectToAdapt) {
        super(objectToAdapt);
    }

    public String getPosition(String units) {
        return EventThreadQueuerJavaFXImpl.invokeAndWait("getPosition", () -> {
            double value;
            double absValue = ((Slider)this.getRealComponent()).getValue();
            if (units.equalsIgnoreCase(ValueSets.Measure.percent.rcValue())) {
                value = 100.0 * absValue / ((Slider)this.getRealComponent()).getMax();
            } else {
                StringConverter labelFormatter = ((Slider)this.getRealComponent()).getLabelFormatter();
                if (labelFormatter != null) {
                    return labelFormatter.toString((Object)absValue);
                }
                value = absValue;
            }
            return String.valueOf(value);
        });
    }

    private void setPositionViaDragAndDrop(String units, Double value) {
        Slider slider = (Slider)this.getRealComponent();
        double min = slider.getMin();
        double max = slider.getMax();
        double currentRelPos = 100.0 * (slider.getValue() - min) / (max - min);
        double futureRelPos = value;
        if (ValueSets.Measure.value.rcValue().equalsIgnoreCase(units)) {
            futureRelPos = 100.0 * (value - min) / (max - min);
        }
        DragAndDropHelper dndHelper = DragAndDropHelper.getInstance();
        int mouseButton = ValueSets.InteractionMode.primary.rcIntValue();
        dndHelper.setMouseButton(mouseButton);
        RobotJavaFXImpl robot = this.getRobot();
        boolean horizontal = slider.getOrientation().equals((Object)Orientation.HORIZONTAL);
        if (horizontal) {
            this.moveHorizontal(currentRelPos, mouseButton);
        } else {
            this.moveVertical(currentRelPos, mouseButton);
        }
        robot.mousePress(null, null, mouseButton);
        try {
            if (horizontal) {
                this.moveHorizontal(futureRelPos - 2.0, mouseButton);
                TimeUtil.delay((long)200L);
                this.moveHorizontal(futureRelPos, mouseButton);
                TimeUtil.delay((long)200L);
                this.moveHorizontal(futureRelPos + 2.0, mouseButton);
                TimeUtil.delay((long)200L);
                this.moveHorizontal(futureRelPos, mouseButton);
            } else {
                this.moveVertical(futureRelPos - 2.0, mouseButton);
                TimeUtil.delay((long)200L);
                this.moveVertical(futureRelPos, mouseButton);
                TimeUtil.delay((long)200L);
                this.moveVertical(futureRelPos + 2.0, mouseButton);
                TimeUtil.delay((long)200L);
                this.moveVertical(futureRelPos, mouseButton);
            }
            TimeUtil.delay((long)200L);
        }
        finally {
            this.getRobot().mouseRelease(null, null, mouseButton);
        }
    }

    private void moveHorizontal(double targetPos, int mouseButton) {
        this.getRobot().click((Object)this.getTrack(), null, ClickOptions.create().setClickCount(0).setMouseButton(mouseButton), (int)Math.round(targetPos), false, 50, false);
    }

    private void moveVertical(double targetPos, int mouseButton) {
        this.getRobot().click((Object)this.getTrack(), null, ClickOptions.create().setClickCount(0).setMouseButton(mouseButton), 50, false, 100 - (int)Math.round(targetPos), false);
    }

    private Node getTrack() {
        SliderSkin skin = (SliderSkin)((Slider)this.getRealComponent()).getSkin();
        try {
            Field trackField = skin.getClass().getDeclaredField("track");
            trackField.setAccessible(true);
            Node track = (Node)trackField.get(skin);
            return track;
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException exception) {
            throw new StepExecutionException("Track not found", EventFactory.createActionError((String)"TestErrorEvent.NotFound"));
        }
    }

    public void setPosition(String position, String operator, String units) {
        Slider slider = (Slider)this.getRealComponent();
        if (slider.isDisabled()) {
            throw new StepExecutionException("The slider is not enabled", EventFactory.createActionError((String)"The slider is not enabled"));
        }
        Double value = null;
        StringConverter labelFormatter = null;
        try {
            value = Double.valueOf(position);
        }
        catch (NumberFormatException numberFormatException) {
            labelFormatter = slider.getLabelFormatter();
        }
        if (ValueSets.Operator.equals.rcValue().equalsIgnoreCase(operator)) {
            if (labelFormatter != null) {
                value = (Double)labelFormatter.fromString(position);
            }
            if (value == null) {
                this.throwInvalidValueMessage();
            }
        } else {
            double min = slider.getMin();
            double max = slider.getMax();
            double incr = slider.getMajorTickUnit() / (double)(slider.getMinorTickCount() + 1);
            MatchUtil matcher = MatchUtil.getInstance();
            double val = min;
            while (val <= max) {
                String stringToMatch = labelFormatter != null ? labelFormatter.toString((Object)val) : String.valueOf(val);
                if (matcher.match(stringToMatch, position, operator)) {
                    value = val;
                    break;
                }
                val += incr;
            }
        }
        try {
            this.setPositionViaDragAndDrop(units, value);
        }
        catch (StepExecutionException stepExecutionException) {
            this.setValueProgrammatically(units, value);
        }
    }

    private void throwInvalidValueMessage() {
        throw new StepExecutionException("Invalid input for slider", EventFactory.createActionError((String)"TestErrorEvent.InvalidInput"));
    }

    private void setValueProgrammatically(String units, double value) {
        double absValue;
        Slider slider = (Slider)this.getRealComponent();
        if (units.equalsIgnoreCase(ValueSets.Measure.percent.rcValue())) {
            if (value < 0.0 || 100.0 < value) {
                this.throwInvalidValueMessage();
            }
            absValue = slider.getMin() + value * (slider.getMax() - slider.getMin()) * 0.01;
        } else {
            absValue = value;
        }
        double incr = slider.getMajorTickUnit() / (double)(slider.getMinorTickCount() + 1);
        double val = slider.getMin();
        while (val < absValue) {
            val += incr;
        }
        double valueToSet = !slider.snapToTicksProperty().get() ? absValue : (val - absValue <= absValue - (val - incr) ? val : val - incr);
        EventThreadQueuerJavaFXImpl.invokeAndWait("setSliderValue", () -> {
            slider.setValue(valueToSet);
            LOG.warn("Fallback - Value of slider was set programmatically for " + this.getRealComponent());
            return null;
        });
    }
}

