/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.statesystem.core.statevalue;

import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.provisional.statesystem.core.statevalue.CustomStateValue;
import org.eclipse.tracecompass.internal.statesystem.core.Activator;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateValueTypeException;
import org.eclipse.tracecompass.statesystem.core.statevalue.DoubleStateValue;
import org.eclipse.tracecompass.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.tracecompass.statesystem.core.statevalue.IntegerStateValue;
import org.eclipse.tracecompass.statesystem.core.statevalue.LongStateValue;
import org.eclipse.tracecompass.statesystem.core.statevalue.NullStateValue;
import org.eclipse.tracecompass.statesystem.core.statevalue.StringStateValue;

public abstract class TmfStateValue
implements ITmfStateValue {
    private static final int INT_CACHE_SIZE = 128;
    private static final int LONG_CACHE_SIZE = 128;
    private static final int DOUBLE_CACHE_SIZE = 128;
    private static final int STRING_CACHE_SIZE = 512;
    private static final IntegerStateValue[] intCache = new IntegerStateValue[128];
    private static final LongStateValue[] longCache = new LongStateValue[128];
    private static final DoubleStateValue[] doubleCache = new DoubleStateValue[128];
    private static final StringStateValue[] STRING_CACHE = new StringStateValue[512];
    private static TmfStateValue nullValue = new NullStateValue();

    public static final TmfStateValue nullValue() {
        return nullValue;
    }

    public static TmfStateValue newValueInt(int intValue) {
        IntegerStateValue newValue;
        int offset = intValue & 0x7F;
        IntegerStateValue cached = intCache[offset];
        if (cached != null && cached.unboxInt() == intValue) {
            return cached;
        }
        TmfStateValue.intCache[offset] = newValue = new IntegerStateValue(intValue);
        return newValue;
    }

    public static TmfStateValue newValueLong(long longValue) {
        LongStateValue newValue;
        int offset = (int)longValue & 0x7F;
        LongStateValue cached = longCache[offset];
        if (cached != null && cached.unboxLong() == longValue) {
            return cached;
        }
        TmfStateValue.longCache[offset] = newValue = new LongStateValue(longValue);
        return newValue;
    }

    public static TmfStateValue newValueDouble(double value) {
        DoubleStateValue newValue;
        int offset = (int)Double.doubleToLongBits(value) & 0x7F;
        DoubleStateValue cached = doubleCache[offset];
        if (cached != null && Double.compare(cached.unboxDouble(), value) == 0) {
            return cached;
        }
        TmfStateValue.doubleCache[offset] = newValue = new DoubleStateValue(value);
        return newValue;
    }

    public static TmfStateValue newValueString(@Nullable String strValue) {
        StringStateValue newValue;
        if (strValue == null) {
            return TmfStateValue.nullValue();
        }
        int offset = strValue.hashCode() & 0x7F;
        StringStateValue cached = STRING_CACHE[offset];
        if (cached != null && cached.unboxStr().equals(strValue)) {
            return cached;
        }
        char[] cArray = strValue.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (Character.isISOControl(c)) {
                Activator.getDefault().logError("Trying to use invalid string: " + strValue);
                throw new IllegalArgumentException();
            }
            ++n2;
        }
        TmfStateValue.STRING_CACHE[offset] = newValue = new StringStateValue(strValue);
        return newValue;
    }

    private String unboxErrMsg(String targetType) {
        return "Type " + this.getClass().getSimpleName() + " cannot be unboxed into a " + targetType + " value.";
    }

    @Override
    public int unboxInt() {
        throw new StateValueTypeException(this.unboxErrMsg("Int"));
    }

    @Override
    public long unboxLong() {
        throw new StateValueTypeException(this.unboxErrMsg("Long"));
    }

    @Override
    public double unboxDouble() {
        throw new StateValueTypeException(this.unboxErrMsg("Double"));
    }

    @Override
    public String unboxStr() {
        throw new StateValueTypeException(this.unboxErrMsg("String"));
    }

    public static ITmfStateValue newValue(@Nullable Object value) {
        if (value == null) {
            return nullValue;
        }
        if (value instanceof ITmfStateValue) {
            return (ITmfStateValue)value;
        }
        if (value instanceof Integer) {
            return TmfStateValue.newValueInt((Integer)value);
        }
        if (value instanceof Long) {
            return TmfStateValue.newValueLong((Long)value);
        }
        if (value instanceof Double) {
            return TmfStateValue.newValueDouble((Double)value);
        }
        if (value instanceof String) {
            return TmfStateValue.newValueString((String)value);
        }
        if (value instanceof CustomStateValue) {
            return (CustomStateValue)value;
        }
        throw new IllegalArgumentException("Unsupported type: " + value.getClass());
    }
}

