/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.ui.views;

import java.util.List;
import org.eclipse.cdt.make.core.IMakeTarget;
import org.eclipse.cdt.make.internal.ui.MakeUIImages;
import org.eclipse.cdt.make.internal.ui.MakeUIPlugin;
import org.eclipse.cdt.make.ui.dialogs.MakeTargetDialog;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.SelectionListenerAction;

public class EditTargetAction
extends SelectionListenerAction {
    private final Shell shell;

    public EditTargetAction(Shell shell) {
        super(MakeUIPlugin.getResourceString("EditTargetAction.label"));
        this.shell = shell;
        this.setToolTipText(MakeUIPlugin.getResourceString("EditTargetAction.tooltip"));
        this.setDisabledImageDescriptor(MakeUIImages.getImageDescriptor("icons/dtool16/target_edit.gif"));
        this.setImageDescriptor(MakeUIImages.getImageDescriptor("icons/etool16/target_edit.gif"));
    }

    public void run() {
        if (this.canRename()) {
            try {
                MakeTargetDialog dialog = new MakeTargetDialog(this.shell, (IMakeTarget)this.getStructuredSelection().getFirstElement());
                dialog.open();
            }
            catch (CoreException e) {
                MakeUIPlugin.errorDialog(this.shell, MakeUIPlugin.getResourceString("EditTargetAction.exception.internalError"), MakeUIPlugin.getResourceString("EditTargetAction.exception.errorEditingTarget"), e);
            }
        }
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        return super.updateSelection(selection) && this.canRename();
    }

    private boolean canRename() {
        List elements = this.getStructuredSelection().toList();
        return elements.size() == 1 && elements.get(0) instanceof IMakeTarget;
    }
}

