/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.provider;

import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.oomph.setup.Installation;
import org.eclipse.oomph.setup.Product;
import org.eclipse.oomph.setup.ProductVersion;
import org.eclipse.oomph.setup.SetupPackage;
import org.eclipse.oomph.setup.provider.ScopeItemProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstallationItemProvider
extends ScopeItemProvider {
    private static final String EXPECTED_SUFFIX = "/configuration/org.eclipse.oomph.setup/installation.setup";

    public InstallationItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    @Override
    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        if (this.itemPropertyDescriptors == null) {
            super.getPropertyDescriptors(object);
            this.addProductVersionPropertyDescriptor(object);
        }
        return this.itemPropertyDescriptors;
    }

    protected void addProductVersionPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_Installation_productVersion_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_Installation_productVersion_feature", "_UI_Installation_type"), (EStructuralFeature)SetupPackage.Literals.INSTALLATION__PRODUCT_VERSION, true, false, true, null, null, null));
    }

    public Object getImage(Object object) {
        return this.overlayImage(object, this.getResourceLocator().getImage("full/obj16/Installation"));
    }

    @Override
    protected boolean shouldComposeCreationImage() {
        return true;
    }

    @Override
    public String getText(Object object) {
        URI uri;
        Installation installation = (Installation)object;
        if (installation.eContainer() != null) {
            return super.getText(object);
        }
        String label = this.getString("_UI_Installation_type");
        Resource resource = installation.eResource();
        if (resource != null && (uri = resource.getURI()) != null && (label = String.valueOf(label) + " " + uri).endsWith(EXPECTED_SUFFIX)) {
            label = label.substring(0, label.length() - EXPECTED_SUFFIX.length());
        }
        return label;
    }

    @Override
    public void notifyChanged(Notification notification) {
        this.updateChildren(notification);
        switch (notification.getFeatureID(Installation.class)) {
            case 6: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), false, true));
                return;
            }
        }
        super.notifyChanged(notification);
    }

    protected Command factorAddCommand(EditingDomain domain, CommandParameter commandParameter) {
        Collection collection = commandParameter.getCollection();
        if (collection != null) {
            for (Object object : collection) {
                Product product;
                EList versions;
                if (object instanceof ProductVersion) {
                    return SetCommand.create((EditingDomain)domain, (Object)commandParameter.getOwner(), (Object)SetupPackage.Literals.INSTALLATION__PRODUCT_VERSION, object);
                }
                if (!(object instanceof Product) || (versions = (product = (Product)object).getVersions()).isEmpty()) continue;
                return SetCommand.create((EditingDomain)domain, (Object)commandParameter.getOwner(), (Object)SetupPackage.Literals.INSTALLATION__PRODUCT_VERSION, (Object)versions.get(0));
            }
        }
        return super.factorAddCommand(domain, commandParameter);
    }

    @Override
    protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
        super.collectNewChildDescriptors(newChildDescriptors, object);
    }
}

