/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.workspace.internal;

import com.google.common.base.Supplier;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.UncheckedExecutionException;
import com.gradleware.tooling.toolingmodel.OmniBuildEnvironment;
import com.gradleware.tooling.toolingmodel.OmniEclipseProject;
import com.gradleware.tooling.toolingmodel.OmniGradleBuild;
import com.gradleware.tooling.toolingmodel.repository.FetchStrategy;
import com.gradleware.tooling.toolingmodel.repository.TransientRequestAttributes;
import com.gradleware.tooling.toolingmodel.repository.internal.DefaultOmniBuildEnvironment;
import com.gradleware.tooling.toolingmodel.repository.internal.DefaultOmniEclipseProject;
import com.gradleware.tooling.toolingmodel.repository.internal.DefaultOmniGradleBuild;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import org.eclipse.buildship.core.CorePlugin;
import org.eclipse.buildship.core.GradlePluginsRuntimeException;
import org.eclipse.buildship.core.configuration.BuildConfiguration;
import org.eclipse.buildship.core.console.ProcessStreams;
import org.eclipse.buildship.core.util.progress.DelegatingProgressListener;
import org.eclipse.buildship.core.workspace.ModelProvider;
import org.eclipse.buildship.core.workspace.internal.ConnectionAwareLauncherProxy;
import org.eclipse.core.runtime.IProgressMonitor;
import org.gradle.tooling.BuildActionExecuter;
import org.gradle.tooling.CancellationToken;
import org.gradle.tooling.GradleConnector;
import org.gradle.tooling.ModelBuilder;
import org.gradle.tooling.model.build.BuildEnvironment;
import org.gradle.tooling.model.eclipse.EclipseProject;
import org.gradle.tooling.model.gradle.GradleBuild;
import org.gradle.util.GradleVersion;

final class DefaultModelProvider
implements ModelProvider {
    private final BuildConfiguration buildConfiguration;
    private final Cache<Object, Object> cache = CacheBuilder.newBuilder().build();

    public DefaultModelProvider(BuildConfiguration buildConfiguration) {
        this.buildConfiguration = buildConfiguration;
    }

    @Override
    public <T> T fetchModel(Class<T> model, FetchStrategy strategy, CancellationToken token, IProgressMonitor monitor) {
        TransientRequestAttributes transientAttributes = DefaultModelProvider.getTransientRequestAttributes(token, monitor);
        ModelBuilder<T> builder = ConnectionAwareLauncherProxy.newModelBuilder(model, this.buildConfiguration.toGradleArguments(), transientAttributes);
        return this.executeModelBuilder(builder, strategy, model);
    }

    @Override
    public <T> Collection<T> fetchModels(Class<T> model, FetchStrategy strategy, CancellationToken token, IProgressMonitor monitor) {
        TransientRequestAttributes transientAttributes = DefaultModelProvider.getTransientRequestAttributes(token, monitor);
        if (this.supportsCompositeBuilds(token, monitor)) {
            BuildActionExecuter<Collection<T>> executer = ConnectionAwareLauncherProxy.newCompositeModelQueryExecuter(model, this.buildConfiguration.toGradleArguments(), transientAttributes);
            return this.executeBuildActionExecuter(executer, strategy, model);
        }
        ModelBuilder<T> builder = ConnectionAwareLauncherProxy.newModelBuilder(model, this.buildConfiguration.toGradleArguments(), transientAttributes);
        return ImmutableList.of(this.executeModelBuilder(builder, strategy, model));
    }

    @Override
    public OmniBuildEnvironment fetchBuildEnvironment(FetchStrategy strategy, CancellationToken token, IProgressMonitor monitor) {
        BuildEnvironment model = this.fetchModel(BuildEnvironment.class, strategy, token, monitor);
        return DefaultOmniBuildEnvironment.from((BuildEnvironment)model);
    }

    @Override
    public OmniGradleBuild fetchGradleBuild(FetchStrategy strategy, CancellationToken token, IProgressMonitor monitor) {
        GradleBuild model = this.fetchModel(GradleBuild.class, strategy, token, monitor);
        return DefaultOmniGradleBuild.from((GradleBuild)model);
    }

    @Override
    public Set<OmniEclipseProject> fetchEclipseGradleProjects(FetchStrategy strategy, CancellationToken token, IProgressMonitor monitor) {
        Collection<EclipseProject> models = this.fetchModels(EclipseProject.class, strategy, token, monitor);
        ImmutableSet.Builder result = ImmutableSet.builder();
        for (EclipseProject model : models) {
            result.addAll((Iterable)DefaultOmniEclipseProject.from((EclipseProject)model).getAll());
        }
        return result.build();
    }

    private <T> T executeBuildActionExecuter(final BuildActionExecuter<T> executer, FetchStrategy fetchStrategy, Class<?> cacheKey) {
        return this.executeOperation(new Supplier<T>(){

            public T get() {
                return executer.run();
            }
        }, fetchStrategy, cacheKey);
    }

    private <T> T executeModelBuilder(final ModelBuilder<T> builder, FetchStrategy fetchStrategy, Class<?> cacheKey) {
        return this.executeOperation(new Supplier<T>(){

            public T get() {
                return builder.get();
            }
        }, fetchStrategy, cacheKey);
    }

    private <T> T executeOperation(final Supplier<T> operation, FetchStrategy fetchStrategy, Class<?> cacheKey) {
        if (FetchStrategy.FROM_CACHE_ONLY == fetchStrategy) {
            Object result = this.cache.getIfPresent(cacheKey);
            return (T)result;
        }
        if (FetchStrategy.FORCE_RELOAD == fetchStrategy) {
            this.cache.invalidate(cacheKey);
        }
        Object value = this.getFromCache(cacheKey, new Callable<T>(){

            @Override
            public T call() {
                Object model = operation.get();
                return model;
            }
        });
        return (T)value;
    }

    private <U> U getFromCache(Class<?> cacheKey, Callable<U> cacheValueLoader) {
        try {
            Object result = this.cache.get(cacheKey, cacheValueLoader);
            return (U)result;
        }
        catch (Exception e) {
            if (e instanceof UncheckedExecutionException && e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw new GradlePluginsRuntimeException(e);
        }
    }

    private boolean supportsCompositeBuilds(CancellationToken token, IProgressMonitor monitor) {
        BuildEnvironment buildEnvironment = this.fetchModel(BuildEnvironment.class, FetchStrategy.FORCE_RELOAD, token, monitor);
        GradleVersion gradleVersion = GradleVersion.version((String)buildEnvironment.getGradle().getGradleVersion());
        return gradleVersion.getBaseVersion().compareTo(GradleVersion.version((String)"3.3")) >= 0;
    }

    private static TransientRequestAttributes getTransientRequestAttributes(CancellationToken token, IProgressMonitor monitor) {
        ProcessStreams streams = CorePlugin.processStreamsProvider().getBackgroundJobProcessStreams();
        ImmutableList progressListeners = ImmutableList.of((Object)DelegatingProgressListener.withoutDuplicateLifecycleEvents(monitor));
        ImmutableList noEventListeners = ImmutableList.of();
        if (token == null) {
            token = GradleConnector.newCancellationTokenSource().token();
        }
        return new TransientRequestAttributes(false, streams.getOutput(), streams.getError(), streams.getInput(), (List)progressListeners, (List)noEventListeners, token);
    }
}

