/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text;

import org.eclipse.jdt.internal.ui.text.ISourceVersionDependent;
import org.eclipse.jdt.internal.ui.text.JavaHeuristicScanner;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.source.DefaultCharacterPairMatcher;

public final class JavaPairMatcher
extends DefaultCharacterPairMatcher
implements ISourceVersionDependent {
    private boolean fHighlightAngularBrackets = false;

    public JavaPairMatcher(char[] pairs) {
        super(pairs, "___java_partitioning", true);
    }

    public IRegion match(IDocument document, int offset) {
        try {
            return this.performMatch(document, offset);
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    private IRegion performMatch(IDocument document, int offset) throws BadLocationException {
        int peer;
        char currChar;
        if (offset < 0 || document == null) {
            return null;
        }
        char prevChar = document.getChar(Math.max(offset - 1, 0));
        char c = currChar = offset != document.getLength() ? document.getChar(offset) : (char)'\u0000';
        if (prevChar == '>' && currChar != '>') {
            currChar = prevChar;
            prevChar = document.getChar(Math.max(--offset - 1, 0));
        } else if (currChar == '<' && prevChar != '>' && prevChar != '<') {
            prevChar = currChar;
            currChar = document.getChar(++offset);
        }
        if (!(prevChar != '<' && currChar != '>' || this.fHighlightAngularBrackets)) {
            return null;
        }
        if (prevChar == '<' && this.isLessThanOperator(document, offset - 1)) {
            return null;
        }
        IRegion region = super.match(document, offset);
        if (region == null) {
            return region;
        }
        if (currChar == '>' && this.isLessThanOperator(document, peer = region.getOffset())) {
            return null;
        }
        return region;
    }

    private boolean isLessThanOperator(IDocument document, int offset) throws BadLocationException {
        if (offset < 0) {
            return false;
        }
        String contentType = TextUtilities.getContentType((IDocument)document, (String)"___java_partitioning", (int)offset, (boolean)false);
        if (!"__dftl_partition_content_type".equals(contentType)) {
            return false;
        }
        JavaHeuristicScanner scanner = new JavaHeuristicScanner(document, "___java_partitioning", contentType);
        return !this.isTypeParameterOpeningBracket(offset, document, scanner);
    }

    private boolean isTypeParameterOpeningBracket(int offset, IDocument document, JavaHeuristicScanner scanner) {
        try {
            String previous;
            IRegion line = document.getLineInformationOfOffset(offset);
            int prevToken = scanner.previousToken(offset - 1, line.getOffset());
            int prevTokenOffset = scanner.getPosition() + 1;
            String string = previous = prevToken == -1 ? null : document.get(prevTokenOffset, offset - prevTokenOffset).trim();
            return prevToken == 1 || prevToken == 2 || prevToken == 7 || prevToken == 1022 || prevToken == 1019 || prevToken == 2000 && this.isTypeParameterIntroducer(previous) || prevToken == -1;
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }

    private boolean isGreaterThanOperator(IDocument document, int offset) throws BadLocationException {
        if (offset < 0) {
            return false;
        }
        String contentType = TextUtilities.getContentType((IDocument)document, (String)"___java_partitioning", (int)offset, (boolean)false);
        if (!"__dftl_partition_content_type".equals(contentType)) {
            return false;
        }
        JavaHeuristicScanner scanner = new JavaHeuristicScanner(document, "___java_partitioning", contentType);
        return !this.isTypeParameterClosingBracket(offset, document, scanner);
    }

    private boolean isTypeParameterClosingBracket(int offset, IDocument document, JavaHeuristicScanner scanner) {
        try {
            String previous;
            IRegion line = document.getLineInformationOfOffset(offset);
            int prevToken = scanner.previousToken(offset - 1, line.getOffset());
            int prevTokenOffset = scanner.getPosition() + 1;
            String string = previous = prevToken == -1 ? null : document.get(prevTokenOffset, offset - prevTokenOffset).trim();
            return prevToken == 2000 && previous.length() > 0 && Character.isUpperCase(previous.charAt(0)) || prevToken == -1 || prevToken == 14 || prevToken == 10;
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }

    private boolean isTypeParameterIntroducer(String identifier) {
        return identifier.length() > 0 && (Character.isUpperCase(identifier.charAt(0)) || identifier.startsWith("final") || identifier.startsWith("public") || identifier.startsWith("public") || identifier.startsWith("protected") || identifier.startsWith("private"));
    }

    @Override
    public void setSourceVersion(String version) {
        this.fHighlightAngularBrackets = "1.5".compareTo(version) <= 0;
    }

    public boolean isMatchedChar(char ch, IDocument document, int offset) {
        block6: {
            block5: {
                try {
                    if (ch != '<') break block5;
                    if (this.isLessThanOperator(document, offset)) {
                        return false;
                    }
                    break block6;
                }
                catch (BadLocationException badLocationException) {}
            }
            if (ch == '>' && this.isGreaterThanOperator(document, offset)) {
                return false;
            }
        }
        return super.isMatchedChar(ch, document, offset);
    }
}

