/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.news.rcp;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;

public class MessageUtils {
    public static Date getPeriodStartDate(MessageAge messageAge, Date today, Locale locale) {
        Calendar calendar = GregorianCalendar.getInstance(locale);
        calendar.setTime(today);
        if (messageAge == MessageAge.TODAY) {
            return calendar.getTime();
        }
        if (messageAge == MessageAge.YESTERDAY) {
            calendar.add(5, -1);
        } else if (messageAge == MessageAge.THIS_WEEK) {
            int firstDayOfWeek = calendar.getFirstDayOfWeek();
            calendar.set(7, firstDayOfWeek);
        } else if (messageAge == MessageAge.LAST_WEEK) {
            int firstDayOfWeek = calendar.getFirstDayOfWeek();
            calendar.set(7, firstDayOfWeek);
            calendar.add(5, -1);
            calendar.set(7, firstDayOfWeek);
        } else if (messageAge == MessageAge.THIS_MONTH) {
            calendar.set(5, 1);
        } else if (messageAge == MessageAge.LAST_MONTH) {
            calendar.set(5, 1);
            calendar.add(5, -1);
            calendar.set(5, 1);
        } else if (messageAge == MessageAge.THIS_YEAR) {
            calendar.set(2, 0);
            calendar.set(5, 1);
        } else if (messageAge == MessageAge.OLDER) {
            calendar.set(1, calendar.get(1) - 1);
            calendar.set(2, 0);
            calendar.set(5, 1);
        }
        return calendar.getTime();
    }

    public static enum MessageAge {
        TODAY(0),
        YESTERDAY(1),
        THIS_WEEK(2),
        LAST_WEEK(3),
        THIS_MONTH(4),
        LAST_MONTH(5),
        THIS_YEAR(6),
        OLDER(7),
        UNDETERMINED(8);

        private final int index;

        private MessageAge(int index) {
            this.index = index;
        }

        public int getIndex() {
            return this.index;
        }
    }
}

