/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.navigator;

import java.util.Arrays;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.navigator.CommonLayoutActionGroup;
import org.eclipse.jdt.internal.ui.navigator.ShowLibrariesNodeActionGroup;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.navigator.CommonActionProvider;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;
import org.eclipse.ui.navigator.IExtensionActivationListener;
import org.eclipse.ui.navigator.IExtensionStateModel;
import org.eclipse.ui.navigator.INavigatorActivationService;

public class JavaNavigatorViewActionProvider
extends CommonActionProvider {
    private static final int HIERARCHICAL_LAYOUT = 1;
    private static final int FLAT_LAYOUT = 2;
    private static final String TAG_LAYOUT = "org.eclipse.jdt.internal.ui.navigator.layout";
    private static final String TAG_LIBRARIES_NODE = "org.eclipse.jdt.internal.ui.navigator.librariesnode";
    private IExtensionStateModel fStateModel;
    private CommonLayoutActionGroup fLayoutActionGroup;
    private ShowLibrariesNodeActionGroup fShowLibrariesNodeActionGroup;
    private ICommonActionExtensionSite fExtensionSite;
    private String fExtensionId;
    private IActionBars fActionBars;
    private boolean fEnabled = false;
    private IExtensionActivationListener fMenuUpdater = new IExtensionActivationListener(){

        public void onExtensionActivation(String viewerId, String[] theNavigatorExtensionIds, boolean isCurrentlyActive) {
            int search;
            if (JavaNavigatorViewActionProvider.this.fExtensionSite != null && JavaNavigatorViewActionProvider.this.fActionBars != null && (search = Arrays.binarySearch(theNavigatorExtensionIds, JavaNavigatorViewActionProvider.this.fExtensionId)) > -1) {
                if (this.isMyViewer(viewerId)) {
                    if (this.wasEnabled(isCurrentlyActive)) {
                        JavaNavigatorViewActionProvider.this.fLayoutActionGroup.fillActionBars(JavaNavigatorViewActionProvider.this.fActionBars);
                        JavaNavigatorViewActionProvider.this.fShowLibrariesNodeActionGroup.fillActionBars(JavaNavigatorViewActionProvider.this.fActionBars);
                    } else if (this.wasDisabled(isCurrentlyActive)) {
                        JavaNavigatorViewActionProvider.this.fLayoutActionGroup.unfillActionBars(JavaNavigatorViewActionProvider.this.fActionBars);
                        JavaNavigatorViewActionProvider.this.fShowLibrariesNodeActionGroup.unfillActionBars(JavaNavigatorViewActionProvider.this.fActionBars);
                    }
                }
                JavaNavigatorViewActionProvider.this.fEnabled = isCurrentlyActive;
            }
        }

        private boolean isMyViewer(String viewerId) {
            String myViewerId = JavaNavigatorViewActionProvider.this.fExtensionSite.getViewSite().getId();
            return myViewerId != null && myViewerId.equals(viewerId);
        }

        private boolean wasDisabled(boolean isActive) {
            return JavaNavigatorViewActionProvider.this.fEnabled && !isActive;
        }

        private boolean wasEnabled(boolean isActive) {
            return !JavaNavigatorViewActionProvider.this.fEnabled && isActive;
        }
    };

    public void fillActionBars(IActionBars actionBars) {
        this.fActionBars = actionBars;
        this.fLayoutActionGroup.fillActionBars(actionBars);
        this.fShowLibrariesNodeActionGroup.fillActionBars(actionBars);
    }

    public void init(ICommonActionExtensionSite site) {
        this.fExtensionSite = site;
        this.fStateModel = this.fExtensionSite.getExtensionStateModel();
        this.fLayoutActionGroup = new CommonLayoutActionGroup(this.fExtensionSite.getStructuredViewer(), this.fStateModel);
        this.fShowLibrariesNodeActionGroup = new ShowLibrariesNodeActionGroup(this.fExtensionSite.getStructuredViewer(), this.fStateModel);
        INavigatorActivationService activationService = this.fExtensionSite.getContentService().getActivationService();
        activationService.addExtensionActivationListener(this.fMenuUpdater);
        this.fExtensionId = this.fExtensionSite.getExtensionId();
        this.fEnabled = true;
    }

    public void dispose() {
        this.fShowLibrariesNodeActionGroup.dispose();
        this.fLayoutActionGroup.dispose();
        this.fExtensionSite.getContentService().getActivationService().removeExtensionActivationListener(this.fMenuUpdater);
        super.dispose();
    }

    public void setContext(ActionContext context) {
        super.setContext(context);
    }

    public void restoreState(IMemento memento) {
        boolean isCurrentLayoutFlat = true;
        Integer state = null;
        if (memento != null) {
            state = memento.getInteger(TAG_LAYOUT);
        }
        if (state == null) {
            IPreferenceStore store = JavaPlugin.getDefault().getPreferenceStore();
            state = new Integer(store.getInt(TAG_LAYOUT));
        }
        if (state == 2) {
            isCurrentLayoutFlat = true;
        } else if (state == 1) {
            isCurrentLayoutFlat = false;
        }
        this.fStateModel.setBooleanProperty("isLayoutFlat", isCurrentLayoutFlat);
        this.fLayoutActionGroup.setFlatLayout(isCurrentLayoutFlat);
        Boolean showLibrariesNodeState = null;
        if (memento != null) {
            showLibrariesNodeState = memento.getBoolean(TAG_LIBRARIES_NODE);
        }
        if (showLibrariesNodeState == null) {
            IPreferenceStore store = JavaPlugin.getDefault().getPreferenceStore();
            showLibrariesNodeState = new Boolean(store.getString(TAG_LIBRARIES_NODE).equals("") || store.getBoolean(TAG_LIBRARIES_NODE));
        }
        boolean showLibrariesNode = showLibrariesNodeState;
        this.fStateModel.setBooleanProperty("isLibrariesNodeShown", showLibrariesNode);
        this.fShowLibrariesNodeActionGroup.setShowLibrariesNode(showLibrariesNode);
    }

    public void saveState(IMemento aMemento) {
        super.saveState(aMemento);
        IPreferenceStore store = JavaPlugin.getDefault().getPreferenceStore();
        if (this.fStateModel.getBooleanProperty("isLayoutFlat")) {
            store.setValue(TAG_LAYOUT, 2);
        } else {
            store.setValue(TAG_LAYOUT, 1);
        }
        store.setValue(TAG_LIBRARIES_NODE, this.fStateModel.getBooleanProperty("isLibrariesNodeShown"));
    }
}

