/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.util.gradle;

import com.google.common.base.Optional;
import com.google.common.base.Strings;
import com.gradleware.tooling.toolingutils.binding.Validator;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.buildship.core.i18n.CoreMessages;
import org.eclipse.buildship.core.util.gradle.GradleDistributionWrapper;
import org.eclipse.osgi.util.NLS;

public final class GradleDistributionValidator {
    private GradleDistributionValidator() {
    }

    public static Validator<GradleDistributionWrapper> gradleDistributionValidator() {
        return new Validator<GradleDistributionWrapper>(){

            public Optional<String> validate(GradleDistributionWrapper gradleDistribution) {
                GradleDistributionWrapper.DistributionType type = gradleDistribution.getType();
                String configuration = gradleDistribution.getConfiguration();
                if (GradleDistributionWrapper.DistributionType.LOCAL_INSTALLATION == type) {
                    if (Strings.isNullOrEmpty((String)configuration)) {
                        return Optional.of((Object)NLS.bind((String)CoreMessages.ErrorMessage_0_MustBeSpecified, (Object)CoreMessages.GradleDistribution_Label_LocalInstallationDirectory));
                    }
                    if (!new File(configuration).exists()) {
                        return Optional.of((Object)NLS.bind((String)CoreMessages.ErrorMessage_0_DoesNotExist, (Object)CoreMessages.GradleDistribution_Label_LocalInstallationDirectory));
                    }
                    return Optional.absent();
                }
                if (GradleDistributionWrapper.DistributionType.REMOTE_DISTRIBUTION == type) {
                    if (Strings.isNullOrEmpty((String)configuration)) {
                        return Optional.of((Object)NLS.bind((String)CoreMessages.ErrorMessage_0_MustBeSpecified, (Object)CoreMessages.GradleDistribution_Label_RemoteDistributionUri));
                    }
                    if (!this.isValidURI(configuration)) {
                        return Optional.of((Object)NLS.bind((String)CoreMessages.ErrorMessage_0_IsNotValid, (Object)CoreMessages.GradleDistribution_Label_RemoteDistributionUri));
                    }
                    return Optional.absent();
                }
                if (GradleDistributionWrapper.DistributionType.VERSION == type) {
                    if (Strings.isNullOrEmpty((String)configuration)) {
                        return Optional.of((Object)NLS.bind((String)CoreMessages.ErrorMessage_0_MustBeSpecified, (Object)CoreMessages.GradleDistribution_Label_SpecificGradleVersion));
                    }
                    return Optional.absent();
                }
                return Optional.absent();
            }

            private boolean isValidURI(String configuration) {
                try {
                    new URI(configuration);
                    return true;
                }
                catch (URISyntaxException e) {
                    return false;
                }
            }
        };
    }
}

