/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.gitflow.op;

import java.io.IOException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.egit.gitflow.Activator;
import org.eclipse.egit.gitflow.GitFlowConfig;
import org.eclipse.egit.gitflow.GitFlowRepository;
import org.eclipse.egit.gitflow.WrongGitFlowStateException;
import org.eclipse.egit.gitflow.internal.CoreText;
import org.eclipse.egit.gitflow.op.AbstractReleaseOperation;
import org.eclipse.jgit.errors.AmbiguousObjectException;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.RevisionSyntaxException;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.osgi.util.NLS;

public final class ReleaseStartOperation
extends AbstractReleaseOperation {
    private String startCommitSha1;
    private boolean isHead;

    public ReleaseStartOperation(GitFlowRepository repository, String startCommitSha1, String releaseName) {
        this(repository, startCommitSha1, releaseName, ReleaseStartOperation.isHead(repository, startCommitSha1));
    }

    public ReleaseStartOperation(GitFlowRepository repository, String releaseName) {
        this(repository, ReleaseStartOperation.findHead(repository), releaseName, true);
    }

    private ReleaseStartOperation(GitFlowRepository repository, String startCommitSha1, String releaseName, boolean isHead) {
        super(repository, releaseName);
        this.startCommitSha1 = startCommitSha1;
        this.isHead = isHead;
    }

    public void execute(IProgressMonitor monitor) throws CoreException {
        String branchName = this.repository.getConfig().getReleaseBranchName(this.versionName);
        try {
            if (this.releaseExists()) {
                throw new CoreException(Activator.error(String.format(CoreText.ReleaseStartOperation_releaseNameAlreadyExists, this.versionName)));
            }
        }
        catch (IOException e) {
            throw new CoreException(Activator.error(e.getMessage(), e));
        }
        RevCommit commit = this.repository.findCommit(this.startCommitSha1);
        if (commit == null) {
            throw new IllegalStateException(NLS.bind((String)CoreText.StartOperation_unableToFindCommitFor, (Object)this.startCommitSha1));
        }
        this.start(monitor, branchName, commit);
    }

    public boolean releaseExists() throws RevisionSyntaxException, AmbiguousObjectException, IncorrectObjectTypeException, IOException {
        return this.repository.getRepository().resolve("refs/tags/" + this.repository.getConfig().getVersionTagPrefix() + this.versionName) != null;
    }

    @Override
    public ISchedulingRule getSchedulingRule() {
        if (this.isHead) {
            return null;
        }
        return super.getSchedulingRule();
    }

    private static boolean isHead(GitFlowRepository gfRepo, String sha1) {
        try {
            RevCommit head = gfRepo.findHead();
            return sha1.equals(head.getName());
        }
        catch (WrongGitFlowStateException e) {
            return false;
        }
    }

    private static String findHead(GitFlowRepository repository) {
        GitFlowConfig config = repository.getConfig();
        RevCommit head = repository.findHead(config.getDevelop());
        if (head == null) {
            throw new IllegalStateException(NLS.bind((String)CoreText.StartOperation_unableToFindCommitFor, (Object)config.getDevelop()));
        }
        return head.getName();
    }
}

