/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.bugzilla.ui;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaLanguageSettings;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaRepositoryConnector;

public class BugzillaUiExtensionReader {
    public static final String EXTENSION_LANGUAGES = "org.eclipse.mylyn.bugzilla.core.languages";
    public static final String EXTENSION_TMPL_LANGUAGE = "language";
    public static final String ATTR_LANG_VALUE = "value";
    public static final String ELMNT_LANG_NAME = "name";
    public static final String ELMNT_LANG_ERROR_LOGIN = "error_login";
    public static final String ELMNT_LANG_ERROR_COLLISION = "error_collision";
    public static final String ELMNT_LANG_ERROR_COMMENT_REQIRED = "error_comment_required";
    public static final String ELMNT_LANG_ERROR_LOGGED_OUT = "error_logged_out";
    public static final String ELMNT_LANG_BAD_LOGIN = "bad_login";
    public static final String ELMNT_LANG_PROCESSED = "processed";
    public static final String ELMNT_LANG_CHANGES_SUBMITTED = "changes_submitted";
    private static boolean coreExtensionsRead = false;

    public static void initStartupExtensions() {
        if (!coreExtensionsRead) {
            IExtension[] templateExtensions;
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IExtensionPoint templatesExtensionPoint = registry.getExtensionPoint(EXTENSION_LANGUAGES);
            IExtension[] iExtensionArray = templateExtensions = templatesExtensionPoint.getExtensions();
            int n = templateExtensions.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement[] elements;
                IExtension templateExtension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = elements = templateExtension.getConfigurationElements();
                int n3 = elements.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement element = iConfigurationElementArray[n4];
                    if (element.getName().equals(EXTENSION_TMPL_LANGUAGE)) {
                        BugzillaUiExtensionReader.readLanguageTemplate(element);
                    }
                    ++n4;
                }
                ++n2;
            }
            coreExtensionsRead = true;
        }
    }

    private static void readLanguageTemplate(IConfigurationElement element) {
        String languageName = element.getAttribute(ELMNT_LANG_NAME);
        if (languageName != null) {
            BugzillaLanguageSettings bugzillaLanguageSettings = new BugzillaLanguageSettings(languageName);
            IConfigurationElement[] iConfigurationElementArray = element.getChildren();
            int n = iConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement configElement = iConfigurationElementArray[n2];
                String name = configElement.getName();
                if (name != null && name.equals("languageAttribute")) {
                    String command = configElement.getAttribute("command");
                    String response = configElement.getAttribute("response");
                    bugzillaLanguageSettings.addLanguageAttribute(command, response);
                }
                ++n2;
            }
            BugzillaRepositoryConnector.addLanguageSetting((BugzillaLanguageSettings)bugzillaLanguageSettings);
        } else {
            StatusHandler.log((IStatus)new Status(2, "org.eclipse.mylyn.bugzilla.ui", "Could not load language template extension " + element.getName()));
        }
    }
}

