/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.s.annotation;

import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.scout.sdk.core.model.api.IAnnotatable;
import org.eclipse.scout.sdk.core.model.api.IType;
import org.eclipse.scout.sdk.core.s.annotation.FormDataAnnotation;

public class FormDataAnnotationDescriptor {
    private FormDataAnnotation.SdkCommand m_sdkCommand;
    private FormDataAnnotation.DefaultSubtypeSdkCommand m_defaultSubtypeSdkCommand;
    private int m_genericOrdinal = -1;
    private IType m_formDataType;
    private IType m_superType;
    private IAnnotatable m_annotationOwner;
    private final Set<IType> m_interfaceTypes = new LinkedHashSet<IType>();
    private IType m_genericOrdinalDefinitionType;

    public static boolean isCreate(FormDataAnnotationDescriptor anot) {
        if (anot == null) {
            return false;
        }
        return anot.getSdkCommand() == FormDataAnnotation.SdkCommand.CREATE || anot.getSdkCommand() == null && anot.getDefaultSubtypeSdkCommand() == FormDataAnnotation.DefaultSubtypeSdkCommand.CREATE;
    }

    public static boolean isIgnore(FormDataAnnotationDescriptor anot) {
        if (anot == null) {
            return false;
        }
        return anot.getSdkCommand() == FormDataAnnotation.SdkCommand.IGNORE || anot.getSdkCommand() == null && anot.getDefaultSubtypeSdkCommand() == FormDataAnnotation.DefaultSubtypeSdkCommand.IGNORE;
    }

    public static boolean isSdkCommandDefault(FormDataAnnotationDescriptor anot) {
        return anot != null && anot.getSdkCommand() == FormDataAnnotation.SdkCommand.DEFAULT;
    }

    public static boolean isSdkCommandCreate(FormDataAnnotationDescriptor anot) {
        return anot != null && anot.getSdkCommand() == FormDataAnnotation.SdkCommand.CREATE;
    }

    public static boolean isSdkCommandUse(FormDataAnnotationDescriptor anot) {
        return anot != null && anot.getSdkCommand() == FormDataAnnotation.SdkCommand.USE;
    }

    public static boolean isSdkCommandIgnore(FormDataAnnotationDescriptor anot) {
        return anot != null && anot.getSdkCommand() == FormDataAnnotation.SdkCommand.IGNORE;
    }

    public static boolean isDefaultSubtypeSdkCommandCreate(FormDataAnnotationDescriptor anot) {
        return anot != null && anot.getDefaultSubtypeSdkCommand() == FormDataAnnotation.DefaultSubtypeSdkCommand.CREATE;
    }

    public static boolean isDefaultSubtypeSdkCommandIgnore(FormDataAnnotationDescriptor anot) {
        return anot != null && anot.getDefaultSubtypeSdkCommand() == FormDataAnnotation.DefaultSubtypeSdkCommand.IGNORE;
    }

    public static boolean isDefaultSubtypeSdkCommandDefault(FormDataAnnotationDescriptor anot) {
        return anot != null && anot.getDefaultSubtypeSdkCommand() == FormDataAnnotation.DefaultSubtypeSdkCommand.DEFAULT;
    }

    public void setFormDataType(IType formDataType) {
        this.m_formDataType = formDataType;
    }

    public IType getFormDataType() {
        return this.m_formDataType;
    }

    public void setSdkCommand(FormDataAnnotation.SdkCommand sdkCommand) {
        this.m_sdkCommand = sdkCommand;
    }

    public FormDataAnnotation.SdkCommand getSdkCommand() {
        return this.m_sdkCommand;
    }

    public void setDefaultSubtypeSdkCommand(FormDataAnnotation.DefaultSubtypeSdkCommand defaultSubtypeSdkCommand) {
        this.m_defaultSubtypeSdkCommand = defaultSubtypeSdkCommand;
    }

    public FormDataAnnotation.DefaultSubtypeSdkCommand getDefaultSubtypeSdkCommand() {
        return this.m_defaultSubtypeSdkCommand;
    }

    public void setGenericOrdinal(int genericOrdinal) {
        this.m_genericOrdinal = genericOrdinal;
    }

    public int getGenericOrdinal() {
        return this.m_genericOrdinal;
    }

    public void setSuperType(IType superType) {
        this.m_superType = superType;
    }

    public IType getSuperType() {
        return this.m_superType;
    }

    public IAnnotatable getAnnotationOwner() {
        return this.m_annotationOwner;
    }

    public void setAnnotationOwner(IAnnotatable annotationOwner) {
        this.m_annotationOwner = annotationOwner;
    }

    public void addInterface(IType sig) {
        this.m_interfaceTypes.add(sig);
    }

    public void addInterfaces(IType[] interfaces) {
        IType[] iTypeArray = interfaces;
        int n = interfaces.length;
        int n2 = 0;
        while (n2 < n) {
            IType t = iTypeArray[n2];
            this.m_interfaceTypes.add(t);
            ++n2;
        }
    }

    public Set<IType> getInterfaceSignatures() {
        return new LinkedHashSet<IType>(this.m_interfaceTypes);
    }

    public IType getGenericOrdinalDefinitionType() {
        return this.m_genericOrdinalDefinitionType;
    }

    public void setGenericOrdinalDefinitionType(IType genericOrdinalDefinitionType) {
        this.m_genericOrdinalDefinitionType = genericOrdinalDefinitionType;
    }
}

