/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.s.sourcebuilder.jaxws;

import java.util.List;
import org.eclipse.scout.sdk.core.model.api.IJavaEnvironment;
import org.eclipse.scout.sdk.core.s.model.ScoutAnnotationSourceBuilderFactory;
import org.eclipse.scout.sdk.core.signature.SignatureUtils;
import org.eclipse.scout.sdk.core.sourcebuilder.comment.CommentSourceBuilderFactory;
import org.eclipse.scout.sdk.core.sourcebuilder.compilationunit.AbstractEntitySourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.compilationunit.ICompilationUnitSourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.method.IMethodSourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.method.MethodSourceBuilderFactory;
import org.eclipse.scout.sdk.core.sourcebuilder.type.ITypeSourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.type.TypeSourceBuilder;
import org.eclipse.scout.sdk.core.util.SdkLog;

public class WebServiceProviderSourceBuilder
extends AbstractEntitySourceBuilder {
    private String m_portTypeSignature;

    public WebServiceProviderSourceBuilder(String entityName, String packageName, IJavaEnvironment env) {
        super(entityName, packageName, env);
    }

    public void setup() {
        this.setComment(CommentSourceBuilderFactory.createDefaultCompilationUnitComment((ICompilationUnitSourceBuilder)this));
        TypeSourceBuilder typeBuilder = new TypeSourceBuilder(this.getEntityName());
        typeBuilder.setFlags(1);
        typeBuilder.addInterfaceSignature(this.getPortTypeSignature());
        typeBuilder.addAnnotation(ScoutAnnotationSourceBuilderFactory.createApplicationScoped());
        this.addType((ITypeSourceBuilder)typeBuilder);
        if (this.getJavaEnvironment().findType(SignatureUtils.toFullyQualifiedName((String)this.getPortTypeSignature())) == null) {
            SdkLog.warning((String)"Web Service implementation could not be filled with all methods because the port type could not be found.", (Object[])new Object[0]);
            return;
        }
        List unimplementedMethods = MethodSourceBuilderFactory.createUnimplementedMethods((ITypeSourceBuilder)typeBuilder, (String)this.getPackageName(), (IJavaEnvironment)this.getJavaEnvironment());
        for (IMethodSourceBuilder unimplemented : unimplementedMethods) {
            typeBuilder.addMethod(unimplemented);
        }
    }

    public String getPortTypeSignature() {
        return this.m_portTypeSignature;
    }

    public void setPortTypeSignature(String portTypeSignature) {
        this.m_portTypeSignature = portTypeSignature;
    }
}

