/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.s.util.maven;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URLClassLoader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.maven.cli.MavenCli;
import org.eclipse.scout.sdk.core.s.util.maven.IMavenRunnerSpi;
import org.eclipse.scout.sdk.core.s.util.maven.MavenBuild;
import org.eclipse.scout.sdk.core.s.util.maven.MavenSandboxClassLoaderFactory;
import org.eclipse.scout.sdk.core.util.SdkConsole;
import org.eclipse.scout.sdk.core.util.SdkException;
import org.eclipse.scout.sdk.core.util.SdkLog;

public class MavenCliRunner
implements IMavenRunnerSpi {
    private static final String MAVEN_CALL_FAILED_MSG = "Maven call failed.";

    @Override
    public void execute(MavenBuild build) {
        Validate.notNull((Object)build);
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (URLClassLoader loader = MavenSandboxClassLoaderFactory.build();){
                SdkLog.debug((String)"Executing embedded {}", (Object[])new Object[]{build.toString()});
                MavenCliRunner.execute((File)Validate.notNull((Object)build.getWorkingDirectory()), build.getOptions(), build.getGoals(), build.getProperties(), loader);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new SdkException((Throwable)e);
        }
    }

    protected static synchronized void execute(File workingDirectory, Set<String> options, Set<String> goals, Map<String, String> props, ClassLoader loader) throws IOException {
        String oldMultiModuleProjectDir = System.getProperty("maven.multiModuleProjectDirectory");
        ClassLoader oldContextClassLoader = Thread.currentThread().getContextClassLoader();
        InputStream origSystemIn = System.in;
        try {
            System.setProperty("maven.multiModuleProjectDirectory", workingDirectory.getAbsolutePath());
            System.setIn(new ByteArrayInputStream(new byte[0]));
            Thread.currentThread().setContextClassLoader(loader);
            String[] mavenArgs = MavenCliRunner.getMavenArgs(new LinkedHashSet<String>(options), goals, new LinkedHashMap<String, String>(props));
            MavenCliRunner.runMavenInSandbox(mavenArgs, workingDirectory, SdkLog.getLogLevel(), loader);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldContextClassLoader);
            System.setIn(origSystemIn);
            if (oldMultiModuleProjectDir == null) {
                System.clearProperty("maven.multiModuleProjectDirectory");
            } else {
                System.setProperty("maven.multiModuleProjectDirectory", oldMultiModuleProjectDir);
            }
        }
    }

    protected static String[] getMavenArgs(Set<String> options, Set<String> goals, Map<String, String> props) {
        String mavenExtClassPath = "maven.ext.class.path";
        if (!props.containsKey("maven.ext.class.path")) {
            props.put("maven.ext.class.path", "");
        }
        if (SdkLog.isDebugEnabled()) {
            options.add(Character.toString('X'));
            options.add(Character.toString('e'));
        }
        ArrayList<String> args = new ArrayList<String>(goals.size() + options.size() + props.size());
        args.addAll(goals);
        for (String option : options) {
            args.add(String.valueOf('-') + option);
        }
        for (String prop : MavenBuild.getMapAsList(props)) {
            args.add("-D" + prop);
        }
        return args.toArray(new String[args.size()]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static void runMavenInSandbox(String[] mavenArgs, File workingDirectory, Level level, ClassLoader loader) throws IOException {
        String charset = StandardCharsets.UTF_8.name();
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try {
                ByteArrayOutputStream bOut = new ByteArrayOutputStream();
                try {
                    PrintStream out = new PrintStream((OutputStream)bOut, true, charset);
                    try {
                        block27: {
                            ByteArrayOutputStream bErr = new ByteArrayOutputStream();
                            try {
                                try (PrintStream err = new PrintStream((OutputStream)bErr, true, charset);){
                                    loader.loadClass(SdkConsole.class.getName()).getMethod("getConsoleSpi", new Class[0]).invoke(null, new Object[0]);
                                    loader.loadClass(SdkLog.class.getName()).getMethod("setLogLevel", Level.class).invoke(null, level);
                                    Class<?> mavenCli = loader.loadClass(MavenCli.class.getName());
                                    Method doMain = mavenCli.getMethod("doMain", String[].class, String.class, PrintStream.class, PrintStream.class);
                                    Object ret = doMain.invoke(mavenCli.newInstance(), mavenArgs, workingDirectory.getAbsolutePath(), out, err);
                                    MavenCliRunner.logStream(Level.INFO, bOut, charset);
                                    int result = (Integer)ret;
                                    if (result != 0) {
                                        MavenCliRunner.logStream(Level.SEVERE, bErr, charset);
                                        throw new IOException(MAVEN_CALL_FAILED_MSG);
                                    }
                                }
                                if (bErr == null) break block27;
                            }
                            catch (Throwable throwable2) {
                                if (throwable == null) {
                                    throwable = throwable2;
                                } else if (throwable != throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                if (bErr == null) throw throwable;
                                bErr.close();
                                throw throwable;
                            }
                            bErr.close();
                        }
                        if (out != null) {
                            out.close();
                        }
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        if (out == null) throw throwable;
                        out.close();
                        throw throwable;
                    }
                    if (bOut == null) return;
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    if (bOut == null) throw throwable;
                    bOut.close();
                    throw throwable;
                }
                bOut.close();
                return;
            }
            catch (Throwable throwable5) {
                if (throwable == null) {
                    throwable = throwable5;
                    throw throwable;
                }
                if (throwable == throwable5) throw throwable;
                throwable.addSuppressed(throwable5);
                throw throwable;
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new IOException(e);
        }
    }

    protected static void logStream(Level level, ByteArrayOutputStream stream, String charset) throws UnsupportedEncodingException {
        String outString = stream.toString(charset);
        if (StringUtils.isNotBlank((CharSequence)outString)) {
            SdkLog.log((Level)level, (String)"Output of embedded Maven call:\nMVN-BEGIN\n{}\nMVN-END\n", (Object[])new Object[]{outString});
        }
    }
}

