/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare.internal;

import org.eclipse.compare.IContentChangeListener;
import org.eclipse.compare.IContentChangeNotifier;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.swt.widgets.Display;

public class ContentChangeNotifier
implements IContentChangeNotifier {
    private ListenerList fListenerList;
    private final IContentChangeNotifier element;

    public ContentChangeNotifier(IContentChangeNotifier element) {
        this.element = element;
    }

    @Override
    public void addContentChangeListener(IContentChangeListener listener) {
        if (this.fListenerList == null) {
            this.fListenerList = new ListenerList();
        }
        this.fListenerList.add((Object)listener);
    }

    @Override
    public void removeContentChangeListener(IContentChangeListener listener) {
        if (this.fListenerList != null) {
            this.fListenerList.remove((Object)listener);
            if (this.fListenerList.isEmpty()) {
                this.fListenerList = null;
            }
        }
    }

    public void fireContentChanged() {
        if (this.isEmpty()) {
            return;
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                Object[] listeners = ContentChangeNotifier.this.fListenerList.getListeners();
                int i = 0;
                while (i < listeners.length) {
                    final IContentChangeListener contentChangeListener = (IContentChangeListener)listeners[i];
                    SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                        public void run() throws Exception {
                            contentChangeListener.contentChanged(ContentChangeNotifier.this.element);
                        }

                        public void handleException(Throwable exception) {
                        }
                    });
                    ++i;
                }
            }
        };
        if (Display.getCurrent() == null) {
            Display.getDefault().syncExec(runnable);
        } else {
            runnable.run();
        }
    }

    public boolean isEmpty() {
        return this.fListenerList == null || this.fListenerList.isEmpty();
    }
}

