/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.model.spi.internal;

import java.io.File;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.Validate;
import org.eclipse.jdt.internal.compiler.batch.FileSystem;
import org.eclipse.jdt.internal.compiler.env.AccessRuleSet;
import org.eclipse.jdt.internal.compiler.util.Util;
import org.eclipse.scout.sdk.core.model.spi.internal.ClasspathEntry;
import org.eclipse.scout.sdk.core.model.spi.internal.JreInfo;
import org.eclipse.scout.sdk.core.util.SdkException;
import org.eclipse.scout.sdk.core.util.SdkLog;

public class ClasspathBuilder {
    private static final Map<Path, JreInfo> JRE_INFOS = new ConcurrentHashMap<Path, JreInfo>();
    private final FileSystem.Classpath[] m_full;
    private final List<FileSystem.Classpath> m_bootClasspath;
    private final Collection<FileSystem.Classpath> m_classpath;
    private final Set<ClasspathEntry> m_entries;
    private final JreInfo m_jreInfo;

    protected ClasspathBuilder(Path jreHome, Collection<? extends ClasspathEntry> paths) {
        Path javaHome = Optional.ofNullable(jreHome).orElseGet(() -> ((File)Validate.notNull((Object)Util.getJavaHome(), (String)"Cannot calculate the running Java home. Please specify a JRE home explicitly.", (Object[])new Object[0])).toPath());
        this.m_jreInfo = JRE_INFOS.computeIfAbsent(javaHome, JreInfo::new);
        Map<ClasspathEntry, FileSystem.Classpath> classpath = ClasspathBuilder.toClasspath(paths);
        this.m_entries = classpath.keySet();
        this.m_classpath = classpath.values();
        this.m_bootClasspath = ClasspathBuilder.createBootClasspathFor(this.m_jreInfo);
        ArrayList<FileSystem.Classpath> fullCp = new ArrayList<FileSystem.Classpath>(classpath.size() + this.m_bootClasspath.size());
        fullCp.addAll(classpath.values());
        fullCp.addAll(this.m_bootClasspath);
        this.m_full = fullCp.toArray(new FileSystem.Classpath[fullCp.size()]);
    }

    public FileSystem.Classpath[] fullClasspath() {
        return this.m_full;
    }

    public List<FileSystem.Classpath> bootClasspath() {
        return this.m_bootClasspath;
    }

    public Collection<FileSystem.Classpath> userClasspath() {
        return this.m_classpath;
    }

    public Set<ClasspathEntry> entries() {
        return this.m_entries;
    }

    public JreInfo jreInfo() {
        return this.m_jreInfo;
    }

    private static List<FileSystem.Classpath> createBootClasspathFor(JreInfo jre) {
        ArrayList<FileSystem.Classpath> bootClasspath = new ArrayList<FileSystem.Classpath>();
        ClasspathBuilder.appendSrcClasspathToEnd(bootClasspath, jre.rtSrcZip(), null);
        Path jreHome = jre.jreHome();
        if (jre.supportsJrtModules()) {
            SdkLog.debug("Boot Classpath uses JRT modules of Java home: {}.", jreHome);
            bootClasspath.add(ClasspathBuilder.resolveJrtClasspath(jreHome));
        } else {
            SdkLog.debug("Using Boot Classpath based on the jars in the lib folder of Java home: {}.", jreHome);
            for (Path cpEntry : jre.bootClasspath()) {
                ClasspathBuilder.appendBinClasspathToEnd(bootClasspath, cpEntry);
            }
        }
        return bootClasspath;
    }

    private static FileSystem.Classpath resolveJrtClasspath(Path jreHome) {
        try {
            Method getJrtClasspath = FileSystem.class.getDeclaredMethod("getJrtClasspath", String.class, String.class, AccessRuleSet.class, Map.class);
            return (FileSystem.Classpath)getJrtClasspath.invoke(null, jreHome.toString(), null, null, null);
        }
        catch (NoSuchMethodException nsme) {
            throw new SdkException("The specified JRE (" + jreHome + ") uses a JRT FileSystem (Java 9 or newer). But the compiler used does not support JRT. Please update to a newer JDT/ECJ compiler.", nsme);
        }
        catch (ReflectiveOperationException e) {
            throw new SdkException(e);
        }
    }

    private static Map<ClasspathEntry, FileSystem.Classpath> toClasspath(Collection<? extends ClasspathEntry> paths) {
        LinkedHashMap<ClasspathEntry, FileSystem.Classpath> result = new LinkedHashMap<ClasspathEntry, FileSystem.Classpath>(paths.size());
        for (ClasspathEntry classpathEntry : paths) {
            if (result.containsKey(classpathEntry)) continue;
            FileSystem.Classpath classpath = ClasspathBuilder.toClasspath(classpathEntry.path(), classpathEntry.mode() == 1, classpathEntry.encoding());
            if (classpath == null) continue;
            result.put(classpathEntry, classpath);
        }
        return result;
    }

    private static void appendBinClasspathToEnd(Collection<FileSystem.Classpath> collector, Path f) {
        ClasspathBuilder.appendClasspathToEnd(collector, f, false, null);
    }

    private static void appendSrcClasspathToEnd(Collection<FileSystem.Classpath> collector, Path f, String encoding) {
        ClasspathBuilder.appendClasspathToEnd(collector, f, true, encoding);
    }

    private static void appendClasspathToEnd(Collection<FileSystem.Classpath> collector, Path f, boolean isSourceOnly, String encoding) {
        FileSystem.Classpath cp = ClasspathBuilder.toClasspath(f, isSourceOnly, encoding);
        if (cp == null) {
            return;
        }
        collector.add(cp);
    }

    private static FileSystem.Classpath toClasspath(Path f, boolean isSourceOnly, String encoding) {
        if (f == null || !Files.isReadable(f)) {
            return null;
        }
        return FileSystem.getClasspath((String)f.toString(), (String)encoding, (boolean)isSourceOnly, null, null, null);
    }
}

