/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.model.spi.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.Validate;
import org.eclipse.jdt.internal.compiler.ast.TypeParameter;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.scout.sdk.core.model.api.ISourceRange;
import org.eclipse.scout.sdk.core.model.api.ITypeParameter;
import org.eclipse.scout.sdk.core.model.api.internal.TypeParameterImplementor;
import org.eclipse.scout.sdk.core.model.spi.CompilationUnitSpi;
import org.eclipse.scout.sdk.core.model.spi.JavaElementSpi;
import org.eclipse.scout.sdk.core.model.spi.MemberSpi;
import org.eclipse.scout.sdk.core.model.spi.TypeParameterSpi;
import org.eclipse.scout.sdk.core.model.spi.TypeSpi;
import org.eclipse.scout.sdk.core.model.spi.internal.AbstractJavaElementWithJdt;
import org.eclipse.scout.sdk.core.model.spi.internal.AbstractMemberWithJdt;
import org.eclipse.scout.sdk.core.model.spi.internal.JavaEnvironmentWithJdt;
import org.eclipse.scout.sdk.core.model.spi.internal.SpiWithJdtUtils;

public class DeclarationTypeParameterWithJdt
extends AbstractJavaElementWithJdt<ITypeParameter>
implements TypeParameterSpi {
    private final AbstractMemberWithJdt<?> m_declaringMember;
    private final TypeParameter m_astNode;
    private final int m_index;
    private final String m_name;
    private List<TypeSpi> m_bounds;
    private ISourceRange m_source;

    DeclarationTypeParameterWithJdt(JavaEnvironmentWithJdt env, AbstractMemberWithJdt<?> declaringMember, TypeParameter astNode, int index) {
        super(env);
        this.m_declaringMember = (AbstractMemberWithJdt)Validate.notNull(declaringMember);
        this.m_astNode = (TypeParameter)Validate.notNull((Object)astNode);
        this.m_index = index;
        this.m_name = new String(this.m_astNode.name);
    }

    @Override
    protected JavaElementSpi internalFindNewElement(JavaEnvironmentWithJdt newEnv) {
        MemberSpi newMember = (MemberSpi)((AbstractJavaElementWithJdt)((Object)this.getDeclaringMember())).internalFindNewElement(newEnv);
        if (newMember != null && newMember.getTypeParameters().size() > this.m_index) {
            return newMember.getTypeParameters().get(this.m_index);
        }
        return null;
    }

    @Override
    protected ITypeParameter internalCreateApi() {
        return new TypeParameterImplementor(this);
    }

    public TypeParameter getInternalTypeParameter() {
        return this.m_astNode;
    }

    @Override
    public List<TypeSpi> getBounds() {
        TypeSpi t;
        if (this.m_bounds != null) {
            return this.m_bounds;
        }
        boolean hasType = this.m_astNode.type != null;
        boolean hasBounds = this.m_astNode.bounds != null && this.m_astNode.bounds.length > 0;
        int size = 0;
        if (hasType) {
            ++size;
        }
        if (hasBounds) {
            size += this.m_astNode.bounds.length;
        }
        ArrayList<TypeSpi> result = new ArrayList<TypeSpi>(size);
        Scope scope = SpiWithJdtUtils.memberScopeOf(this);
        if (hasType && (t = SpiWithJdtUtils.bindingToType(this.m_env, this.ensureResolvedType(scope, this.m_astNode.type))) != null) {
            result.add(t);
        }
        if (hasBounds) {
            TypeReference[] typeReferenceArray = this.m_astNode.bounds;
            int n = this.m_astNode.bounds.length;
            int n2 = 0;
            while (n2 < n) {
                TypeReference r = typeReferenceArray[n2];
                TypeSpi t2 = SpiWithJdtUtils.bindingToType(this.m_env, this.ensureResolvedType(scope, r));
                if (t2 != null) {
                    result.add(t2);
                }
                ++n2;
            }
        }
        this.m_bounds = Collections.unmodifiableList(result);
        return this.m_bounds;
    }

    protected TypeBinding ensureResolvedType(Scope scope, TypeReference r) {
        TypeBinding resolvedType = r.resolvedType;
        if (resolvedType != null) {
            return resolvedType;
        }
        if (scope instanceof ClassScope) {
            r.resolveType((ClassScope)scope);
        } else {
            r.resolveType((BlockScope)scope);
        }
        return r.resolvedType;
    }

    @Override
    public AbstractMemberWithJdt<?> getDeclaringMember() {
        return this.m_declaringMember;
    }

    @Override
    public String getElementName() {
        return this.m_name;
    }

    @Override
    public ISourceRange getSource() {
        if (this.m_source == null) {
            CompilationUnitSpi cu = SpiWithJdtUtils.declaringTypeOf(this).getCompilationUnit();
            TypeParameter decl = this.m_astNode;
            this.m_source = this.m_env.getSource(cu, decl.declarationSourceStart, decl.declarationSourceEnd);
        }
        return this.m_source;
    }
}

