/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.model.sugar;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import org.eclipse.scout.sdk.core.model.api.IMethodParameter;
import org.eclipse.scout.sdk.core.model.spi.MethodParameterSpi;
import org.eclipse.scout.sdk.core.model.spi.MethodSpi;

public class MethodParameterQuery {
    private final MethodSpi m_method;
    private String m_name;
    private String m_dataTypeFqn;
    private Predicate<IMethodParameter> m_filter;
    private int m_maxResultCount = Integer.MAX_VALUE;

    public MethodParameterQuery(MethodSpi method) {
        this.m_method = method;
    }

    public MethodParameterQuery withName(String name) {
        this.m_name = name;
        return this;
    }

    public MethodParameterQuery withDataType(String dataTypeFqn) {
        this.m_dataTypeFqn = dataTypeFqn;
        return this;
    }

    public MethodParameterQuery withFilter(Predicate<IMethodParameter> filter) {
        this.m_filter = filter;
        return this;
    }

    public MethodParameterQuery withMaxResultCount(int maxResultCount) {
        this.m_maxResultCount = maxResultCount;
        return this;
    }

    protected boolean accept(IMethodParameter p) {
        if (this.m_name != null && !this.m_name.equals(p.elementName())) {
            return false;
        }
        if (this.m_filter != null && !this.m_filter.test(p)) {
            return false;
        }
        return this.m_dataTypeFqn == null || this.m_dataTypeFqn.equals(p.dataType().name());
    }

    protected void visit(MethodSpi m, List<IMethodParameter> result, int maxCount) {
        for (MethodParameterSpi spi : m.getParameters()) {
            IMethodParameter p = spi.wrap();
            if (!this.accept(p)) continue;
            result.add(p);
            if (result.size() < maxCount) continue;
            return;
        }
    }

    public boolean existsAny() {
        return this.first() != null;
    }

    public IMethodParameter first() {
        ArrayList<IMethodParameter> result = new ArrayList<IMethodParameter>(1);
        this.visit(this.m_method, result, 1);
        return result.isEmpty() ? null : (IMethodParameter)result.get(0);
    }

    public List<IMethodParameter> list() {
        ArrayList<IMethodParameter> result = new ArrayList<IMethodParameter>(this.m_method.getParameters().size());
        this.visit(this.m_method, result, this.m_maxResultCount);
        return result;
    }
}

