/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.sourcebuilder.comment;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.regex.Pattern;
import org.eclipse.scout.sdk.core.importvalidator.IImportValidator;
import org.eclipse.scout.sdk.core.sourcebuilder.ISourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.comment.ICommentSourceBuilderSpi;
import org.eclipse.scout.sdk.core.sourcebuilder.compilationunit.ICompilationUnitSourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.field.IFieldSourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.method.IMethodSourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.type.ITypeSourceBuilder;
import org.eclipse.scout.sdk.core.util.PropertyMap;
import org.eclipse.scout.sdk.core.util.SdkException;

public final class CommentSourceBuilderFactory {
    private static volatile ICommentSourceBuilderSpi commentSourceBuilderSpi;
    private static final Pattern REGEX_COMMENT_PATTERN1;
    private static final Pattern REGEX_COMMENT_PATTERN2;
    private static final Pattern REGEX_COMMENT_PATTERN3;
    private static final ISourceBuilder EMPTY_COMMENT_SOURCE_BUILDER;

    static {
        REGEX_COMMENT_PATTERN1 = Pattern.compile("^s*\\/\\*\\*s*$");
        REGEX_COMMENT_PATTERN2 = Pattern.compile("^s*\\*\\*\\/s*$");
        REGEX_COMMENT_PATTERN3 = Pattern.compile("^s*\\*.*$");
        EMPTY_COMMENT_SOURCE_BUILDER = new ISourceBuilder(){

            @Override
            public void createSource(StringBuilder source, String lineDelimiter, PropertyMap context, IImportValidator validator) {
            }
        };
    }

    private CommentSourceBuilderFactory() {
    }

    public static ISourceBuilder createDefaultCompilationUnitComment(ICompilationUnitSourceBuilder target) {
        if (CommentSourceBuilderFactory.getCommentSourceBuilderSpi() != null) {
            return CommentSourceBuilderFactory.getCommentSourceBuilderSpi().createCompilationUnitComment(target);
        }
        return EMPTY_COMMENT_SOURCE_BUILDER;
    }

    public static ISourceBuilder createDefaultTypeComment(ITypeSourceBuilder target) {
        if (CommentSourceBuilderFactory.getCommentSourceBuilderSpi() != null) {
            return CommentSourceBuilderFactory.getCommentSourceBuilderSpi().createTypeComment(target);
        }
        return EMPTY_COMMENT_SOURCE_BUILDER;
    }

    public static ISourceBuilder createDefaultMethodComment(IMethodSourceBuilder target) {
        if (CommentSourceBuilderFactory.getCommentSourceBuilderSpi() != null) {
            return CommentSourceBuilderFactory.getCommentSourceBuilderSpi().createMethodComment(target);
        }
        return EMPTY_COMMENT_SOURCE_BUILDER;
    }

    public static ISourceBuilder createDefaultOverrideMethodComment(IMethodSourceBuilder target, String interfaceFqn) {
        if (CommentSourceBuilderFactory.getCommentSourceBuilderSpi() != null) {
            return CommentSourceBuilderFactory.getCommentSourceBuilderSpi().createOverrideMethodComment(target, interfaceFqn);
        }
        return EMPTY_COMMENT_SOURCE_BUILDER;
    }

    public static ISourceBuilder createDefaultGetterMethodComment(IMethodSourceBuilder target) {
        if (CommentSourceBuilderFactory.getCommentSourceBuilderSpi() != null) {
            return CommentSourceBuilderFactory.getCommentSourceBuilderSpi().createGetterMethodComment(target);
        }
        return EMPTY_COMMENT_SOURCE_BUILDER;
    }

    public static ISourceBuilder createDefaultSetterMethodComment(IMethodSourceBuilder target) {
        if (CommentSourceBuilderFactory.getCommentSourceBuilderSpi() != null) {
            return CommentSourceBuilderFactory.getCommentSourceBuilderSpi().createSetterMethodComment(target);
        }
        return EMPTY_COMMENT_SOURCE_BUILDER;
    }

    public static ISourceBuilder createDefaultFieldComment(IFieldSourceBuilder target) {
        if (CommentSourceBuilderFactory.getCommentSourceBuilderSpi() != null) {
            return CommentSourceBuilderFactory.getCommentSourceBuilderSpi().createFieldComment(target);
        }
        return EMPTY_COMMENT_SOURCE_BUILDER;
    }

    public static ISourceBuilder createCustomCommentBuilder(final String comment) {
        return new ISourceBuilder(){

            @Override
            public void createSource(StringBuilder source, String lineDelimiter, PropertyMap context, IImportValidator validator) {
                StringBuilder commentBuilder = new StringBuilder();
                try {
                    Throwable throwable = null;
                    Object var7_9 = null;
                    try (BufferedReader inputReader = new BufferedReader(new StringReader(comment));){
                        commentBuilder.append("/**").append(lineDelimiter);
                        String line = inputReader.readLine();
                        while (line != null) {
                            if (REGEX_COMMENT_PATTERN1.matcher(line).matches() || REGEX_COMMENT_PATTERN2.matcher(line).matches()) {
                                line = inputReader.readLine();
                                continue;
                            }
                            if (REGEX_COMMENT_PATTERN3.matcher(line).matches()) {
                                commentBuilder.append(line);
                            } else {
                                commentBuilder.append("* ").append(line);
                            }
                            commentBuilder.append(lineDelimiter);
                            line = inputReader.readLine();
                        }
                        commentBuilder.append("*/");
                        String formattedComment = commentBuilder.toString();
                        source.append(formattedComment);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException e) {
                    throw new SdkException("Unable to format comment.", e);
                }
            }
        };
    }

    public static ICommentSourceBuilderSpi getCommentSourceBuilderSpi() {
        return commentSourceBuilderSpi;
    }

    public static void setCommentSourceBuilderSpi(ICommentSourceBuilderSpi commentSourceBuilderSpi) {
        CommentSourceBuilderFactory.commentSourceBuilderSpi = commentSourceBuilderSpi;
    }
}

