/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.sourcebuilder.field;

import org.apache.commons.lang3.StringUtils;
import org.eclipse.scout.sdk.core.importvalidator.IImportValidator;
import org.eclipse.scout.sdk.core.model.api.Flags;
import org.eclipse.scout.sdk.core.model.api.IField;
import org.eclipse.scout.sdk.core.signature.SignatureUtils;
import org.eclipse.scout.sdk.core.sourcebuilder.AbstractMemberSourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.ExpressionSourceBuilderFactory;
import org.eclipse.scout.sdk.core.sourcebuilder.ISourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.RawSourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.field.IFieldSourceBuilder;
import org.eclipse.scout.sdk.core.util.PropertyMap;

public class FieldSourceBuilder
extends AbstractMemberSourceBuilder
implements IFieldSourceBuilder {
    private String m_signature;
    private ISourceBuilder m_value;

    public FieldSourceBuilder(IField element) {
        super(element);
        this.setSignature(SignatureUtils.getTypeSignature(element.dataType()));
        if (element.sourceOfInitializer().isAvailable()) {
            this.setValue(new RawSourceBuilder(element.sourceOfInitializer().toString()));
        } else if (element.constantValue() != null) {
            this.setValue(ExpressionSourceBuilderFactory.createFromMetaValue(element.constantValue()));
        }
    }

    public FieldSourceBuilder(String elementName) {
        super(elementName);
    }

    @Override
    public void createSource(StringBuilder source, String lineDelimiter, PropertyMap context, IImportValidator validator) {
        super.createSource(source, lineDelimiter, context, validator);
        if (!this.getElementName().isEmpty() && StringUtils.isEmpty((CharSequence)this.getSignature())) {
            throw new IllegalArgumentException("signature is null!");
        }
        if (this.getElementName().isEmpty()) {
            this.getValue().createSource(source, lineDelimiter, context, validator);
            return;
        }
        source.append(Flags.toString(this.getFlags()));
        if (this.getFlags() != 0) {
            source.append(' ');
        }
        source.append(validator.useSignature(this.getSignature())).append(' ');
        source.append(this.getElementName());
        if (this.getValue() != null) {
            source.append(" = ");
            this.getValue().createSource(source, lineDelimiter, context, validator);
        }
        source.append(';');
    }

    @Override
    public void setSignature(String signature) {
        this.m_signature = signature;
    }

    @Override
    public String getSignature() {
        return this.m_signature;
    }

    @Override
    public void setValue(ISourceBuilder value) {
        this.m_value = value;
    }

    @Override
    public ISourceBuilder getValue() {
        return this.m_value;
    }
}

