/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.sourcebuilder.resource;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.scout.sdk.core.sourcebuilder.resource.IResourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.resource.IResourceFragmentBuilder;
import org.eclipse.scout.sdk.core.util.PropertyMap;

public class ResourceBuilder
implements IResourceBuilder {
    private final String m_packageName;
    private final String m_fileName;
    private final List<IResourceFragmentBuilder> m_fragments = new ArrayList<IResourceFragmentBuilder>();
    private final List<IResourceFragmentBuilder> m_footerSourceBuilders = new ArrayList<IResourceFragmentBuilder>();

    public ResourceBuilder(String packageName, String fileName) {
        this.m_packageName = packageName;
        this.m_fileName = fileName;
    }

    @Override
    public void createResource(StringBuilder source, String lineDelimiter, PropertyMap context) {
        for (IResourceFragmentBuilder builder : this.m_fragments) {
            if (builder == null) continue;
            builder.createResource(source, lineDelimiter, context);
        }
        for (IResourceFragmentBuilder f : this.m_footerSourceBuilders) {
            f.createResource(source, lineDelimiter, context);
        }
    }

    @Override
    public String getPackageName() {
        return this.m_packageName;
    }

    @Override
    public String getFileName() {
        return this.m_fileName;
    }

    @Override
    public void addFragment(IResourceFragmentBuilder fragment) {
        this.m_fragments.add(fragment);
    }

    @Override
    public List<IResourceFragmentBuilder> getFragments() {
        return Collections.unmodifiableList(this.m_fragments);
    }

    @Override
    public void addFooter(IResourceFragmentBuilder footerSourceBuilder) {
        this.m_footerSourceBuilders.add(footerSourceBuilder);
    }

    @Override
    public List<IResourceFragmentBuilder> getFooters() {
        return Collections.unmodifiableList(this.m_footerSourceBuilders);
    }
}

