/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.util;

import java.io.PrintStream;
import java.util.logging.Level;
import org.apache.commons.lang3.StringUtils;

public final class SdkConsole {
    private static ISdkConsoleSpi spi = new P_DefaultConsoleSpi();

    public static synchronized ISdkConsoleSpi getConsoleSpi() {
        return spi;
    }

    public static synchronized void setConsoleSpi(ISdkConsoleSpi newSpi) {
        if (newSpi == null) {
            newSpi = new P_DefaultConsoleSpi();
        }
        spi = newSpi;
    }

    public static synchronized void clear() {
        spi.clear();
    }

    static synchronized void println(Level level, String msg, Throwable ... exceptions) {
        spi.println(level, msg, exceptions);
    }

    private SdkConsole() {
    }

    public static interface ISdkConsoleSpi {
        public void clear();

        public void println(Level var1, String var2, Throwable ... var3);
    }

    private static final class P_DefaultConsoleSpi
    implements ISdkConsoleSpi {
        private static final PrintStream OUT = System.out;
        private static final PrintStream ERR = System.err;

        private P_DefaultConsoleSpi() {
        }

        @Override
        public void clear() {
            OUT.println(StringUtils.leftPad((String)"", (int)50, (char)'_'));
        }

        @Override
        public void println(Level level, String s, Throwable ... exceptions) {
            PrintStream out = null;
            out = Level.SEVERE.equals(level) ? ERR : OUT;
            if (s != null) {
                out.println(s);
            }
            if (exceptions == null || exceptions.length < 1) {
                return;
            }
            Throwable[] throwableArray = exceptions;
            int n = exceptions.length;
            int n2 = 0;
            while (n2 < n) {
                Throwable t = throwableArray[n2];
                if (t != null) {
                    t.printStackTrace(out);
                }
                ++n2;
            }
        }
    }
}

