/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.web.project.facet;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.internal.resources.ResourceStatus;
import org.eclipse.core.internal.utils.Messages;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jst.common.project.facet.core.JavaFacet;
import org.eclipse.jst.j2ee.internal.common.J2EEVersionUtil;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPlugin;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.jst.j2ee.internal.web.plugin.WebPlugin;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;
import org.eclipse.jst.j2ee.project.facet.IJ2EEFacetConstants;
import org.eclipse.jst.j2ee.project.facet.J2EEModuleFacetInstallDataModelProvider;
import org.eclipse.jst.j2ee.web.project.facet.IWebFragmentFacetInstallDataModelProperties;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.ModuleCoreNature;
import org.eclipse.wst.common.componentcore.datamodel.properties.IFacetProjectCreationDataModelProperties;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.frameworks.datamodel.DataModelPropertyDescriptor;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectWorkingCopy;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebFragmentFacetInstallDataModelProvider
extends J2EEModuleFacetInstallDataModelProvider
implements IWebFragmentFacetInstallDataModelProperties {
    public Set<String> getPropertyNames() {
        Set names = super.getPropertyNames();
        names.add("IWebFragmentFacetInstallDataModelProperties.CONTENT_DIR");
        names.add("IWebFragmentFacetInstallDataModelProperties.ADD_TO_WAR");
        names.add("IWebFragmentFacetInstallDataModelProperties.WAR_PROJECT_NAME");
        names.add("IWebFragmentFacetInstallDataModelProperties.LAST_WAR_NAME");
        return names;
    }

    public Object getDefaultProperty(String propertyName) {
        if (propertyName.equals("IWebFragmentFacetInstallDataModelProperties.CONTENT_DIR")) {
            return "";
        }
        if (propertyName.equals("IFacetDataModelProperties.FACET_ID")) {
            return "jst.webfragment";
        }
        if (propertyName.equals("IJ2EEFacetInstallDataModelProperties.ADD_TO_EAR")) {
            return false;
        }
        if (propertyName.equals("IWebFragmentFacetInstallDataModelProperties.ADD_TO_WAR")) {
            return true;
        }
        if (propertyName.equals("IJ2EEModuleFacetInstallDataModelProperties.MODULE_URI")) {
            String projectName = this.model.getStringProperty("IFacetDataModelProperties.FACET_PROJECT_NAME").replace(' ', '_');
            return String.valueOf(projectName) + ".jar";
        }
        if (propertyName.equals("IWebFragmentFacetInstallDataModelProperties.ADD_TO_WAR")) {
            return new Boolean(J2EEPlugin.getDefault().getJ2EEPreferences().getBoolean("addToEarByDefault") && this.isWARSupportedByRuntime());
        }
        if (propertyName.equals("IWebFragmentFacetInstallDataModelProperties.WAR_PROJECT_NAME")) {
            IProject project;
            if (this.model.isPropertySet("IWebFragmentFacetInstallDataModelProperties.LAST_WAR_NAME") && (project = ProjectUtilities.getProject((String)this.getStringProperty("IWebFragmentFacetInstallDataModelProperties.LAST_WAR_NAME"))).exists() && project.isAccessible()) {
                return project.getName();
            }
            DataModelPropertyDescriptor[] descs = this.getValidPropertyDescriptors("IWebFragmentFacetInstallDataModelProperties.WAR_PROJECT_NAME");
            if (descs.length > 0) {
                DataModelPropertyDescriptor desc = descs[0];
                String eARName = desc.getPropertyDescription();
                if (eARName != null && !eARName.equals("")) {
                    return eARName;
                }
                return String.valueOf(this.getDataModel().getStringProperty("IFacetDataModelProperties.FACET_PROJECT_NAME")) + "WAR";
            }
            return String.valueOf(this.getDataModel().getStringProperty("IFacetDataModelProperties.FACET_PROJECT_NAME")) + "WAR";
        }
        if (propertyName.equals("IJ2EEFacetInstallDataModelProperties.CONFIG_FOLDER")) {
            IFacetedProjectWorkingCopy localFpjwc = (IFacetedProjectWorkingCopy)this.getProperty("IFacetDataModelProperties.FACETED_PROJECT_WORKING_COPY");
            if (this.javaFacetInstallConfig != null) {
                List sourceFolders = this.javaFacetInstallConfig.getSourceFolders();
                if (!sourceFolders.isEmpty()) {
                    return ((IPath)sourceFolders.get(0)).toPortableString();
                }
            } else {
                IFacetedProject fpj = localFpjwc.getFacetedProject();
                if (fpj.hasProjectFacet(JavaFacet.FACET)) {
                    try {
                        IJavaProject jpj = JavaCore.create((IProject)fpj.getProject());
                        IClasspathEntry[] iClasspathEntryArray = jpj.getRawClasspath();
                        int n = iClasspathEntryArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IClasspathEntry cpe = iClasspathEntryArray[n2];
                            if (cpe.getEntryKind() == 3) {
                                return cpe.getPath().removeFirstSegments(1).toPortableString();
                            }
                            ++n2;
                        }
                    }
                    catch (CoreException e) {
                        WebPlugin.logError(e);
                    }
                }
            }
        }
        return super.getDefaultProperty(propertyName);
    }

    public IStatus validate(String name) {
        if (name.equals("IWebFragmentFacetInstallDataModelProperties.CONTENT_DIR")) {
            String folderName = this.model.getStringProperty("IWebFragmentFacetInstallDataModelProperties.CONTENT_DIR");
            IStatus status = this.validateFolderName(folderName);
            if (status.isOK() && folderName.indexOf(35) != -1) {
                String message = NLS.bind((String)Messages.resources_invalidCharInName, (Object)"#", (Object)folderName);
                status = new ResourceStatus(77, null, message);
            }
            return status;
        }
        return super.validate(name);
    }

    protected IStatus validateFolderName(String folderName) {
        if (folderName == null || folderName.length() == 0) {
            return OK_STATUS;
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        Path path = new Path(folderName);
        int i = 0;
        int max = path.segmentCount();
        while (i < max) {
            IStatus status = workspace.validateName(path.segment(i), 2);
            if (!status.isOK()) {
                return status;
            }
            ++i;
        }
        return OK_STATUS;
    }

    private boolean isWARSupportedByRuntime() {
        boolean ret = true;
        IRuntime rt = (IRuntime)this.model.getProperty("IFacetProjectCreationDataModelProperties.FACET_RUNTIME");
        if (rt != null) {
            ret = rt.supports(IJ2EEFacetConstants.DYNAMIC_WEB_FACET);
        }
        return ret;
    }

    public DataModelPropertyDescriptor[] getValidPropertyDescriptors(String propertyName) {
        if ("IWebFragmentFacetInstallDataModelProperties.WAR_PROJECT_NAME".equals(propertyName)) {
            int j2eeVersion = J2EEVersionUtil.convertVersionStringToInt((String)((IProjectFacetVersion)this.getProperty("IFacetDataModelPropeties.FACET_VERSION")).getVersionString());
            return this.getWebAppPropertyDescriptors(j2eeVersion);
        }
        return super.getValidPropertyDescriptors(propertyName);
    }

    public boolean propertySet(String propertyName, Object propertyValue) {
        if ("IFacetDataModelProperties.FACET_PROJECT_NAME".equals(propertyName)) {
            if (this.getBooleanProperty("IWebFragmentFacetInstallDataModelProperties.ADD_TO_WAR") && !this.model.isPropertySet("IWebFragmentFacetInstallDataModelProperties.WAR_PROJECT_NAME")) {
                this.model.notifyPropertyChange("IWebFragmentFacetInstallDataModelProperties.WAR_PROJECT_NAME", 2);
            }
        } else if ("IFacetDataModelPropeties.FACET_VERSION".equals(propertyName)) {
            this.model.notifyPropertyChange("IWebFragmentFacetInstallDataModelProperties.WAR_PROJECT_NAME", 4);
        } else if (propertyName.equals("IJ2EEFacetInstallDataModelProperties.CONFIG_FOLDER")) {
            IFacetProjectCreationDataModelProperties.FacetDataModelMap map;
            IDataModel javaModel;
            IDataModel masterModel = (IDataModel)this.model.getProperty("FacetInstallDataModelProvider.MASTER_PROJECT_DM");
            if (masterModel != null && (javaModel = (map = (IFacetProjectCreationDataModelProperties.FacetDataModelMap)masterModel.getProperty("IFacetProjectCreationDataModelProperties.FACET_DM_MAP")).getFacetDataModel("jst.java")) != null) {
                javaModel.setProperty("IJavaFacetInstallDataModelProperties.SOURCE_FOLDER_NAME", propertyValue);
            }
        } else if (("IWebFragmentFacetInstallDataModelProperties.WAR_PROJECT_NAME".equals(propertyName) || "IWebFragmentFacetInstallDataModelProperties.ADD_TO_WAR".equals(propertyName) || "IWebFragmentFacetInstallDataModelProperties.LAST_WAR_NAME".equals(propertyName)) && this.getBooleanProperty("IWebFragmentFacetInstallDataModelProperties.ADD_TO_WAR")) {
            IProject project;
            IStatus status = this.validateEAR(this.model.getStringProperty("IWebFragmentFacetInstallDataModelProperties.WAR_PROJECT_NAME"));
            if (status.isOK() && (project = ProjectUtilities.getProject((String)this.getStringProperty("IWebFragmentFacetInstallDataModelProperties.WAR_PROJECT_NAME"))).exists() && project.isAccessible() && JavaEEProjectUtilities.isDynamicWebProject((IProject)project)) {
                try {
                    IFacetedProject facetProj = ProjectFacetsManager.create((IProject)project, (boolean)false, (IProgressMonitor)new NullProgressMonitor());
                    this.setProperty("IFacetProjectCreationDataModelProperties.FACET_RUNTIME", facetProj.getRuntime());
                }
                catch (CoreException e) {
                    WebPlugin.logError(e);
                }
            }
            this.model.notifyPropertyChange("IFacetProjectCreationDataModelProperties.FACET_RUNTIME", 3);
        } else if (propertyName.equals("IFacetProjectCreationDataModelProperties.FACET_RUNTIME")) {
            this.model.notifyPropertyChange("IWebFragmentFacetInstallDataModelProperties.ADD_TO_WAR", 4);
            this.model.notifyPropertyChange("IWebFragmentFacetInstallDataModelProperties.WAR_PROJECT_NAME", 4);
        }
        if ("IWebFragmentFacetInstallDataModelProperties.ADD_TO_WAR".equals(propertyName)) {
            IStatus stat = this.model.validateProperty(propertyName);
            if (stat != OK_STATUS) {
                return true;
            }
            this.model.notifyPropertyChange("IWebFragmentFacetInstallDataModelProperties.WAR_PROJECT_NAME", 4);
        }
        return super.propertySet(propertyName, propertyValue);
    }

    private DataModelPropertyDescriptor[] getWebAppPropertyDescriptors(int webAppVersion) {
        ArrayList<DataModelPropertyDescriptor> webAppDescriptorList = new ArrayList<DataModelPropertyDescriptor>();
        IProject[] projs = ProjectUtilities.getAllProjects();
        int index = 0;
        while (index < projs.length) {
            String sVer;
            int ver;
            IVirtualComponent comp;
            IProject flexProject = projs[index];
            if (flexProject != null && ModuleCoreNature.isFlexibleProject((IProject)flexProject) && JavaEEProjectUtilities.isDynamicWebProject((IProject)(comp = ComponentCore.createComponent((IProject)flexProject)).getProject()) && webAppVersion <= (ver = J2EEVersionUtil.convertVersionStringToInt((String)(sVer = J2EEProjectUtilities.getJ2EEProjectVersion((IProject)comp.getProject()))))) {
                DataModelPropertyDescriptor desc = new DataModelPropertyDescriptor((Object)comp.getProject().getName());
                webAppDescriptorList.add(desc);
            }
            ++index;
        }
        DataModelPropertyDescriptor[] descriptors = new DataModelPropertyDescriptor[webAppDescriptorList.size()];
        int i = 0;
        while (i < descriptors.length) {
            DataModelPropertyDescriptor desc = (DataModelPropertyDescriptor)webAppDescriptorList.get(i);
            descriptors[i] = new DataModelPropertyDescriptor((Object)desc.getPropertyDescription(), desc.getPropertyDescription());
            ++i;
        }
        return descriptors;
    }

    public boolean isPropertyEnabled(String propertyName) {
        if ("IWebFragmentFacetInstallDataModelProperties.ADD_TO_WAR".equals(propertyName)) {
            return this.isWARSupportedByRuntime();
        }
        if ("IWebFragmentFacetInstallDataModelProperties.WAR_PROJECT_NAME".equals(propertyName)) {
            return this.isWARSupportedByRuntime() && this.getBooleanProperty("IWebFragmentFacetInstallDataModelProperties.ADD_TO_WAR");
        }
        return super.isPropertyEnabled(propertyName);
    }
}

