/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.model.spi.internal;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.Compiler;
import org.eclipse.jdt.internal.compiler.DefaultErrorHandlingPolicies;
import org.eclipse.jdt.internal.compiler.ICompilerRequestor;
import org.eclipse.jdt.internal.compiler.IProblemFactory;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblem;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblemFactory;

public class AstCompiler
extends Compiler {
    static final CompilerOptions opts = new CompilerOptions();
    static final Map<String, String> optsMap;
    private final Map<CompilationUnitDeclaration, ICompilationUnit> m_sources = new HashMap<CompilationUnitDeclaration, ICompilationUnit>();

    static {
        AstCompiler.opts.produceDebugAttributes = 0;
        AstCompiler.opts.originalComplianceLevel = AstCompiler.opts.complianceLevel = 0x350000L;
        AstCompiler.opts.sourceLevel = AstCompiler.opts.complianceLevel;
        AstCompiler.opts.originalSourceLevel = AstCompiler.opts.complianceLevel;
        AstCompiler.opts.targetJDK = AstCompiler.opts.complianceLevel;
        AstCompiler.opts.verbose = false;
        AstCompiler.opts.preserveAllLocalVariables = true;
        AstCompiler.opts.parseLiteralExpressionsAsConstants = false;
        AstCompiler.opts.reportUnusedParameterIncludeDocCommentReference = false;
        AstCompiler.opts.reportUnusedDeclaredThrownExceptionExemptExceptionAndThrowable = false;
        AstCompiler.opts.suppressOptionalErrors = true;
        AstCompiler.opts.performMethodsFullRecovery = false;
        AstCompiler.opts.performStatementsRecovery = true;
        AstCompiler.opts.generateClassFiles = false;
        AstCompiler.opts.reportMissingOverrideAnnotationForInterfaceMethodImplementation = false;
        AstCompiler.opts.ignoreSourceFolderWarningOption = true;
        AstCompiler.opts.analyseResourceLeaks = false;
        AstCompiler.opts.ignoreMethodBodies = true;
        AstCompiler.opts.docCommentSupport = true;
        AstCompiler.opts.isAnnotationBasedNullAnalysisEnabled = false;
        AstCompiler.opts.storeAnnotations = true;
        optsMap = opts.getMap();
    }

    public AstCompiler(INameEnvironment nameEnv) {
        super(nameEnv, DefaultErrorHandlingPolicies.proceedWithAllProblems(), opts, (ICompilerRequestor)new P_EmptyCompilerRequestor(), (IProblemFactory)new CollectingProblemFactory(), (PrintWriter)new P_EmptyPrintWriter(), null);
        this.lookupEnvironment.completeTypeBindings();
    }

    protected synchronized void addCompilationUnit(ICompilationUnit sourceUnit, CompilationUnitDeclaration parsedUnit) {
        super.addCompilationUnit(sourceUnit, parsedUnit);
        this.m_sources.put(parsedUnit, sourceUnit);
    }

    public ICompilationUnit getSource(CompilationUnitDeclaration decl) {
        return this.m_sources.get(decl);
    }

    public synchronized String getCompileErrors(CompilationUnitDeclaration unit) {
        this.process(unit, 0);
        CategorizedProblem[] errors = unit.compilationResult().getErrors();
        if (errors != null && errors.length > 0) {
            StringBuilder sb = new StringBuilder();
            CategorizedProblem[] categorizedProblemArray = errors;
            int n = errors.length;
            int n2 = 0;
            while (n2 < n) {
                CategorizedProblem p = categorizedProblemArray[n2];
                sb.append(p.getMessage()).append('\n');
                ++n2;
            }
            sb.setLength(sb.length() - 1);
            return sb.toString();
        }
        return null;
    }

    private static final class CollectingProblemFactory
    extends DefaultProblemFactory {
        CollectingProblemFactory() {
        }

        public CategorizedProblem createProblem(char[] originatingFileName, int problemId, String[] problemArguments, String[] messageArguments, int severity, int startPosition, int endPosition, int lineNumber, int columnNumber) {
            return this.createProblem(originatingFileName, problemId, problemArguments, 0, messageArguments, severity, startPosition, endPosition, lineNumber, columnNumber);
        }

        public CategorizedProblem createProblem(char[] originatingFileName, int problemId, String[] problemArguments, int elaborationId, String[] messageArguments, int severity, int startPosition, int endPosition, int lineNumber, int columnNumber) {
            if ((severity & 0x281) != 0) {
                String txt;
                StringBuilder msg = new StringBuilder();
                if (originatingFileName != null) {
                    msg.append(originatingFileName).append(':');
                }
                if (lineNumber > 0) {
                    msg.append(lineNumber);
                }
                if (msg.length() > 0) {
                    msg.append(' ');
                }
                if ((txt = this.getLocalizedMessage(problemId, elaborationId, messageArguments)) != null) {
                    msg.append(txt);
                }
                return new DefaultProblem(originatingFileName, msg.toString(), problemId, problemArguments, severity, startPosition, endPosition, lineNumber, columnNumber);
            }
            return null;
        }
    }

    private static final class P_EmptyCompilerRequestor
    implements ICompilerRequestor {
        private P_EmptyCompilerRequestor() {
        }

        public void acceptResult(CompilationResult result) {
        }
    }

    private static final class P_EmptyPrintWriter
    extends PrintWriter {
        private P_EmptyPrintWriter() {
            super(new P_EmptyWriter());
        }
    }

    private static final class P_EmptyWriter
    extends Writer {
        private P_EmptyWriter() {
        }

        @Override
        public void write(char[] cbuf, int off, int len) throws IOException {
        }

        @Override
        public void flush() throws IOException {
        }

        @Override
        public void close() throws IOException {
        }
    }
}

