/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.model.spi.internal;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang3.Validate;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.lookup.AnnotationBinding;
import org.eclipse.jdt.internal.compiler.lookup.ElementValuePair;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.scout.sdk.core.model.api.IAnnotation;
import org.eclipse.scout.sdk.core.model.api.ISourceRange;
import org.eclipse.scout.sdk.core.model.api.internal.AnnotationImplementor;
import org.eclipse.scout.sdk.core.model.spi.AnnotatableSpi;
import org.eclipse.scout.sdk.core.model.spi.AnnotationElementSpi;
import org.eclipse.scout.sdk.core.model.spi.AnnotationSpi;
import org.eclipse.scout.sdk.core.model.spi.CompilationUnitSpi;
import org.eclipse.scout.sdk.core.model.spi.JavaElementSpi;
import org.eclipse.scout.sdk.core.model.spi.TypeSpi;
import org.eclipse.scout.sdk.core.model.spi.internal.AbstractJavaElementWithJdt;
import org.eclipse.scout.sdk.core.model.spi.internal.BindingAnnotationElementWithJdt;
import org.eclipse.scout.sdk.core.model.spi.internal.JavaEnvironmentWithJdt;
import org.eclipse.scout.sdk.core.model.spi.internal.SpiWithJdtUtils;

public class BindingAnnotationWithJdt
extends AbstractJavaElementWithJdt<IAnnotation>
implements AnnotationSpi {
    private final AnnotatableSpi m_owner;
    private final AnnotationBinding m_binding;
    private Map<String, AnnotationElementSpi> m_values;
    private TypeSpi m_type;
    private ISourceRange m_source;

    BindingAnnotationWithJdt(JavaEnvironmentWithJdt env, AnnotatableSpi owner, AnnotationBinding binding) {
        super(env);
        this.m_binding = (AnnotationBinding)Validate.notNull((Object)binding);
        this.m_owner = (AnnotatableSpi)Validate.notNull((Object)owner);
    }

    @Override
    protected JavaElementSpi internalFindNewElement(JavaEnvironmentWithJdt newEnv) {
        return null;
    }

    @Override
    protected IAnnotation internalCreateApi() {
        return new AnnotationImplementor(this);
    }

    public AnnotationBinding getInternalBinding() {
        return this.m_binding;
    }

    @Override
    public TypeSpi getType() {
        if (this.m_type == null) {
            this.m_type = SpiWithJdtUtils.bindingToType(this.m_env, (TypeBinding)this.m_binding.getAnnotationType());
        }
        return this.m_type;
    }

    @Override
    public Map<String, AnnotationElementSpi> getValues() {
        if (this.m_values != null) {
            return this.m_values;
        }
        Map<String, ElementValuePair> defaultsMap = SpiWithJdtUtils.getBindingAnnotationSyntheticDefaultValues(this.m_env, this.m_binding.getAnnotationType());
        LinkedHashMap<String, BindingAnnotationElementWithJdt> result = new LinkedHashMap<String, BindingAnnotationElementWithJdt>(defaultsMap.size());
        for (String name : defaultsMap.keySet()) {
            result.put(name, null);
        }
        ElementValuePair[] bindingPairs = this.m_binding.getElementValuePairs();
        if (bindingPairs != null && bindingPairs.length > 0) {
            ElementValuePair[] elementValuePairArray = bindingPairs;
            int n = bindingPairs.length;
            int n2 = 0;
            while (n2 < n) {
                ElementValuePair bindingPair = elementValuePairArray[n2];
                BindingAnnotationElementWithJdt v = this.m_env.createBindingAnnotationValue(this, bindingPair, false);
                result.put(v.getElementName(), v);
                ++n2;
            }
        }
        for (Map.Entry<String, ElementValuePair> e : defaultsMap.entrySet()) {
            if (result.get(e.getKey()) != null || e.getValue() == null) continue;
            result.put(e.getKey(), this.m_env.createBindingAnnotationValue(this, e.getValue(), true));
        }
        this.m_values = Collections.unmodifiableMap(result);
        return this.m_values;
    }

    @Override
    public AnnotationElementSpi getValue(String name) {
        return this.getValues().get(name);
    }

    @Override
    public AnnotatableSpi getOwner() {
        return this.m_owner;
    }

    @Override
    public String getElementName() {
        return this.getType().getElementName();
    }

    @Override
    public ISourceRange getSource() {
        if (this.m_source == null) {
            CompilationUnitSpi cu = SpiWithJdtUtils.declaringTypeOf(this).getCompilationUnit();
            Annotation decl = SpiWithJdtUtils.findAnnotationDeclaration(this);
            this.m_source = decl != null ? this.m_env.getSource(cu, decl.sourceStart, decl.declarationSourceEnd) : ISourceRange.NO_SOURCE;
        }
        return this.m_source;
    }
}

