/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.model.spi.internal;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.Validate;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Javadoc;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.scout.sdk.core.model.api.IField;
import org.eclipse.scout.sdk.core.model.api.IMetaValue;
import org.eclipse.scout.sdk.core.model.api.ISourceRange;
import org.eclipse.scout.sdk.core.model.api.internal.FieldImplementor;
import org.eclipse.scout.sdk.core.model.spi.CompilationUnitSpi;
import org.eclipse.scout.sdk.core.model.spi.FieldSpi;
import org.eclipse.scout.sdk.core.model.spi.JavaElementSpi;
import org.eclipse.scout.sdk.core.model.spi.TypeParameterSpi;
import org.eclipse.scout.sdk.core.model.spi.TypeSpi;
import org.eclipse.scout.sdk.core.model.spi.internal.AbstractMemberWithJdt;
import org.eclipse.scout.sdk.core.model.spi.internal.AbstractTypeWithJdt;
import org.eclipse.scout.sdk.core.model.spi.internal.BindingAnnotationWithJdt;
import org.eclipse.scout.sdk.core.model.spi.internal.BindingTypeWithJdt;
import org.eclipse.scout.sdk.core.model.spi.internal.JavaEnvironmentWithJdt;
import org.eclipse.scout.sdk.core.model.spi.internal.SpiWithJdtUtils;

public class BindingFieldWithJdt
extends AbstractMemberWithJdt<IField>
implements FieldSpi {
    private final AbstractTypeWithJdt m_declaringType;
    private final FieldBinding m_binding;
    private int m_flags;
    private String m_name;
    private TypeSpi m_type;
    private List<BindingAnnotationWithJdt> m_annotations;
    private AtomicReference<IMetaValue> m_constRef;
    private FieldSpi m_originalField;
    private ISourceRange m_source;
    private ISourceRange m_initializerSource;
    private ISourceRange m_javaDocSource;

    BindingFieldWithJdt(JavaEnvironmentWithJdt env, AbstractTypeWithJdt declaringType, FieldBinding binding) {
        super(env);
        this.m_declaringType = (AbstractTypeWithJdt)Validate.notNull((Object)declaringType);
        this.m_binding = (FieldBinding)Validate.notNull((Object)binding);
        this.m_flags = -1;
    }

    @Override
    protected JavaElementSpi internalFindNewElement(JavaEnvironmentWithJdt newEnv) {
        TypeSpi newType = (TypeSpi)this.getDeclaringType().internalFindNewElement(newEnv);
        if (newType != null) {
            for (FieldSpi newF : newType.getFields()) {
                if (!this.getElementName().equals(newF.getElementName())) continue;
                return newF;
            }
        }
        return null;
    }

    @Override
    protected IField internalCreateApi() {
        return new FieldImplementor(this);
    }

    public FieldBinding getInternalBinding() {
        return this.m_binding;
    }

    @Override
    public AbstractTypeWithJdt getDeclaringType() {
        return this.m_declaringType;
    }

    @Override
    public int getFlags() {
        if (this.m_flags < 0) {
            this.m_flags = SpiWithJdtUtils.getTypeFlags(this.m_binding.modifiers, null, SpiWithJdtUtils.hasDeprecatedAnnotation(this.m_binding.getAnnotations()));
        }
        return this.m_flags;
    }

    @Override
    public TypeSpi getDataType() {
        if (this.m_type == null) {
            this.m_type = SpiWithJdtUtils.bindingToType(this.m_env, this.m_binding.type);
        }
        return this.m_type;
    }

    public List<BindingAnnotationWithJdt> getAnnotations() {
        if (this.m_annotations != null) {
            return this.m_annotations;
        }
        this.m_annotations = SpiWithJdtUtils.createBindingAnnotations(this.m_env, this, this.m_binding.getAnnotations());
        return this.m_annotations;
    }

    @Override
    public String getElementName() {
        if (this.m_name == null) {
            this.m_name = new String(this.m_binding.name);
        }
        return this.m_name;
    }

    @Override
    public IMetaValue getConstantValue() {
        if (this.m_constRef == null) {
            IMetaValue resolvedValue = SpiWithJdtUtils.resolveCompiledValue(this.m_env, this, this.m_binding.constant());
            if (resolvedValue != null) {
                this.m_constRef = new AtomicReference<IMetaValue>(resolvedValue);
                return this.m_constRef.get();
            }
            FieldBinding origBinding = this.m_binding.original();
            ReferenceBinding refBinding = origBinding.declaringClass;
            if (refBinding instanceof SourceTypeBinding) {
                SourceTypeBinding stb = (SourceTypeBinding)refBinding;
                Expression initEx = stb.scope.referenceContext.declarationOf((FieldBinding)origBinding).initialization;
                resolvedValue = SpiWithJdtUtils.resolveCompiledValue(this.m_env, this, SpiWithJdtUtils.compileExpression(initEx, SpiWithJdtUtils.classScopeOf(this)));
                if (resolvedValue != null) {
                    this.m_constRef = new AtomicReference<IMetaValue>(resolvedValue);
                    return this.m_constRef.get();
                }
            }
            this.m_constRef = new AtomicReference<Object>(null);
        }
        return this.m_constRef.get();
    }

    @Override
    public FieldSpi getOriginalField() {
        if (this.m_originalField == null) {
            FieldBinding ref = this.m_binding.original();
            if (ref == null || ref == this.m_binding) {
                this.m_originalField = this;
            } else {
                BindingTypeWithJdt refType = (BindingTypeWithJdt)this.m_declaringType.getOriginalType();
                this.m_originalField = this.m_env.createBindingField(refType, ref);
            }
        }
        return this.m_originalField;
    }

    @Override
    public List<TypeParameterSpi> getTypeParameters() {
        return Collections.emptyList();
    }

    @Override
    public boolean hasTypeParameters() {
        return false;
    }

    @Override
    public ISourceRange getSource() {
        if (this.m_source == null) {
            FieldDeclaration decl = this.m_binding.sourceField();
            if (decl != null) {
                CompilationUnitSpi cu = this.m_declaringType.getCompilationUnit();
                this.m_source = this.m_env.getSource(cu, decl.declarationSourceStart, decl.declarationSourceEnd);
            } else {
                this.m_source = ISourceRange.NO_SOURCE;
            }
        }
        return this.m_source;
    }

    @Override
    public ISourceRange getSourceOfInitializer() {
        if (this.m_initializerSource == null) {
            Expression expr;
            FieldDeclaration decl = this.m_binding.sourceField();
            if (decl != null && (expr = decl.initialization) != null) {
                CompilationUnitSpi cu = this.m_declaringType.getCompilationUnit();
                this.m_initializerSource = this.m_env.getSource(cu, expr.sourceStart, expr.sourceEnd);
            }
            if (this.m_initializerSource == null) {
                this.m_initializerSource = ISourceRange.NO_SOURCE;
            }
        }
        return this.m_initializerSource;
    }

    @Override
    public ISourceRange getJavaDoc() {
        if (this.m_javaDocSource == null) {
            Javadoc doc;
            FieldDeclaration decl = this.m_binding.sourceField();
            if (decl != null && (doc = decl.javadoc) != null) {
                CompilationUnitSpi cu = this.m_declaringType.getCompilationUnit();
                this.m_javaDocSource = this.m_env.getSource(cu, doc.sourceStart, doc.sourceEnd);
            }
            if (this.m_javaDocSource == null) {
                this.m_javaDocSource = ISourceRange.NO_SOURCE;
            }
        }
        return this.m_javaDocSource;
    }
}

