/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.model.spi.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.Validate;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Javadoc;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;
import org.eclipse.scout.sdk.core.model.api.IMethod;
import org.eclipse.scout.sdk.core.model.api.ISourceRange;
import org.eclipse.scout.sdk.core.model.api.internal.MethodImplementor;
import org.eclipse.scout.sdk.core.model.spi.CompilationUnitSpi;
import org.eclipse.scout.sdk.core.model.spi.JavaElementSpi;
import org.eclipse.scout.sdk.core.model.spi.MethodParameterSpi;
import org.eclipse.scout.sdk.core.model.spi.MethodSpi;
import org.eclipse.scout.sdk.core.model.spi.TypeParameterSpi;
import org.eclipse.scout.sdk.core.model.spi.TypeSpi;
import org.eclipse.scout.sdk.core.model.spi.internal.AbstractMemberWithJdt;
import org.eclipse.scout.sdk.core.model.spi.internal.BindingAnnotationWithJdt;
import org.eclipse.scout.sdk.core.model.spi.internal.BindingTypeParameterWithJdt;
import org.eclipse.scout.sdk.core.model.spi.internal.BindingTypeWithJdt;
import org.eclipse.scout.sdk.core.model.spi.internal.JavaEnvironmentWithJdt;
import org.eclipse.scout.sdk.core.model.spi.internal.SpiWithJdtUtils;

public class BindingMethodWithJdt
extends AbstractMemberWithJdt<IMethod>
implements MethodSpi {
    private final BindingTypeWithJdt m_declaringType;
    private final MethodBinding m_binding;
    private TypeSpi m_returnType;
    private List<BindingAnnotationWithJdt> m_annotations;
    private int m_flags;
    private String m_name;
    private List<TypeSpi> m_exceptions;
    private List<MethodParameterSpi> m_arguments;
    private List<TypeParameterSpi> m_typeParameters;
    private MethodSpi m_originalMethod;
    private ISourceRange m_source;
    private ISourceRange m_bodySource;
    private ISourceRange m_javaDocSource;

    BindingMethodWithJdt(JavaEnvironmentWithJdt env, BindingTypeWithJdt declaringType, MethodBinding binding) {
        super(env);
        this.m_declaringType = (BindingTypeWithJdt)Validate.notNull((Object)declaringType);
        this.m_binding = (MethodBinding)Validate.notNull((Object)binding);
        this.m_flags = -1;
    }

    @Override
    protected JavaElementSpi internalFindNewElement(JavaEnvironmentWithJdt newEnv) {
        TypeSpi newType = (TypeSpi)this.getDeclaringType().internalFindNewElement(newEnv);
        if (newType != null) {
            String oldSig = SpiWithJdtUtils.createMethodId(this);
            for (MethodSpi newM : newType.getMethods()) {
                if (!oldSig.equals(SpiWithJdtUtils.createMethodId(newM))) continue;
                return newM;
            }
        }
        return null;
    }

    @Override
    protected IMethod internalCreateApi() {
        return new MethodImplementor(this);
    }

    public MethodBinding getInternalBinding() {
        return this.m_binding;
    }

    public List<BindingAnnotationWithJdt> getAnnotations() {
        if (this.m_annotations != null) {
            return this.m_annotations;
        }
        MethodBinding refMethod = this.m_binding;
        if (this.m_binding.original() != null) {
            refMethod = this.m_binding.original();
        }
        this.m_annotations = SpiWithJdtUtils.createBindingAnnotations(this.m_env, this, refMethod.getAnnotations());
        return this.m_annotations;
    }

    @Override
    public int getFlags() {
        if (this.m_flags < 0) {
            this.m_flags = SpiWithJdtUtils.getMethodFlags(this.m_binding.modifiers, false, SpiWithJdtUtils.hasDeprecatedAnnotation(this.m_binding.getAnnotations()));
        }
        return this.m_flags;
    }

    @Override
    public String getElementName() {
        if (this.m_name == null) {
            this.m_name = this.m_binding.isConstructor() ? this.m_declaringType.getElementName() : new String(this.m_binding.selector);
        }
        return this.m_name;
    }

    @Override
    public List<TypeSpi> getExceptionTypes() {
        if (this.m_exceptions == null) {
            ReferenceBinding[] exceptions = this.m_binding.thrownExceptions;
            if (exceptions == null || exceptions.length < 1) {
                this.m_exceptions = Collections.emptyList();
            } else {
                ArrayList<TypeSpi> result = new ArrayList<TypeSpi>(exceptions.length);
                ReferenceBinding[] referenceBindingArray = exceptions;
                int n = exceptions.length;
                int n2 = 0;
                while (n2 < n) {
                    ReferenceBinding r = referenceBindingArray[n2];
                    TypeSpi t = SpiWithJdtUtils.bindingToType(this.m_env, (TypeBinding)r);
                    if (t != null) {
                        result.add(t);
                    }
                    ++n2;
                }
                this.m_exceptions = result;
            }
        }
        return this.m_exceptions;
    }

    @Override
    public TypeSpi getReturnType() {
        if (this.m_returnType == null && !this.isConstructor()) {
            this.m_returnType = SpiWithJdtUtils.bindingToType(this.m_env, this.m_binding.returnType);
        }
        return this.m_returnType;
    }

    @Override
    public List<MethodParameterSpi> getParameters() {
        if (this.m_arguments == null) {
            TypeBinding[] arguments = this.m_binding.parameters;
            if (arguments == null || arguments.length < 1) {
                this.m_arguments = Collections.emptyList();
            } else {
                ArrayList<MethodParameterSpi> result = new ArrayList<MethodParameterSpi>(arguments.length);
                int i = 0;
                while (i < arguments.length) {
                    char[] name = BindingMethodWithJdt.getParamName(this.m_binding, i);
                    if (name == null && (name = BindingMethodWithJdt.getParamName(this.m_binding.original(), i)) == null) {
                        name = ("arg" + i).toCharArray();
                    }
                    result.add(this.m_env.createBindingMethodParameter(this, arguments[i], name, i));
                    ++i;
                }
                this.m_arguments = result;
            }
        }
        return this.m_arguments;
    }

    protected static char[] getParamName(MethodBinding b, int paramIndex) {
        if (b.parameterNames.length > paramIndex) {
            return b.parameterNames[paramIndex];
        }
        AbstractMethodDeclaration sourceMethod = b.sourceMethod();
        if (sourceMethod != null && sourceMethod.arguments.length > paramIndex) {
            return sourceMethod.arguments[paramIndex].name;
        }
        return null;
    }

    protected TypeVariableBinding[] getTypeVariables() {
        MethodBinding refMethod = this.m_binding.original() != null ? this.m_binding.original() : this.m_binding;
        return refMethod.typeVariables();
    }

    @Override
    public boolean hasTypeParameters() {
        TypeVariableBinding[] typeVariables = this.getTypeVariables();
        return typeVariables != null && typeVariables.length > 0;
    }

    @Override
    public List<TypeParameterSpi> getTypeParameters() {
        if (this.m_typeParameters != null) {
            return this.m_typeParameters;
        }
        TypeVariableBinding[] typeParams = this.getTypeVariables();
        if (typeParams != null && typeParams.length > 0) {
            ArrayList<BindingTypeParameterWithJdt> result = new ArrayList<BindingTypeParameterWithJdt>(typeParams.length);
            int index = 0;
            TypeVariableBinding[] typeVariableBindingArray = typeParams;
            int n = typeParams.length;
            int n2 = 0;
            while (n2 < n) {
                TypeVariableBinding param = typeVariableBindingArray[n2];
                result.add(this.m_env.createBindingTypeParameter(this, param, index));
                ++index;
                ++n2;
            }
            this.m_typeParameters = Collections.unmodifiableList(result);
        } else {
            this.m_typeParameters = Collections.emptyList();
        }
        return this.m_typeParameters;
    }

    @Override
    public MethodSpi getOriginalMethod() {
        if (this.m_originalMethod == null) {
            MethodBinding ref = this.m_binding.original();
            if (ref == null || ref == this.m_binding) {
                this.m_originalMethod = this;
            } else {
                BindingTypeWithJdt refType = (BindingTypeWithJdt)this.m_declaringType.getOriginalType();
                this.m_originalMethod = this.m_env.createBindingMethod(refType, ref);
            }
        }
        return this.m_originalMethod;
    }

    @Override
    public BindingTypeWithJdt getDeclaringType() {
        return this.m_declaringType;
    }

    @Override
    public boolean isConstructor() {
        return this.m_binding.isConstructor();
    }

    @Override
    public ISourceRange getSource() {
        if (this.m_source == null) {
            AbstractMethodDeclaration decl = this.m_binding.sourceMethod();
            if (decl != null) {
                CompilationUnitSpi cu = this.m_declaringType.getCompilationUnit();
                this.m_source = this.m_env.getSource(cu, decl.declarationSourceStart, decl.declarationSourceEnd);
            } else {
                this.m_source = ISourceRange.NO_SOURCE;
            }
        }
        return this.m_source;
    }

    @Override
    public ISourceRange getSourceOfBody() {
        if (this.m_bodySource == null) {
            AbstractMethodDeclaration decl = this.m_binding.sourceMethod();
            if (decl != null) {
                CompilationUnitSpi cu = this.m_declaringType.getCompilationUnit();
                this.m_bodySource = this.m_env.getSource(cu, decl.bodyStart, decl.bodyEnd);
            } else {
                this.m_bodySource = ISourceRange.NO_SOURCE;
            }
        }
        return this.m_bodySource;
    }

    @Override
    public ISourceRange getJavaDoc() {
        if (this.m_javaDocSource == null) {
            Javadoc doc;
            AbstractMethodDeclaration decl = this.m_binding.sourceMethod();
            if (decl != null && (doc = decl.javadoc) != null) {
                CompilationUnitSpi cu = this.m_declaringType.getCompilationUnit();
                this.m_javaDocSource = this.m_env.getSource(cu, doc.sourceStart, doc.sourceEnd);
            }
            if (this.m_javaDocSource == null) {
                this.m_javaDocSource = ISourceRange.NO_SOURCE;
            }
        }
        return this.m_javaDocSource;
    }
}

