/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.model.spi.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.Validate;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ast.TypeParameter;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;
import org.eclipse.scout.sdk.core.model.api.ISourceRange;
import org.eclipse.scout.sdk.core.model.api.ITypeParameter;
import org.eclipse.scout.sdk.core.model.api.internal.TypeParameterImplementor;
import org.eclipse.scout.sdk.core.model.spi.CompilationUnitSpi;
import org.eclipse.scout.sdk.core.model.spi.JavaElementSpi;
import org.eclipse.scout.sdk.core.model.spi.MemberSpi;
import org.eclipse.scout.sdk.core.model.spi.TypeParameterSpi;
import org.eclipse.scout.sdk.core.model.spi.TypeSpi;
import org.eclipse.scout.sdk.core.model.spi.internal.AbstractJavaElementWithJdt;
import org.eclipse.scout.sdk.core.model.spi.internal.AbstractMemberWithJdt;
import org.eclipse.scout.sdk.core.model.spi.internal.JavaEnvironmentWithJdt;
import org.eclipse.scout.sdk.core.model.spi.internal.SpiWithJdtUtils;

public class BindingTypeParameterWithJdt
extends AbstractJavaElementWithJdt<ITypeParameter>
implements TypeParameterSpi {
    private final AbstractMemberWithJdt<?> m_declaringMember;
    private final TypeVariableBinding m_binding;
    private final int m_index;
    private String m_name;
    private List<TypeSpi> m_bounds;
    private ISourceRange m_source;

    BindingTypeParameterWithJdt(JavaEnvironmentWithJdt env, AbstractMemberWithJdt<?> declaringMember, TypeVariableBinding binding, int index) {
        super(env);
        this.m_declaringMember = (AbstractMemberWithJdt)Validate.notNull(declaringMember);
        this.m_binding = (TypeVariableBinding)Validate.notNull((Object)binding);
        this.m_index = index;
    }

    @Override
    protected JavaElementSpi internalFindNewElement(JavaEnvironmentWithJdt newEnv) {
        MemberSpi newMember = (MemberSpi)((AbstractJavaElementWithJdt)((Object)this.getDeclaringMember())).internalFindNewElement(newEnv);
        if (newMember != null && newMember.getTypeParameters().size() > this.m_index) {
            return newMember.getTypeParameters().get(this.m_index);
        }
        return null;
    }

    @Override
    protected ITypeParameter internalCreateApi() {
        return new TypeParameterImplementor(this);
    }

    public TypeVariableBinding getInternalBinding() {
        return this.m_binding;
    }

    @Override
    public String getElementName() {
        if (this.m_name == null) {
            this.m_name = new String(this.m_binding.sourceName());
        }
        return this.m_name;
    }

    @Override
    public List<TypeSpi> getBounds() {
        TypeSpi t;
        if (this.m_bounds != null) {
            return this.m_bounds;
        }
        ReferenceBinding superclass = this.m_binding.superclass();
        ReferenceBinding[] superInterfaces = this.m_binding.superInterfaces();
        boolean hasSuperClass = superclass != null && !CharOperation.equals((char[][])superclass.compoundName, (char[][])TypeConstants.JAVA_LANG_OBJECT);
        boolean hasSuperInterfaces = superInterfaces != null && superInterfaces.length > 0;
        int size = 0;
        if (hasSuperClass) {
            ++size;
        }
        if (hasSuperInterfaces) {
            size += superInterfaces.length;
        }
        ArrayList<TypeSpi> bounds = new ArrayList<TypeSpi>(size);
        if (hasSuperClass && (t = SpiWithJdtUtils.bindingToType(this.m_env, (TypeBinding)superclass)) != null) {
            bounds.add(t);
        }
        if (hasSuperInterfaces) {
            ReferenceBinding[] referenceBindingArray = superInterfaces;
            int n = superInterfaces.length;
            int n2 = 0;
            while (n2 < n) {
                ReferenceBinding b = referenceBindingArray[n2];
                TypeSpi t2 = SpiWithJdtUtils.bindingToType(this.m_env, (TypeBinding)b);
                if (t2 != null) {
                    bounds.add(t2);
                }
                ++n2;
            }
        }
        this.m_bounds = Collections.unmodifiableList(bounds);
        return this.m_bounds;
    }

    @Override
    public AbstractMemberWithJdt<?> getDeclaringMember() {
        return this.m_declaringMember;
    }

    @Override
    public ISourceRange getSource() {
        if (this.m_source == null) {
            TypeParameter decl = SpiWithJdtUtils.classScopeOf((JavaElementSpi)this).referenceContext.typeParameters[this.m_index];
            if (decl != null) {
                CompilationUnitSpi cu = SpiWithJdtUtils.declaringTypeOf(this).getCompilationUnit();
                this.m_source = this.m_env.getSource(cu, decl.declarationSourceStart, decl.declarationSourceEnd);
            } else {
                this.m_source = ISourceRange.NO_SOURCE;
            }
        }
        return this.m_source;
    }
}

