/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.model.spi.internal;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.Validate;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Initializer;
import org.eclipse.jdt.internal.compiler.ast.Javadoc;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.scout.sdk.core.model.api.IField;
import org.eclipse.scout.sdk.core.model.api.IMetaValue;
import org.eclipse.scout.sdk.core.model.api.ISourceRange;
import org.eclipse.scout.sdk.core.model.api.internal.FieldImplementor;
import org.eclipse.scout.sdk.core.model.spi.CompilationUnitSpi;
import org.eclipse.scout.sdk.core.model.spi.FieldSpi;
import org.eclipse.scout.sdk.core.model.spi.JavaElementSpi;
import org.eclipse.scout.sdk.core.model.spi.TypeParameterSpi;
import org.eclipse.scout.sdk.core.model.spi.TypeSpi;
import org.eclipse.scout.sdk.core.model.spi.internal.AbstractMemberWithJdt;
import org.eclipse.scout.sdk.core.model.spi.internal.DeclarationAnnotationWithJdt;
import org.eclipse.scout.sdk.core.model.spi.internal.DeclarationTypeWithJdt;
import org.eclipse.scout.sdk.core.model.spi.internal.JavaEnvironmentWithJdt;
import org.eclipse.scout.sdk.core.model.spi.internal.SpiWithJdtUtils;

public class DeclarationFieldWithJdt
extends AbstractMemberWithJdt<IField>
implements FieldSpi {
    private final DeclarationTypeWithJdt m_declaringType;
    private final FieldDeclaration m_astNode;
    private final char[] m_name;
    private int m_flags;
    private String m_nameS;
    private TypeSpi m_type;
    private List<DeclarationAnnotationWithJdt> m_annotations;
    private AtomicReference<IMetaValue> m_constRef;
    private ISourceRange m_source;
    private ISourceRange m_initSource;
    private ISourceRange m_javaDocSource;

    DeclarationFieldWithJdt(JavaEnvironmentWithJdt env, DeclarationTypeWithJdt declaringType, FieldDeclaration astNode) {
        super(env);
        this.m_declaringType = (DeclarationTypeWithJdt)Validate.notNull((Object)declaringType);
        this.m_astNode = (FieldDeclaration)Validate.notNull((Object)astNode);
        this.m_name = astNode.name != null ? astNode.name : new char[]{};
        this.m_flags = -1;
    }

    @Override
    protected JavaElementSpi internalFindNewElement(JavaEnvironmentWithJdt newEnv) {
        TypeSpi newType = (TypeSpi)this.getDeclaringType().internalFindNewElement(newEnv);
        if (newType != null) {
            for (FieldSpi newF : newType.getFields()) {
                if (!this.getElementName().equals(newF.getElementName())) continue;
                return newF;
            }
        }
        return null;
    }

    @Override
    protected IField internalCreateApi() {
        return new FieldImplementor(this);
    }

    public FieldDeclaration getInternalFieldDeclaration() {
        return this.m_astNode;
    }

    @Override
    public DeclarationTypeWithJdt getDeclaringType() {
        return this.m_declaringType;
    }

    @Override
    public IMetaValue getConstantValue() {
        if (this.m_constRef == null) {
            Object compiledValue;
            IMetaValue resolvedValue;
            if (this.m_astNode.initialization != null && (resolvedValue = SpiWithJdtUtils.resolveCompiledValue(this.m_env, this, compiledValue = SpiWithJdtUtils.compileExpression(this.m_astNode.initialization, null))) != null) {
                this.m_constRef = new AtomicReference<IMetaValue>(resolvedValue);
                return this.m_constRef.get();
            }
            this.m_constRef = new AtomicReference<Object>(null);
        }
        return this.m_constRef.get();
    }

    @Override
    public TypeSpi getDataType() {
        if (this.m_type == null) {
            if (this.m_astNode.type == null) {
                this.m_type = this.m_env.createVoidType();
                return this.m_type;
            }
            TypeBinding tb = this.m_astNode.type.resolvedType;
            if (tb == null) {
                tb = this.m_astNode.type.resolveType(SpiWithJdtUtils.classScopeOf(this));
            }
            this.m_type = SpiWithJdtUtils.bindingToType(this.m_env, tb);
        }
        return this.m_type;
    }

    public List<DeclarationAnnotationWithJdt> getAnnotations() {
        if (this.m_annotations != null) {
            return this.m_annotations;
        }
        this.m_annotations = SpiWithJdtUtils.createDeclarationAnnotations(this.m_env, this, this.m_astNode.annotations);
        return this.m_annotations;
    }

    @Override
    public int getFlags() {
        if (this.m_flags < 0) {
            this.m_flags = SpiWithJdtUtils.getTypeFlags(this.m_astNode.modifiers, null, SpiWithJdtUtils.hasDeprecatedAnnotation(this.m_astNode.annotations));
        }
        return this.m_flags;
    }

    @Override
    public String getElementName() {
        if (this.m_nameS == null) {
            this.m_nameS = new String(this.m_name);
        }
        return this.m_nameS;
    }

    @Override
    public FieldSpi getOriginalField() {
        return this;
    }

    @Override
    public List<TypeParameterSpi> getTypeParameters() {
        return Collections.emptyList();
    }

    @Override
    public boolean hasTypeParameters() {
        return false;
    }

    @Override
    public ISourceRange getSource() {
        if (this.m_source == null) {
            CompilationUnitSpi cu = this.m_declaringType.getCompilationUnit();
            FieldDeclaration decl = this.m_astNode;
            this.m_source = this.m_env.getSource(cu, decl.declarationSourceStart, decl.declarationSourceEnd);
        }
        return this.m_source;
    }

    @Override
    public ISourceRange getSourceOfInitializer() {
        if (this.m_initSource == null) {
            CompilationUnitSpi cu = this.m_declaringType.getCompilationUnit();
            if (this.m_astNode instanceof Initializer) {
                Initializer decl = (Initializer)this.m_astNode;
                this.m_initSource = this.m_env.getSource(cu, decl.declarationSourceStart, decl.declarationSourceEnd);
            } else {
                Expression decl = this.m_astNode.initialization;
                this.m_initSource = decl != null ? this.m_env.getSource(cu, decl.sourceStart, decl.sourceEnd) : ISourceRange.NO_SOURCE;
            }
        }
        return this.m_initSource;
    }

    @Override
    public ISourceRange getJavaDoc() {
        if (this.m_javaDocSource == null) {
            FieldDeclaration decl = this.m_astNode;
            Javadoc doc = decl.javadoc;
            if (doc != null) {
                CompilationUnitSpi cu = this.m_declaringType.getCompilationUnit();
                this.m_javaDocSource = this.m_env.getSource(cu, doc.sourceStart, doc.sourceEnd);
            } else {
                this.m_javaDocSource = ISourceRange.NO_SOURCE;
            }
        }
        return this.m_javaDocSource;
    }
}

