/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.model.spi.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.Validate;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Javadoc;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeParameter;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.scout.sdk.core.model.api.ISourceRange;
import org.eclipse.scout.sdk.core.model.api.IType;
import org.eclipse.scout.sdk.core.model.api.internal.TypeImplementor;
import org.eclipse.scout.sdk.core.model.spi.CompilationUnitSpi;
import org.eclipse.scout.sdk.core.model.spi.FieldSpi;
import org.eclipse.scout.sdk.core.model.spi.JavaElementSpi;
import org.eclipse.scout.sdk.core.model.spi.MethodSpi;
import org.eclipse.scout.sdk.core.model.spi.PackageSpi;
import org.eclipse.scout.sdk.core.model.spi.TypeParameterSpi;
import org.eclipse.scout.sdk.core.model.spi.TypeSpi;
import org.eclipse.scout.sdk.core.model.spi.internal.AbstractTypeWithJdt;
import org.eclipse.scout.sdk.core.model.spi.internal.BindingTypeWithJdt;
import org.eclipse.scout.sdk.core.model.spi.internal.DeclarationAnnotationWithJdt;
import org.eclipse.scout.sdk.core.model.spi.internal.DeclarationFieldWithJdt;
import org.eclipse.scout.sdk.core.model.spi.internal.DeclarationMethodWithJdt;
import org.eclipse.scout.sdk.core.model.spi.internal.DeclarationTypeParameterWithJdt;
import org.eclipse.scout.sdk.core.model.spi.internal.JavaEnvironmentWithJdt;
import org.eclipse.scout.sdk.core.model.spi.internal.SpiWithJdtUtils;

public class DeclarationTypeWithJdt
extends AbstractTypeWithJdt {
    private final CompilationUnitSpi m_cu;
    private final DeclarationTypeWithJdt m_declaringType;
    private final TypeDeclaration m_astNode;
    private final String m_fqn;
    private final List<TypeSpi> m_typeArguments;
    private PackageSpi m_package;
    private String m_elementName;
    private TypeSpi m_superType;
    private List<TypeSpi> m_memberTypes;
    private List<TypeSpi> m_superInterfaces;
    private List<TypeParameterSpi> m_typeParameters;
    private List<DeclarationAnnotationWithJdt> m_annotations;
    private List<MethodSpi> m_methods;
    private List<FieldSpi> m_fields;
    private int m_flags;
    private ISourceRange m_source;
    private ISourceRange m_javaDocSource;
    private ISourceRange m_staticInitSource;

    DeclarationTypeWithJdt(JavaEnvironmentWithJdt env, CompilationUnitSpi cu, DeclarationTypeWithJdt declaringType, TypeDeclaration astNode) {
        super(env);
        this.m_cu = (CompilationUnitSpi)Validate.notNull((Object)cu);
        this.m_declaringType = declaringType;
        this.m_astNode = (TypeDeclaration)Validate.notNull((Object)astNode);
        this.m_typeArguments = Collections.emptyList();
        this.m_fqn = DeclarationTypeWithJdt.calcFullyQualifiedName(astNode);
        this.m_flags = -1;
    }

    @Override
    protected JavaElementSpi internalFindNewElement(JavaEnvironmentWithJdt newEnv) {
        BindingTypeWithJdt newSpi = (BindingTypeWithJdt)newEnv.findType(this.getName());
        if (newSpi != null) {
            for (TypeSpi typeSpi : newSpi.getCompilationUnit().getTypes()) {
                if (!typeSpi.getName().equals(this.getName())) continue;
                return typeSpi;
            }
        }
        return null;
    }

    @Override
    public TypeBinding getInternalBinding() {
        return null;
    }

    @Override
    protected IType internalCreateApi() {
        return new TypeImplementor(this);
    }

    public TypeDeclaration getInternalTypeDeclaration() {
        return this.m_astNode;
    }

    @Override
    public boolean isArray() {
        return false;
    }

    @Override
    public int getArrayDimension() {
        return 0;
    }

    @Override
    public TypeSpi getLeafComponentType() {
        return null;
    }

    @Override
    public boolean isPrimitive() {
        return false;
    }

    @Override
    public boolean isAnonymous() {
        return this.m_astNode.name == null || this.m_astNode.name.length < 1;
    }

    @Override
    public String getName() {
        return this.m_fqn;
    }

    @Override
    public String getElementName() {
        if (this.m_elementName == null) {
            this.m_elementName = new String(this.m_astNode.name);
        }
        return this.m_elementName;
    }

    @Override
    public PackageSpi getPackage() {
        if (this.m_package == null) {
            char[] qualifiedPackageName = this.m_astNode.binding.qualifiedPackageName();
            this.m_package = qualifiedPackageName != null && qualifiedPackageName.length > 0 ? this.m_env.createPackage(new String(qualifiedPackageName)) : this.m_env.createDefaultPackage();
        }
        return this.m_package;
    }

    public List<DeclarationAnnotationWithJdt> getAnnotations() {
        if (this.m_annotations != null) {
            return this.m_annotations;
        }
        this.m_annotations = SpiWithJdtUtils.createDeclarationAnnotations(this.m_env, this, this.m_astNode.annotations);
        return this.m_annotations;
    }

    @Override
    public List<FieldSpi> getFields() {
        if (this.m_fields != null) {
            return this.m_fields;
        }
        FieldDeclaration[] fields = this.m_astNode.fields;
        if (fields == null || fields.length < 1) {
            this.m_fields = Collections.emptyList();
        } else {
            ArrayList<DeclarationFieldWithJdt> result = new ArrayList<DeclarationFieldWithJdt>(fields.length);
            FieldDeclaration[] fieldDeclarationArray = fields;
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                FieldDeclaration fd = fieldDeclarationArray[n2];
                result.add(this.m_env.createDeclarationField(this, fd));
                ++n2;
            }
            this.m_fields = Collections.unmodifiableList(result);
        }
        return this.m_fields;
    }

    @Override
    public List<MethodSpi> getMethods() {
        if (this.m_methods != null) {
            return this.m_methods;
        }
        AbstractMethodDeclaration[] methods = this.m_astNode.methods;
        if (methods == null || methods.length < 1) {
            this.m_methods = Collections.emptyList();
        } else {
            ArrayList<DeclarationMethodWithJdt> result = new ArrayList<DeclarationMethodWithJdt>(methods.length);
            AbstractMethodDeclaration[] abstractMethodDeclarationArray = methods;
            int n = methods.length;
            int n2 = 0;
            while (n2 < n) {
                AbstractMethodDeclaration a = abstractMethodDeclarationArray[n2];
                if (a.bodyStart > 0 && !"<init>".equals(new String(a.selector))) {
                    result.add(this.m_env.createDeclarationMethod(this, a));
                }
                ++n2;
            }
            this.m_methods = Collections.unmodifiableList(result);
        }
        return this.m_methods;
    }

    @Override
    public List<TypeSpi> getTypes() {
        if (this.m_memberTypes != null) {
            return this.m_memberTypes;
        }
        TypeDeclaration[] memberTypes = this.m_astNode.memberTypes;
        if (memberTypes == null || memberTypes.length < 1) {
            this.m_memberTypes = Collections.emptyList();
        } else {
            ArrayList<DeclarationTypeWithJdt> result = new ArrayList<DeclarationTypeWithJdt>(memberTypes.length);
            TypeDeclaration[] typeDeclarationArray = memberTypes;
            int n = memberTypes.length;
            int n2 = 0;
            while (n2 < n) {
                TypeDeclaration d = typeDeclarationArray[n2];
                result.add(new DeclarationTypeWithJdt(this.m_env, this.m_cu, this, d));
                ++n2;
            }
            this.m_memberTypes = Collections.unmodifiableList(result);
        }
        return this.m_memberTypes;
    }

    @Override
    public TypeSpi getSuperClass() {
        if (this.m_superType == null) {
            TypeBinding tb;
            this.m_superType = this.m_astNode.superclass == null ? null : ((tb = this.m_astNode.superclass.resolvedType) == null ? null : SpiWithJdtUtils.bindingToType(this.m_env, tb));
        }
        return this.m_superType;
    }

    @Override
    public List<TypeSpi> getSuperInterfaces() {
        if (this.m_superInterfaces != null) {
            return this.m_superInterfaces;
        }
        TypeReference[] refs = this.m_astNode.superInterfaces;
        if (refs == null || refs.length < 1) {
            this.m_superInterfaces = Collections.emptyList();
        } else {
            ArrayList<TypeSpi> result = new ArrayList<TypeSpi>(refs.length);
            TypeReference[] typeReferenceArray = refs;
            int n = refs.length;
            int n2 = 0;
            while (n2 < n) {
                TypeSpi t;
                TypeReference r = typeReferenceArray[n2];
                TypeBinding b = r.resolvedType;
                if (b != null && (t = SpiWithJdtUtils.bindingToType(this.m_env, b)) != null) {
                    result.add(t);
                }
                ++n2;
            }
            this.m_superInterfaces = Collections.unmodifiableList(result);
        }
        return this.m_superInterfaces;
    }

    @Override
    public int getFlags() {
        if (this.m_flags < 0) {
            this.m_flags = SpiWithJdtUtils.getTypeFlags(this.m_astNode.modifiers, this.m_astNode.allocation, SpiWithJdtUtils.hasDeprecatedAnnotation(this.m_astNode.annotations));
        }
        return this.m_flags;
    }

    @Override
    public List<TypeSpi> getTypeArguments() {
        return this.m_typeArguments;
    }

    @Override
    public List<TypeParameterSpi> getTypeParameters() {
        if (this.m_typeParameters != null) {
            return this.m_typeParameters;
        }
        TypeParameter[] typeParams = this.m_astNode.typeParameters;
        if (typeParams == null || typeParams.length < 1) {
            this.m_typeParameters = Collections.emptyList();
        } else {
            ArrayList<DeclarationTypeParameterWithJdt> result = new ArrayList<DeclarationTypeParameterWithJdt>(typeParams.length);
            int i = 0;
            while (i < typeParams.length) {
                result.add(this.m_env.createDeclarationTypeParameter(this, typeParams[i], i));
                ++i;
            }
            this.m_typeParameters = Collections.unmodifiableList(result);
        }
        return this.m_typeParameters;
    }

    @Override
    public boolean hasTypeParameters() {
        TypeParameter[] typeParams = this.m_astNode.typeParameters;
        return typeParams != null && typeParams.length > 0;
    }

    @Override
    public DeclarationTypeWithJdt getOriginalType() {
        return this;
    }

    @Override
    public CompilationUnitSpi getCompilationUnit() {
        return this.m_cu;
    }

    @Override
    public TypeSpi getDeclaringType() {
        return this.m_declaringType;
    }

    private static String calcFullyQualifiedName(TypeDeclaration td) {
        StringBuilder sb = new StringBuilder();
        char[] qualifiedPackageName = td.binding.qualifiedPackageName();
        if (qualifiedPackageName != null && qualifiedPackageName.length > 0) {
            sb.append(qualifiedPackageName);
            sb.append('.');
        }
        LinkedList<char[]> namesBottomUp = new LinkedList<char[]>();
        TypeDeclaration declaringType = td;
        while (declaringType != null) {
            namesBottomUp.add(declaringType.name);
            declaringType = declaringType.enclosingType;
        }
        Iterator namesTopDown = namesBottomUp.descendingIterator();
        sb.append((char[])namesTopDown.next());
        while (namesTopDown.hasNext()) {
            sb.append('$').append((char[])namesTopDown.next());
        }
        return sb.toString();
    }

    @Override
    public ISourceRange getSource() {
        if (this.m_source == null) {
            TypeDeclaration decl = this.m_astNode;
            this.m_source = this.m_env.getSource(this.m_cu, decl.declarationSourceStart, decl.declarationSourceEnd);
        }
        return this.m_source;
    }

    @Override
    public ISourceRange getSourceOfStaticInitializer() {
        if (this.m_staticInitSource == null) {
            TypeDeclaration decl = this.m_astNode;
            FieldDeclaration[] fieldDeclarationArray = decl.fields;
            int n = decl.fields.length;
            int n2 = 0;
            while (n2 < n) {
                FieldDeclaration fieldDecl = fieldDeclarationArray[n2];
                if (fieldDecl.type == null && fieldDecl.name == null) {
                    this.m_staticInitSource = this.m_env.getSource(this.m_cu, fieldDecl.declarationSourceStart, fieldDecl.declarationSourceEnd);
                    break;
                }
                ++n2;
            }
            if (this.m_staticInitSource == null) {
                this.m_staticInitSource = ISourceRange.NO_SOURCE;
            }
        }
        return this.m_staticInitSource;
    }

    @Override
    public ISourceRange getJavaDoc() {
        if (this.m_javaDocSource == null) {
            TypeDeclaration decl = this.m_astNode;
            Javadoc doc = decl.javadoc;
            this.m_javaDocSource = doc != null ? this.m_env.getSource(this.m_cu, doc.sourceStart, doc.sourceEnd) : ISourceRange.NO_SOURCE;
        }
        return this.m_javaDocSource;
    }

    @Override
    public boolean isWildcardType() {
        return false;
    }
}

